package com.ejianc.business.labor.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.*;

/**
 * 业务bean超类
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
public class BaseEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 主键ID
	 */
	@TableField(fill = FieldFill.INSERT)
	@TableId(type = IdType.NONE)
	private Long id;

	/**
	 * 创建者账号
	 */
	@TableField(value = "create_user_code", fill = FieldFill.INSERT)
	private String createUserCode;

	/**
	 * 创建时间
	 */
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date createTime;

	/**
	 * 修改者账号
	 */
	@TableField(value = "update_user_code", fill = FieldFill.UPDATE)
	private String updateUserCode;

	/**
	 * 修改时间
	 */
	@TableField(value = "update_time", fill = FieldFill.UPDATE)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date updateTime;

	/**
	 * 删除标识（0：未删， 1：删除）
	 */
	@TableLogic
	@TableField(value = "dr")
	private Integer dr;

	/**
	 * 是否同步es
	 */
	@TableField(value = "sync_es_flag")
	private Integer syncEsFlag;

	/**
	 * 子表删除标志
	 */
	@TableField(exist = false)
	private String rowState;

	/**
	 * 附件ids
	 */
	@TableField(exist = false)
	private List<Long> attachIds = new ArrayList<>();

	@Version
	private Integer version;

	/**
	 * 自定义字段
	 */
	@TableField(exist = false)
	private Map<String, Object> customField = new HashMap<String, Object>();

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getCreateUserCode() {
		return createUserCode;
	}

	public void setCreateUserCode(String createUserCode) {
		this.createUserCode = createUserCode;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getUpdateUserCode() {
		return updateUserCode;
	}

	public void setUpdateUserCode(String updateUserCode) {
		this.updateUserCode = updateUserCode;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	public Integer getDr() {
		return dr;
	}

	public void setDr(Integer dr) {
		this.dr = dr;
	}

	public Integer getSyncEsFlag() {
		return syncEsFlag;
	}

	public void setSyncEsFlag(Integer syncEsFlag) {
		this.syncEsFlag = syncEsFlag;
	}

	public String getRowState() {
		return rowState;
	}

	public void setRowState(String rowState) {
		this.rowState = rowState;
	}

	public List<Long> getAttachIds() {
		return attachIds;
	}

	public void setAttachIds(List<Long> attachIds) {
		this.attachIds = attachIds;
	}

	public Integer getVersion() {
		return version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public Map<String, Object> getCustomField() {
		return customField;
	}

	public void setCustomField(Map<String, Object> customField) {
		this.customField = customField;
	}

}
