package com.ejianc.business.labor.common.config;

import org.hibernate.validator.HibernateValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

/**
 * 参数校验快速失败
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Configuration
public class FastFailConfig {

	@Bean
	public Validator validator() {
		ValidatorFactory validatorFactory = Validation.byProvider(HibernateValidator.class)
				.configure()
				.failFast(true)
				.buildValidatorFactory();
		return validatorFactory.getValidator();
	}

}
