package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.OvertimeApplyDetailEntity;
import com.ejianc.business.labor.bean.OvertimeApplyEntity;
import com.ejianc.business.labor.service.IOvertimeApplyDetailService;
import com.ejianc.business.labor.service.IOvertimeApplyService;
import com.ejianc.business.labor.vo.OvertimeApplyDetailVO;
import com.ejianc.business.labor.vo.OvertimeApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 加班申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("overtimeApply")
@Api(value = "加班申请", tags = {"加班申请"})
public class OvertimeApplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "JBSQ_CODE";

    @Autowired
    private IOvertimeApplyService service;
    @Autowired
    private IOvertimeApplyDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OvertimeApplyVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody OvertimeApplyVO saveOrUpdateVO) {
        OvertimeApplyEntity entity = BeanMapper.map(saveOrUpdateVO, OvertimeApplyEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        OvertimeApplyVO vo = BeanMapper.map(entity, OvertimeApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OvertimeApplyVO> queryDetail(@RequestParam Long id) {
        OvertimeApplyEntity entity = service.selectById(id);
        OvertimeApplyVO vo = BeanMapper.map(entity, OvertimeApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OvertimeApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OvertimeApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OvertimeApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OvertimeApplyVO>> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<OvertimeApplyEntity> page = service.queryPage(param, false);
        IPage<OvertimeApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OvertimeApplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }        List<OvertimeApplyEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<OvertimeApplyVO> overtimeApplyVOS = BeanMapper.mapList(list, OvertimeApplyVO.class);
        overtimeApplyVOS.stream().forEach(vo -> {
            vo.setBillStateStr(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", overtimeApplyVOS);
        ExcelExport.getInstance().export("OvertimeApply-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOvertimeApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OvertimeApplyVO>> refOvertimeApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("billCode", "projectName", "employeeName"));
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN,Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            if (con.containsKey("projectId")){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, con.getLong("projectId")));
            }
        }
//        servic
        IPage<OvertimeApplyEntity> page = service.queryPage(param, false);
        IPage<OvertimeApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OvertimeApplyVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOvertimeApplyDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OvertimeApplyDetailVO>> refOvertimeApplyDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                      String condition,
                                                                                      String searchObject,
                                                                                      String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("billCode", "projectName", "employeeName"));
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN,Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            if (con.containsKey("projectId")){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, con.getLong("projectId")));
            }
        }

        IPage<OvertimeApplyEntity> page = service.queryPage(param, false);
        IPage<OvertimeApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OvertimeApplyVO.class));

        return null;
    }
    @RequestMapping(value = "/queryOvertimeApplyDetailData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<OvertimeApplyDetailVO>> queryOvertimeApplyDetailData(@RequestBody List<OvertimeApplyDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            Long projectId = vos.get(0).getProjectId();
            Date overtimeDate = vos.get(0).getOvertimeDate();
            QueryWrapper<OvertimeApplyEntity> queryParam = new QueryWrapper();
            queryParam.eq("project_id",projectId);
            queryParam.eq("bill_state",Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                    BillStateEnum.PASSED_STATE.getBillStateCode()));
            queryParam.eq("bill_date",overtimeDate);
            List<OvertimeApplyEntity> list = service.list(queryParam);
            if (ListUtil.isNotEmpty(list)){
                List<Long> workIdS = vos.stream().map(e -> e.getWorkerId()).collect(Collectors.toList());
                OvertimeApplyEntity overtimeApplyEntity = list.get(0);
                overtimeApplyEntity.getId();
                QueryWrapper<OvertimeApplyDetailEntity> queryWrapper =  new QueryWrapper();
                queryWrapper.eq("apply_id",overtimeApplyEntity.getId());
                queryWrapper.in("worker_id",workIdS);
                List<OvertimeApplyDetailEntity> detailList =  detailService.list(queryWrapper);
                if (ListUtil.isNotEmpty(detailList)){
                    Map<Long, OvertimeApplyDetailEntity> collect = detailList.stream().collect(Collectors.toMap(e -> e.getWorkerId(), v -> v));
                    for (OvertimeApplyDetailVO det :vos){
                        if (collect.containsKey(det.getWorkerId())){
                            det.setOvertimeMny(collect.get(det.getWorkerId()).getOvertimeMny());
                            det.setOvertimeHours(collect.get(det.getWorkerId()).getOvertimeHours());
                        }
                    }
                }
            }
        }
        return CommonResponse.success(vos);
    }
}
