package com.ejianc.business.labor.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.labor.bean.AttendanceLogEntity;
import com.ejianc.business.labor.vo.AttendanceLogVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 考勤日志
 *
 * @author generator
 */
public interface IAttendanceLogService extends IBaseService<AttendanceLogEntity> {
	/**
	 * 获取openid
	 *
	 * @param code 临时登录凭证
	 *
	 * @return {@link JSONObject}
	 */
	String getOpenId(String code);


	/**
	 * 租户手机号绑定openid校验
	 *
	 * @param openid openid
	 *
	 * @return {@link String}
	 */
	String checkBind(String openid);


	/**
	 * 给指定手机号发送验证码或者短信
	 *
	 * @param phone        手机号
	 * @param templateCode 短信模板编码
	 * @param signName     短信签名
	 *
	 * @return {@link String}
	 *
	 * @throws Exception 异常
	 */
	String sendMsg(String phone, String templateCode, String signName) throws Exception;


	/**
	 * 登录
	 *
	 * @param phone        手机号
	 * @param templateCode 短信模版
	 * @param validate     验证码
	 * @param openid       openid
	 */
	void login(String phone, String templateCode, String validate, String openid);


	/**
	 * 获取用工记录
	 *
	 * @param projectId 项目id
	 * @param phone     电话号码
	 *
	 * @return {@link WorkRecordVO}
	 */
	WorkRecordVO fetchWorkRecord(Long projectId, String phone);


	/**
	 * 获取项目
	 *
	 * @param phone 手机号
	 *
	 * @return {@link List}<{@link JSONObject}>
	 */
	List<JSONObject> fetchProject(String phone);


	/**
	 * 校验人脸信息设置
	 *
	 * @param tenantId  租户id
	 * @param projectId 项目id
	 * @param phone     手机号
	 *
	 * @return {@link CommonResponse}<{@link String}>
	 */
	CommonResponse<String> checkFaceDataSetting(Long tenantId, Long projectId, String phone);


	/**
	 * 校验项目打卡权限
	 *
	 * @param tenantId  租户id
	 * @param projectId 项目id
	 * @param phone     手机号
	 */
	void checkPunchCardAuth(Long tenantId, Long projectId, String phone);


	/**
	 * 校验考勤范围
	 *
	 * @param projectId   项目id
	 * @param destination 当前位置经纬度
	 *
	 * @return {@link CommonResponse}<{@link JSONObject}>
	 */
	CommonResponse<JSONObject> checkDistance(Long projectId, String destination);


	/**
	 * 校验人脸
	 *
	 * @param tenantId   租户id
	 * @param projectId  项目id
	 * @param phone      手机号
	 * @param imgBase64A 待识别人脸照片base64编码
	 *
	 * @return {@link CommonResponse}<{@link WorkerVO}>
	 */
	CommonResponse<WorkerVO> checkFace(Long tenantId, Long projectId, String phone, String imgBase64A);


	/**
	 * 根据公司花名册id校验人脸
	 *
	 * @param workerId   公司花名册人员id
	 * @param imgBase64A 待识别人脸照片base64编码
	 *
	 * @return {@link CommonResponse}<{@link WorkRecordVO}>
	 */
	CommonResponse<WorkerVO> checkFaceByWorkerId(Long workerId, String imgBase64A);


	/**
	 * 校验已存在的打卡记录
	 *
	 * @param tenantId      租户id
	 * @param projectId     项目id
	 * @param s
	 * @param phone         手机号
	 * @param punchCardType 打卡类型：上班打卡、下班打卡
	 *
	 * @return {@link CommonResponse}<{@link List}<{@link AttendanceLogVO}>>
	 */
	CommonResponse<List<AttendanceLogVO>> checkExistedLog(Long tenantId, Long projectId, String phone, Long workerId, String punchCardType);


	/**
	 * 考勤打卡
	 *
	 * @param projectId      项目id
	 * @param workerId       公司花名册人员id
	 * @param punchCardType  打卡类型：上班打卡、下班打卡
	 * @param punchCardPlace 打卡地点
	 * @param remoteFlag     是否是异地打卡（1:是 0：否）
	 *
	 * @return {@link AttendanceLogVO}
	 */
	AttendanceLogVO punchCard(Long projectId, Long workerId, String punchCardType, String punchCardPlace, Integer remoteFlag);


	/**
	 * 内部员工：获取项目下所有在场的劳务人员
	 *
	 * @param param 参数
	 *
	 * @return {@link IPage}<{@link WorkRecordVO}>
	 */
	IPage<WorkRecordVO> internalFetchWorkRecord(QueryParam param);


	/**
	 * 内部员工：校验考勤范围
	 *
	 * @param projectId   项目id
	 * @param destination 当前位置经纬度
	 *
	 * @return {@link CommonResponse}<{@link JSONObject}>
	 */
	CommonResponse<JSONObject> internalCheckDistance(Long projectId, String destination);


	/**
	 * 内部员工：校验人脸
	 *
	 * @param projectId  项目id
	 * @param imgBase64A 待识别人脸照片base64编码
	 *
	 * @return {@link CommonResponse}<{@link WorkerVO}>
	 */
	CommonResponse<WorkerVO> internalCheckFace(Long projectId, String imgBase64A);


	/**
	 * 内部员工：校验已存在的打卡记录
	 *
	 * @param workerId      项目花名册人员id
	 * @param projectId     项目id
	 * @param punchCardType 打卡类型：上班打卡、下班打卡
	 *
	 * @return {@link CommonResponse}<{@link List}<{@link AttendanceLogVO}>>
	 */
	CommonResponse<List<AttendanceLogVO>> internalCheckExistedLog(Long workerId, Long projectId, String punchCardType);


	/**
	 * 内部员工：考勤打卡
	 *
	 * @param workerId       项目花名册人员id
	 * @param projectId      项目id
	 * @param punchCardType  打卡类型：上班打卡、下班打卡
	 * @param punchCardPlace 打卡地点
	 * @param remoteFlag     是否是异地打卡（1:是 0：否）
	 *
	 * @return {@link AttendanceLogVO}
	 */
	AttendanceLogVO internalPunchCard(Long workerId, Long projectId, String punchCardType, String punchCardPlace, Integer remoteFlag);


	/**
	 * 班组长：获取项目下当前用户所在班组（通过班组长手机号与登录用户手机号校验）的在场用户
	 *
	 * @param param 参数
	 *
	 * @return {@link IPage}<{@link WorkRecordVO}>
	 */
	IPage<WorkRecordVO> leaderFetchWorkRecord(QueryParam param);


	/**
	 * 班组长：校验考勤范围
	 *
	 * @param projectId   项目id
	 * @param destination 当前位置经纬度
	 *
	 * @return {@link CommonResponse}<{@link JSONObject}>
	 */
	CommonResponse<JSONObject> leaderCheckDistance(Long projectId, String destination);


	/**
	 * 班组长：校验人脸
	 *
	 * @param projectId  项目id
	 * @param imgBase64A 待识别人脸照片base64编码
	 *
	 * @return {@link CommonResponse}<{@link WorkerVO}>
	 */
	CommonResponse<WorkerVO> leaderCheckFace(Long projectId, String imgBase64A);


	/**
	 * 班组长：校验已存在的打卡记录
	 *
	 * @param workerId      项目花名册人员id
	 * @param projectId     项目id
	 * @param punchCardType 打卡类型：上班打卡、下班打卡
	 *
	 * @return {@link CommonResponse}<{@link List}<{@link AttendanceLogVO}>>
	 */
	CommonResponse<List<AttendanceLogVO>> leaderCheckExistedLog(Long workerId, Long projectId, String punchCardType);


	/**
	 * 班组长：考勤打卡
	 *
	 * @param workerId       项目花名册人员id
	 * @param projectId      项目id
	 * @param punchCardType  打卡类型：上班打卡、下班打卡
	 * @param punchCardPlace 打卡地点
	 * @param remoteFlag     是否是异地打卡（1:是 0：否）
	 *
	 * @return {@link AttendanceLogVO}
	 */
	AttendanceLogVO leaderPunchCard(Long workerId, Long projectId, String punchCardType, String punchCardPlace, Integer remoteFlag);


	/**
	 * 校验可用人脸质量
	 *
	 * @param imgBase64A 人脸base64编码
	 *
	 * @return {@link CommonResponse}<{@link String}>
	 */
	CommonResponse<String> checkFaceQuality(String imgBase64A);

    CommonResponse<WorkerVO> checkFaceByProject(Long projectId, String imgBase64A);
}
