/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.OvertimeApplyDetailEntity;
import com.ejianc.business.labor.bean.OvertimeApplyEntity;
import com.ejianc.business.labor.service.IOvertimeApplyDetailService;
import com.ejianc.business.labor.service.IOvertimeApplyService;
import com.ejianc.business.labor.vo.OvertimeApplyDetailVO;
import com.ejianc.business.labor.vo.OvertimeApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"overtimeApply"})
@Api(value="\u52a0\u73ed\u7533\u8bf7", tags={"\u52a0\u73ed\u7533\u8bf7"})
public class OvertimeApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "JBSQ_CODE";
    @Autowired
    private IOvertimeApplyService service;
    @Autowired
    private IOvertimeApplyDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OvertimeApplyVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OvertimeApplyVO saveOrUpdateVO) {
        OvertimeApplyEntity entity = (OvertimeApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OvertimeApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OvertimeApplyVO vo = (OvertimeApplyVO)BeanMapper.map((Object)((Object)entity), OvertimeApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OvertimeApplyVO> queryDetail(@RequestParam Long id) {
        OvertimeApplyEntity entity = (OvertimeApplyEntity)((Object)this.service.selectById(id));
        OvertimeApplyVO vo = (OvertimeApplyVO)BeanMapper.map((Object)((Object)entity), OvertimeApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OvertimeApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OvertimeApplyVO overtimeApplyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OvertimeApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OvertimeApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List overtimeApplyVOS = BeanMapper.mapList((Iterable)list, OvertimeApplyVO.class);
        overtimeApplyVOS.stream().forEach(vo -> vo.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        beans.put("records", overtimeApplyVOS);
        ExcelExport.getInstance().export("OvertimeApply-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refOvertimeApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OvertimeApplyVO>> refOvertimeApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject con;
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("billCode", "projectName", "employeeName"));
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (con = JSONObject.parseObject((String)condition)).containsKey((Object)"projectId")) {
            param.getParams().put("projectId", new Parameter("eq", (Object)con.getLong("projectId")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OvertimeApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refOvertimeApplyDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OvertimeApplyDetailVO>> refOvertimeApplyDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject con;
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("billCode", "projectName", "employeeName"));
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (con = JSONObject.parseObject((String)condition)).containsKey((Object)"projectId")) {
            param.getParams().put("projectId", new Parameter("eq", (Object)con.getLong("projectId")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OvertimeApplyVO.class));
        return null;
    }

    @RequestMapping(value={"/queryOvertimeApplyDetailData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<Long, OvertimeApplyDetailVO>> queryOvertimeApplyDetailData(@RequestBody List<OvertimeApplyDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            Long projectId = vos.get(0).getProjectId();
            Date overtimeDate = vos.get(0).getOvertimeDate();
            List<Long> workIdS = vos.stream().map(e -> e.getWorkerId()).collect(Collectors.toList());
            SimpleDateFormat sdf = new SimpleDateFormat("MM");
            SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");
            List<OvertimeApplyDetailEntity> detailList = this.service.queryByMonth(projectId, sdf.format(overtimeDate), sdfYear.format(overtimeDate), workIdS);
            if (ListUtil.isNotEmpty(detailList) && ListUtil.isNotEmpty(detailList)) {
                Map<Long, OvertimeApplyDetailEntity> collect = detailList.stream().collect(Collectors.toMap(e -> e.getWorkerId(), v -> v));
                for (OvertimeApplyDetailVO det : vos) {
                    if (!collect.containsKey(det.getWorkerId())) continue;
                    det.setOvertimeMny(collect.get(det.getWorkerId()).getOvertimeMny());
                    det.setOvertimeHours(collect.get(det.getWorkerId()).getOvertimeHours());
                }
            }
        }
        Map<Long, OvertimeApplyDetailVO> collect = vos.stream().collect(Collectors.toMap(e -> e.getWorkerId(), v -> v));
        return CommonResponse.success(collect);
    }
}

