/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.service.IAmapService;
import com.ejianc.business.labor.vo.DistanceVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service(value="amapService")
public class AmapServiceImpl
implements IAmapService {
    private static final String DISTANCE = "https://restapi.amap.com/v3/distance?parameters";
    private static final String REGEO = "https://restapi.amap.com/v3/geocode/regeo?parameters";
    private static final String REGEO_TDT = "http://api.tianditu.gov.cn/geocoder?postStr={'lon':lonStr,'lat':latStr,'ver':1}&type=geocode&tk=";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${amap.key}")
    private String key;
    @Value(value="${tdt.key}")
    private String key_tdt;
    private static double EARTH_RADIUS = 6371000.0;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double GetDistance(double lon1, double lat1, double lon2, double lat2) {
        double radLat1 = AmapServiceImpl.rad(lat1);
        double radLat2 = AmapServiceImpl.rad(lat2);
        double a = radLat1 - radLat2;
        double b = AmapServiceImpl.rad(lon1) - AmapServiceImpl.rad(lon2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= EARTH_RADIUS;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return s;
    }

    @Override
    public List<DistanceVO> distance(String origins, String destination, String type) {
        Assert.hasText((String)origins, (String)"\u51fa\u53d1\u70b9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)destination, (String)"\u76ee\u7684\u5730\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)type, (String)"\u8def\u5f84\u8ba1\u7b97\u7684\u65b9\u5f0f\u548c\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("\u8ddd\u79bb\u6d4b\u91cf\uff0c\u5165\u53c2\uff1aorigins--{}\uff0cdestination--{}\uff0ctype--{}", new Object[]{origins, destination, type});
        String[] originsLonLat = origins.split("\\|");
        ArrayList<DistanceVO> distanceVOList = new ArrayList<DistanceVO>();
        for (int i = 0; i < originsLonLat.length; ++i) {
            String s = originsLonLat[i];
            String[] lonLat = s.split(",");
            DistanceVO distanceVO = new DistanceVO();
            distanceVO.setOriginId(i + 1 + "");
            distanceVO.setDistance(String.valueOf(AmapServiceImpl.GetDistance(Double.parseDouble(lonLat[0]), Double.parseDouble(lonLat[1]), Double.parseDouble(destination.split(",")[0]), Double.parseDouble(destination.split(",")[1]))));
            distanceVOList.add(distanceVO);
        }
        return distanceVOList;
    }

    @Override
    public JSONObject regeo(String location) {
        Assert.hasText((String)location, (String)"\u7ecf\u7eac\u5ea6\u5750\u6807\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("\u9006\u5730\u7406\u7f16\u7801\uff0c\u5165\u53c2\uff1alocation--{}", (Object)location);
        String url = REGEO_TDT.replace("lonStr", location.split(",")[0]);
        url = url.replace("latStr", location.split(",")[1]);
        url = url + this.key_tdt;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("postStr", "{'lon':lonStr,'lat':latStr,'ver':1}".replace("lonStr", location.split(",")[0]).replace("latStr", location.split(",")[1]));
        params.put("type", "geocode");
        params.put("tk", this.key_tdt);
        String response = null;
        try {
            response = HttpTookit.get((String)"http://api.tianditu.gov.cn/geocoder", params, new HashMap());
            this.logger.info("\u8bf7\u6c42\u5929\u5730\u56fe \u5730\u5740-{},\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{url, JSONObject.toJSONString(params), response});
        }
        catch (GeneralSecurityException e) {
            this.logger.error("\u8bf7\u6c42\u5929\u5730\u56fe\u5931\u8d25\uff01", (Throwable)e);
            throw new BusinessException("\u8bf7\u6c42\u5929\u5730\u56fe\u5931\u8d25\uff01");
        }
        catch (IOException e) {
            this.logger.error("\u8bf7\u6c42\u5929\u5730\u56fe\u5931\u8d25\uff01", (Throwable)e);
            throw new BusinessException("\u8bf7\u6c42\u5929\u5730\u56fe\u5931\u8d25\uff01");
        }
        if (StringUtils.isEmpty((Object)response)) {
            throw new BusinessException("\u8bf7\u6c42\u5929\u5730\u56fe\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        String status = jsonObject.getString("status");
        if (!"0".equals(status)) {
            throw new BusinessException("\u9006\u5730\u7406\u7f16\u7801\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + jsonObject.getString("msg"));
        }
        return (JSONObject)jsonObject.get((Object)"result");
    }
}

