/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.SalaryEntity;
import com.ejianc.business.labor.service.ISalaryService;
import com.ejianc.business.labor.utils.EJCDateUtil;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.labor.vo.SalaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"salary"})
public class SalaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "LABOR_SALARY_CODE";
    @Autowired
    private ISalaryService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SalaryVO> saveOrUpdate(@RequestBody SalaryVO saveOrUpdateVO) {
        SalaryEntity entity = (SalaryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SalaryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SalaryVO vo = (SalaryVO)BeanMapper.map((Object)((Object)entity), SalaryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalaryVO> queryDetail(Long id) {
        SalaryEntity entity = (SalaryEntity)((Object)this.service.selectById(id));
        SalaryVO vo = (SalaryVO)BeanMapper.map((Object)((Object)entity), SalaryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalaryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SalaryVO salaryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<SalaryVO> list = this.service.querySalaryPage(wrapper, salaryMonth, (Page<SalaryVO>)page);
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<SalaryVO> list = this.service.querySalaryPage(wrapper, salaryMonth, null);
        HashMap<String, List<SalaryVO>> beans = new HashMap<String, List<SalaryVO>>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (SalaryVO vo : list) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("Salary-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSalaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalaryVO>> refSalaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"salary-import.xlsx", (String)"\u52b3\u52a1\u5de5\u8d44\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }

    @RequestMapping(value={"/queryWorkerAttendanceList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryWorkerAttendanceList(String month, Long workerId, Long projectId, Long id) {
        String createTime = null;
        if (id != null) {
            SalaryEntity salaryEntity = (SalaryEntity)((Object)this.service.selectById(id));
            createTime = EJCDateUtil.format(salaryEntity.getCreateTime(), "yyyy-MM-dd HH:mm:ss");
        }
        List<AttendanceVO> list = this.service.queryWorkerAttendanceList(workerId, month, projectId, createTime);
        Integer lastAttendance = 0;
        Integer normalAttendance = 0;
        Integer abnormalAttendance = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            for (AttendanceVO attendanceVO : list) {
                lastAttendance = lastAttendance + 1;
                if ("\u6b63\u5e38".equals(attendanceVO.getAttendanceStatus())) {
                    normalAttendance = normalAttendance + 1;
                }
                if (!"\u5f02\u5e38".equals(attendanceVO.getAttendanceStatus())) continue;
                abnormalAttendance = abnormalAttendance + 1;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lastAttendance", lastAttendance);
        map.put("list", list);
        map.put("normalAttendance", normalAttendance);
        map.put("abnormalAttendance", abnormalAttendance);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/queryProjectCurMonthIdCards"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<String>> queryProjectCurMonthIdCards(@RequestParam Long projectId, @RequestParam String salaryMonth, @RequestParam(required=false) Long id) {
        List<String> res = this.service.queryProjectCurMonthIdCards(projectId, salaryMonth, id);
        return CommonResponse.success((String)"\u83b7\u53d6\u672c\u6708\u5df2\u505a\u8fc7\u5de5\u8d44\u7533\u8bf7\u7684\u4eba\u5458\u8eab\u4efd\u8bc1\u5217\u8868\u6210\u529f\uff01", res);
    }
}

