/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.WorktimeSetDetailEntity;
import com.ejianc.business.labor.bean.WorktimeSetEntity;
import com.ejianc.business.labor.service.IWorktimeSetService;
import com.ejianc.business.labor.vo.WorktimeSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"worktimeSet"})
public class WorktimeSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "WORKTIME_SET_CODE";
    @Autowired
    private IWorktimeSetService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorktimeSetVO> saveOrUpdate(@RequestBody WorktimeSetVO saveOrUpdateVO) {
        WorktimeSetEntity entity = (WorktimeSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WorktimeSetEntity.class));
        List<WorktimeSetDetailEntity> worktimeSetDetailList = entity.getWorktimeSetDetailList();
        if (CollectionUtils.isNotEmpty(worktimeSetDetailList)) {
            for (WorktimeSetDetailEntity worktimeSetDetailEntity : worktimeSetDetailList) {
                if ("del".equals(worktimeSetDetailEntity.getRowState()) || !StringUtils.isBlank((CharSequence)worktimeSetDetailEntity.getLngLat()) && !",".equals(worktimeSetDetailEntity.getLngLat())) continue;
                throw new BusinessException("\u6253\u5361\u5730\u5740\u3010" + worktimeSetDetailEntity.getAddress() + "\u3011\u5750\u6807\u62fe\u53d6\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
            }
            String attendanceAddress = entity.getWorktimeSetDetailList().stream().filter(s -> s.getAddress() != null).map(WorktimeSetDetailEntity::getAddress).collect(Collectors.joining(","));
            entity.setAttendanceAddress(attendanceAddress);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        WorktimeSetVO vo = (WorktimeSetVO)BeanMapper.map((Object)((Object)entity), WorktimeSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorktimeSetVO> queryDetail(Long id) {
        WorktimeSetEntity entity = (WorktimeSetEntity)((Object)this.service.selectById(id));
        WorktimeSetVO vo = (WorktimeSetVO)BeanMapper.map((Object)((Object)entity), WorktimeSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorktimeSetVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WorktimeSetVO worktimeSetVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorktimeSetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("attendanceAddress");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorktimeSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List worktimeSetVOS = BeanMapper.mapList((Iterable)list, WorktimeSetVO.class);
        if (CollectionUtils.isNotEmpty((Collection)worktimeSetVOS)) {
            for (WorktimeSetVO worktimeSetVO : worktimeSetVOS) {
                if (worktimeSetVO.getEnable().booleanValue()) {
                    worktimeSetVO.setEnableName("\u542f\u7528");
                } else {
                    worktimeSetVO.setEnableName("\u505c\u7528");
                }
                if (worktimeSetVO.getOffSiteFlag() == 1) {
                    worktimeSetVO.setOffSiteFlagName("\u662f");
                    continue;
                }
                worktimeSetVO.setOffSiteFlagName("\u5426");
            }
        }
        beans.put("records", worktimeSetVOS);
        ExcelExport.getInstance().export("WorktimeSet-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWorktimeSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorktimeSetVO>> refWorktimeSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorktimeSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkWorktimeSet"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkWorktimeSet(Long projectId, Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.ne(id != null, (Object)"id", (Object)id);
        int count = this.service.count((Wrapper)queryWrapper);
        if (count > 0) {
            return CommonResponse.error((String)"\u4e00\u4e2a\u9879\u76ee\u53ea\u80fd\u5b58\u5728\u4e00\u6761\u8003\u52e4\u8bbe\u7f6e\u6570\u636e\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u672a\u505a\u8003\u52e4\u8bbe\u7f6e!");
    }

    @GetMapping(value={"getQrCode"})
    public CommonResponse<JSONObject> getQrCode(@RequestParam(value="id") Long id) throws UnsupportedEncodingException {
        return CommonResponse.success((String)"\u83b7\u53d6\u8003\u52e4\u4e8c\u7ef4\u7801\u6210\u529f\uff01", (Object)this.service.getQrCode(id));
    }
}

