package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.SalaryEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.mapper.SalaryMapper;
import com.ejianc.business.labor.service.IOrgTeamService;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.ISalaryService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.utils.EJCDateUtil;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.labor.vo.SalaryVO;
import com.ejianc.business.labor.vo.importSalaryDetailVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 劳务工资单
 * 
 * @author generator
 * 
 */
@Service("salaryService")
public class SalaryServiceImpl extends BaseServiceImpl<SalaryMapper, SalaryEntity> implements ISalaryService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String regex = "^\\d{16}|\\d{19}$";
    private static  final  String IdCardRegex="(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
    @Autowired
    private IWorkRecordService workRecordService;

    @Autowired
    private IOrgTeamService orgTeamService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IProjectTeamService projectTeamService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long projectId = Long.parseLong(request.getParameter("sourceId"));
        String salaryMonth = String.valueOf(request.getParameter("salaryMonth"));
        Long id = request.getParameter("id") != null ? Long.parseLong(request.getParameter("id")) : null;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<importSalaryDetailVO> successList = new ArrayList<>();
            List<importSalaryDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 16) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size()>=10000){
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }
                List<String> monthIdcards = this.queryProjectCurMonthIdCards(projectId, salaryMonth, id);
                Map<String, Integer> idCardMap = new HashMap<>();
                StringBuilder errMsg = new StringBuilder();
                for (int i = 1; i < result.size(); i++) {
                    int rowNum = i + 2;
                    List<String> datas = result.get(i);
                    importSalaryDetailVO salaryDetailVO = new importSalaryDetailVO();
                    //WorkerName
                    if (StringUtils.isBlank(datas.get(0))) {
                        errMsg.append("`名字为必填项`");
                    }
                    salaryDetailVO.setWorkerName(datas.get(0));

                    if (datas.get(1).length() ==0) {
                        errMsg.append("`身份证为必填项`");
                    }
                    if ((datas.get(1)!=null) && (StringUtils.isNotBlank(datas.get(1)))){
                        String idCard = datas.get(1).trim();
                        if (!idCardMap.containsKey(idCard)) {
                            if (!idCard.matches(IdCardRegex)){
                                errMsg.append("`填写身份证号错误`");
                            }
                            idCardMap.put(idCard , rowNum);
                            salaryDetailVO.setIdCard(idCard);
                        }else {
                            errMsg.append("`第" + idCardMap.get(idCard) + "、" + rowNum + "行身份证号重复`");
                        }
                    }
                    //sex
                    if (datas.get(2)!=null) {
                        if ("男".equals(datas.get(2))){
                            salaryDetailVO.setSex("1");
                        } else if ("女".equals(datas.get(2))){
                            salaryDetailVO.setSex("2");
                        }
                    }
                    //班组
                    if(StringUtils.isNotBlank(datas.get(3))){
                       String teamName = datas.get(3).trim();
                        LambdaQueryWrapper<ProjectTeamEntity> wrapper = new LambdaQueryWrapper<>();
                        wrapper.eq(ProjectTeamEntity::getName, teamName);
                        //根据名称匹配
                        List<ProjectTeamEntity> list = projectTeamService.list(wrapper);
                        if (CollectionUtils.isNotEmpty(list)) {
                            salaryDetailVO.setTeamId(String.valueOf(list.get(0).getId()));
                            salaryDetailVO.setTeamName(list.get(0).getName());
                        }
                    }
                    //工种
                    if (StringUtils.isNotBlank(datas.get(4))){
                        //获取工种的档案
                        String workType = datas.get(4).trim();
                        CommonResponse<List<DefdocDetailVO>> workerTypeListRes = defdocApi.getDefDocByDefCode("labor_worker_type");
                        if (workerTypeListRes.isSuccess()) {
                            List<DefdocDetailVO> workerTypeList = workerTypeListRes.getData();
                            for (DefdocDetailVO defdocDetailVO : workerTypeList) {
                                if (defdocDetailVO.getName().equals(workType)) {
                                    salaryDetailVO.setWorkType(String.valueOf(defdocDetailVO.getId()));
                                    salaryDetailVO.setWorkTypeName(defdocDetailVO.getName());
                                }
                            }
                        } else {
                            errMsg.append("`工种查询失败`");
                        }
                    }
                    //开户行
                    salaryDetailVO.setBankName(datas.get(5));
                    //银行卡号
                    if (StringUtils.isNotBlank(datas.get(6)) &&  !datas.get(6).matches(regex)){
                        errMsg.append("`银行卡号填写错误`");
                    }
                    salaryDetailVO.setBankCard(datas.get(6));
                    //工资类型
                    if (datas.get(7)!=null){
                        String wagesTypeName = datas.get(7);
                        String wagesType=null;
                        if ("按小时计算".equals(wagesTypeName)) {
                            wagesType="1";
                        }
                        else if ("按日计算".equals(wagesTypeName)) {
                            wagesType="2";
                        }
                        else if ("按月计算".equals(wagesTypeName)) {
                            wagesType="3";
                        }
                        else if ("按工程量计算".equals(wagesTypeName)) {
                            wagesType="4";
                        }
                        salaryDetailVO.setWagesType(wagesType);
                    }
                    //工价
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        try {
                            salaryDetailVO.setPrice(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            errMsg.append("`工价为必须为数字`");
                        }
                    } else {
                        errMsg.append("`工价为必填项`");
                    }
                    //实际考勤
                    if (StringUtils.isNotBlank(datas.get(9))) {
                        try {
                            salaryDetailVO.setActualCheckNum(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            errMsg.append("`实际考勤为必须为数字`");
                        }
                    } else {
                        errMsg.append("`实际考勤为必填项`");
                    }
                    if (salaryDetailVO.getActualCheckNum()!=null && salaryDetailVO.getPrice()!=null ){
                        BigDecimal mny = ComputeUtil.safeMultiply(salaryDetailVO.getActualCheckNum(), salaryDetailVO.getPrice());
                        salaryDetailVO.setMny(mny);
                    }
                    //加班工资
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        try {
                            salaryDetailVO.setOvertimeMny(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            errMsg.append("`加班工资为必须为数字`");
                        }
                    }
                    //扣款
                    if (StringUtils.isNotBlank(datas.get(12))) {
                        try {
                            salaryDetailVO.setDeductMny(new BigDecimal(datas.get(12)));
                        } catch (Exception e) {
                            errMsg.append("`扣款为必须为数字`");
                        }
                    }
                    salaryDetailVO.setErrorMessage(errMsg.toString());
                    //扣款原因
                    salaryDetailVO.setDeductReason(datas.get(13));
                    //应发工资
                    BigDecimal shouldSalaryMny = ComputeUtil.safeSub(ComputeUtil.safeAdd(salaryDetailVO.getMny(), salaryDetailVO.getOvertimeMny()), salaryDetailVO.getDeductMny());
                    salaryDetailVO.setShouldSalaryMny(shouldSalaryMny);
                    salaryDetailVO.setMemo(datas.get(15));
                    QueryWrapper<WorkRecordEntity> objectQueryWrapper = new QueryWrapper<>();
                    //加上租户id过滤
                    objectQueryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
                    objectQueryWrapper.eq("id_card",salaryDetailVO.getIdCard());
                    objectQueryWrapper.eq("project_id",projectId);
                    objectQueryWrapper.orderByDesc("enter_date");
                    List<WorkRecordEntity> list = workRecordService.list(objectQueryWrapper);
                    if (CollectionUtils.isNotEmpty(list)){
                        WorkRecordEntity entity = list.get(0);
                        salaryDetailVO.setContractId(entity.getSubContractId());
                        salaryDetailVO.setContractName(entity.getSubContractName());
                        salaryDetailVO.setSupplierId(entity.getSupplierId());
                        salaryDetailVO.setSupplierName(entity.getSupplierName());
                        salaryDetailVO.setWorkerId(entity.getWorkerId());
                        salaryDetailVO.setPhone(entity.getPhone());
                        logger.info("身份证号匹配的信息"+JSONObject.toJSONString(entity));
                        if (entity.getEnterDate()!=null && entity.getExitDate()!=null){
                            String enterDate = EJCDateUtil.format(entity.getEnterDate(), EJCDateUtil.DATE);
                            String exitDate = EJCDateUtil.format(entity.getExitDate(), EJCDateUtil.DATE);
                            List<String> dayBetween = EJCDateUtil.getDayBetween(enterDate, exitDate);
                            salaryDetailVO.setSysCheckNum(dayBetween.size());
                        }
                        salaryDetailVO.setSource("1");
                    }else {
                        salaryDetailVO.setSource("2");
                    }
                    if (StringUtils.isBlank(salaryDetailVO.getErrorMessage())) {
                        if (monthIdcards.contains(salaryDetailVO.getIdCard())) {
                            salaryDetailVO.setCurMonthHasApply("是");
                        } else {
                            salaryDetailVO.setCurMonthHasApply("否");
                        }
                        successList.add(salaryDetailVO);
                    }else {
                        errorList.add(salaryDetailVO);
                    }
                }
            }
            //errorListTable
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
}

    @Override
    public Integer haveSalaryFlag(Long workerId, String exitDate) {
        return baseMapper.haveSalaryFlag(workerId,exitDate);
    }

    @Override
    public List<AttendanceVO> queryWorkerAttendanceList(Long workerId, String month,Long projectId,String createTime) {
        return baseMapper.queryWorkerAttendanceList(workerId,month,projectId,createTime);
    }

    @Override
    public List<SalaryVO> querySalaryPage(QueryWrapper wrapper, String salaryMonth, Page<SalaryVO> page) {
        return baseMapper.querySalaryPage(wrapper,salaryMonth,page);
    }

    @Override
    public List<String> queryProjectCurMonthIdCards(Long projectId, String salaryMonth, Long id) {
        return baseMapper.queryProjectCurMonthIdCards(projectId, salaryMonth, id);
    }
}
