package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.PayApplySalaryEntity;
import com.ejianc.business.labor.bean.PayApplySummaryEntity;
import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.service.IPayApplySalaryService;
import com.ejianc.business.labor.service.IPayApplySummaryService;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.vo.PayApplySalaryVO;
import com.ejianc.business.labor.vo.PayApplySummaryVO;
import com.ejianc.business.labor.vo.PayApplyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.labor.mapper.PayApplyMapper;
import com.ejianc.business.labor.bean.PayApplyEntity;
import com.ejianc.business.labor.service.IPayApplyService;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 劳务工资申请
 * 
 * @author generator
 * 
 */
@Service("payApplyService")
public class PayApplyServiceImpl extends BaseServiceImpl<PayApplyMapper, PayApplyEntity> implements IPayApplyService{

    private static final String BILL_CODE = "LABOR_PAY_APPLY";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPayApplySalaryService salaryService;

    @Autowired
    private IPayApplySummaryService summaryService;

    @Autowired
    private ISalarySlipService salarySlipService;

    @Override
    public PayApplyVO saveOrUpdate(PayApplyVO saveOrUpdateVO) {
        PayApplyEntity entity = BeanMapper.map(saveOrUpdateVO, PayApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);

        Long id = entity.getId();
        //更新劳务工资条
        List<PayApplySalaryVO> payContractSalaryVOS = this.updateSalary(saveOrUpdateVO, id);
        //更新劳务工资汇总
        List<PayApplySummaryVO> payContractSummaryVOS = this.updateSummary(saveOrUpdateVO, id);

        PayApplyVO vo = BeanMapper.map(entity, PayApplyVO.class);
        return vo;
    }

    @Override
    public String delete(List<PayApplyVO> vos) {
        List<Long> ids = vos.stream().map(PayApplyVO::getId).collect(Collectors.toList());
        //删除前获取工资条子表，回写工资条的已申请金额
        LambdaQueryWrapper<PayApplySalaryEntity> removeWrapper = new LambdaQueryWrapper<>();
        removeWrapper.in(PayApplySalaryEntity::getPayapplyId, ids);
        List<PayApplySalaryEntity> salaryList = salaryService.list(removeWrapper);

        super.removeByIds(ids,true);

        //删除后 回写申请中工资条的已申请金额
        this.writeBackAlreadyApplyMny(BeanMapper.mapList(salaryList, PayApplySalaryVO.class));
        return "删除成功！";
    }

    private List<PayApplySalaryVO> updateSalary(PayApplyVO vo, Long id) {
        //新增修改
        List<PayApplySalaryVO> voList = vo.getSalaryList();
        //删除
        QueryWrapper wrapper = new QueryWrapper<PayApplySalaryEntity>();
        wrapper.eq("payapply_id", id);
        List<PayApplySalaryVO> updSalarys = new ArrayList<>();
        if (voList != null && !voList.isEmpty()) {
            for (PayApplySalaryVO salaryVO : voList) {
                salaryVO.setPayapplyId(id);
            }
            List<PayApplySalaryEntity> entityList = BeanMapper.mapList(voList, PayApplySalaryEntity.class);
            salaryService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList, PayApplySalaryVO.class);
            List<Long> ids = voList.stream().map(PayApplySalaryVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), "id", ids);
            updSalarys.addAll(voList);
        }
        List<PayApplySalaryEntity> delSalList = salaryService.list(wrapper);
        if(CollectionUtils.isNotEmpty(delSalList)){
            List<PayApplySalaryVO> delSalVOList = BeanMapper.mapList(delSalList, PayApplySalaryVO.class);
            updSalarys.addAll(delSalVOList);
        }
        salaryService.remove(wrapper);

        //保存后 回写申请中工资条的已申请金额
        this.writeBackAlreadyApplyMny(updSalarys);
        return voList;
    }

    private List<PayApplySummaryVO> updateSummary(PayApplyVO vo, Long id) {
        //新增修改
        List<PayApplySummaryVO> voList = vo.getSummaryList();
        //删除
        QueryWrapper wrapper = new QueryWrapper<PayApplySummaryEntity>();
        wrapper.eq("payapply_id", id);
        if (voList != null && !voList.isEmpty()) {
            for (PayApplySummaryVO summaryVO : voList) {
                summaryVO.setPayapplyId(id);
            }
            List<PayApplySummaryEntity> entityList = BeanMapper.mapList(voList, PayApplySummaryEntity.class);
            summaryService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList, PayApplySummaryVO.class);
            List<Long> ids = voList.stream().map(PayApplySummaryVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), "id", ids);
        }
        summaryService.remove(wrapper, false);
        return voList;
    }

    /**
     * 劳务工资申请有合同 新增/修改/删除 后回写工资条已申请金额
     * @return
     */
    public Boolean writeBackAlreadyApplyMny(List<PayApplySalaryVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> salaryIds = list.stream().distinct().map(PayApplySalaryVO::getSalaryId).collect(Collectors.toList());
            LambdaQueryWrapper<PayApplySalaryEntity> ew = new LambdaQueryWrapper<>();
            ew.in(PayApplySalaryEntity::getSalaryId, salaryIds);
            List<PayApplySalaryEntity> salaryList = salaryService.list(ew);
            Map<Long, BigDecimal> map = salaryList.stream().collect(Collectors.groupingBy(PayApplySalaryEntity::getSalaryId,
                    Collectors.collectingAndThen(Collectors.toList(),m->m.stream().map(a->a.getApplyMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd))));
            for (Long salaryId : salaryIds) {
                if (!map.containsKey(salaryId)) {
                    map.put(salaryId, BigDecimal.ZERO);
                }
            }
            this.updateAlreadyApplyMny(map);
        }
        return true;
    }

    public CommonResponse<String> updateAlreadyApplyMny(@RequestBody Map<Long, BigDecimal> map){
        Set<Long> ids = map.keySet();
        if (CollectionUtils.isNotEmpty(ids)){
            for (Long id : ids) {
                BigDecimal alreadyApplyMny = map.get(id);
                LambdaUpdateWrapper<SalarySlipEntity> objectLambdaUpdateWrapper = new LambdaUpdateWrapper<>();
                objectLambdaUpdateWrapper.eq(SalarySlipEntity::getId,id);
                objectLambdaUpdateWrapper.set(SalarySlipEntity::getAlreadyApplyMny,alreadyApplyMny);
                salarySlipService.update(objectLambdaUpdateWrapper);
            }
        }
        return CommonResponse.success("修改已经申请金额成功！");
    }
}
