package com.ejianc.business.labor.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.labor.bean.PointTicketsDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 点工单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_labor_point_tickets")
public class PointTicketsEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="team_id")
    private Long teamId; // 班组
    @TableField(value="team_name")
    private String teamName; // 班组名称
    @TableField(value="team_num")
    private Integer teamNum; // 班组人数
    @TableField(value="employee_id")
    private Long employeeId; // 打卡负责人
    @TableField(value="employee_name")
    private String employeeName; // 打卡负责人
    @TableField(value="work_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date workDate; // 打卡日期
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="work_num")
    private Integer workNum; // 打卡人数
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="pointTicketsDetailService")
    private List<PointTicketsDetailEntity> pointTicketsDetailList = new ArrayList<>(); // 点工单-人员信息
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getTeamId() {
        return teamId;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public Integer getTeamNum() {
        return teamNum;
    }

    public void setTeamNum(Integer teamNum) {
        this.teamNum = teamNum;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getWorkDate() {
        return workDate;
    }

    public void setWorkDate(Date workDate) {
        this.workDate = workDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getWorkNum() {
        return workNum;
    }

    public void setWorkNum(Integer workNum) {
        this.workNum = workNum;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<PointTicketsDetailEntity> getPointTicketsDetailList() {
        return pointTicketsDetailList;
    }

    public void setPointTicketsDetailList(List<PointTicketsDetailEntity> pointTicketsDetailList) {
        this.pointTicketsDetailList = pointTicketsDetailList;
    }
}
