package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.EnterPlanDetailEntity;
import com.ejianc.business.labor.mapper.EnterPlanDetailMapper;
import com.ejianc.business.labor.service.IEnterPlanDetailService;
import com.ejianc.business.labor.utils.UserInfoValidateUtil;
import com.ejianc.business.labor.vo.EnterPlanDetailVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 进场计划-人员信息
 * 
 * @author generator
 * 
 */
@Service("enterPlanDetailService")
public class EnterPlanDetailServiceImpl extends BaseServiceImpl<EnterPlanDetailMapper, EnterPlanDetailEntity> implements IEnterPlanDetailService {

    private static final String regex = "^\\d{16}|\\d{19}$";
    private static final String IdCardRegex = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";

    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<EnterPlanDetailVO> successList = new ArrayList<>();
            List<EnterPlanDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 11) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }
                CommonResponse<List<DefdocDetailVO>> derResp = defdocApi.getDefDocByDefCode("labor_worker_type");
                Map<String, Integer> idCardMap = new HashMap<>();
                Map<String, Integer> phoneMap = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    int rowNum = i + 2;
                    List<String> datas = result.get(i);
                    StringBuilder errMsg = new StringBuilder();
                    EnterPlanDetailVO vo = new EnterPlanDetailVO();
                    vo.setId(IdWorker.getId());
                    //WorkerName
                    vo.setName(datas.get(0));
                    if (StringUtils.isBlank(datas.get(0))) {
                        errMsg.append("`名字为必填项`");
                    }

                    if (datas.get(1).length() == 0) {
                        errMsg.append("`身份证为必填项`");
                    }
                    if ((datas.get(1) != null) && (StringUtils.isNotBlank(datas.get(1)))) {
                        String idCard = datas.get(1).trim();
                        if (!idCardMap.containsKey(idCard)) {
                            if (!idCard.matches(IdCardRegex)) {
                                errMsg.append("`填写身份证号错误`");
                            }
                            idCardMap.put(idCard, rowNum);
                            vo.setIdCard(idCard);
                        } else {
                            errMsg.append("`第" + idCardMap.get(idCard) + "、" + rowNum + "行身份证号重复`");
                        }
                    }
                    //sex
                    if (datas.get(2) != null) {
                        if ("男".equals(datas.get(2))) {
                            vo.setSex(1);
                        } else if ("女".equals(datas.get(2))) {
                            vo.setSex(2);
                        }
                    } else {
                        errMsg.append("`性别为必填项`");
                    }
                    if (StringUtils.isNotBlank(datas.get(3))) {
                        try {
                            vo.setBirthDate(HSSFDateUtil.getJavaDate(Double.parseDouble(datas.get(3))));
                        } catch (Exception e) {
                            vo.setErrorMessage("出生日期填写不正确");
                        }
                    } else {
                        errMsg.append("`出生日期为必填项`");
                    }
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        vo.setUserAge(Integer.valueOf(datas.get(4)));
                    } else {
                        errMsg.append("`年龄年龄为必填项`");
                    }
                    if (StringUtils.isNotBlank(datas.get(5))) {
                        vo.setNation(datas.get(5));
                    } else {
                        errMsg.append("`民族为必填项`");
                    }
                    //手机号
                    String phone = datas.get(6);
                    vo.setPhone(StringUtils.isNotBlank(phone)? phone : null);
                    if (StringUtils.isNotBlank(phone)) {
                        phone = phone.trim();
                        if (UserInfoValidateUtil.verifyPhone(phone)) {
                            if (!phoneMap.containsKey(phone)) {
                                phoneMap.put(phone, rowNum);
                            } else {
                                errMsg.append("`第" + phoneMap.get(phone) + "、" + rowNum + "行手机号重复`");
                            }
                        } else {
                            errMsg.append("`手机号不正确`");
                        }
                    } else {
                        errMsg.append("`手机号为必填项`");
                    }
                    //工种
                    vo.setWorkTypeName(datas.get(7));
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        //获取工种的档案
                        List<String> workTypes = Arrays.asList(datas.get(7).trim().split(","));
                        if (derResp.isSuccess()) {
                            List<DefdocDetailVO> defList = derResp.getData();
                            List<String> defNames = defList.stream().map(x->x.getName()).distinct().collect(Collectors.toList());
                            if(defNames.containsAll(workTypes)){
                                List<DefdocDetailVO> workerTypeList = defList.stream().filter(x->workTypes.contains(x.getName())).collect(Collectors.toList());
                                vo.setWorkType(workerTypeList.stream().map(x->String.valueOf(x.getId())).collect(Collectors.joining(",")));
                                vo.setWorkTypeName(workerTypeList.stream().map(x->x.getName()).collect(Collectors.joining(",")));
                            } else {
                                errMsg.append("`工种跟档案不匹配`");
                            }
                        } else {
                            errMsg.append("`工种查询失败`");
                        }
                    } else {
                        errMsg.append("`工种为必填项`");
                    }
                    if (datas.get(8).length() == 0) {
                        errMsg.append("`开户行为必填项`");
                    }
                    //开户行
                    vo.setBankName(datas.get(8));
                    //银行卡号
                    if (StringUtils.isNotBlank(datas.get(9)) && !datas.get(9).matches(regex)) {
                        errMsg.append("`银行卡号填写错误`");
                    }
                    if (datas.get(9).length() == 0) {
                        errMsg.append("`银行账号为必填项`");
                    }
                    vo.setBankAccount(datas.get(9));
                    //工价
                    if (StringUtils.isNotBlank(datas.get(10))) {
                        try {
                            vo.setWage(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            errMsg.append("`工价为必须为数字`");
                        }
                    } else {
                        errMsg.append("`工价为必填项`");
                    }
                    vo.setErrorMessage(errMsg.toString());
                    if (StringUtils.isBlank(vo.getErrorMessage())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }
}