package com.ejianc.business.law.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.law.vo.PartyVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 案件登记表
 * 
 * @author generator
 * 
 */
public class CaseRegisteVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String operatorCode; // 经办人联系方式
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String caseCode; // 案件编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date cognizanceDate; // 收案日期
    private BigDecimal sueAmount; // 起诉金额（元）
    private Long departmentId; // 涉案项目部
    private String departmentName; // 涉案项目部名称
    private Long projectId; // 工程
    private String projectName; // 工程名称
    private BigDecimal contractCost; // 合同造价（万元）
    private String disputeType; // 纠纷类型
    private String disputeTypeName; // 纠纷类型名称
    private Long labDisputeType; // 劳务类纠纷
    private String labDisputeTypeName; // 劳务类纠纷名称
    private String caseReport; // 案情通报
    private Long caseState; // 案件状态
    private String caseStateName; // 案件状态名称
    private Long payState; // 付款状态
    private String payStateName; // 付款状态名称
    private Integer hearCount; // 审理次数
    
    private List<PartyVO> partyList = new ArrayList<>(); // 当事人登记表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }
    public Date getCognizanceDate() {
        return cognizanceDate;
    }

    public void setCognizanceDate(Date cognizanceDate) {
        this.cognizanceDate = cognizanceDate;
    }
    public BigDecimal getSueAmount() {
        return sueAmount;
    }

    public void setSueAmount(BigDecimal sueAmount) {
        this.sueAmount = sueAmount;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getContractCost() {
        return contractCost;
    }

    public void setContractCost(BigDecimal contractCost) {
        this.contractCost = contractCost;
    }
    public String getDisputeType() {
        return disputeType;
    }

    public void setDisputeType(String disputeType) {
        this.disputeType = disputeType;
    }
    public String getDisputeTypeName() {
        return disputeTypeName;
    }

    public void setDisputeTypeName(String disputeTypeName) {
        this.disputeTypeName = disputeTypeName;
    }
    public Long getLabDisputeType() {
        return labDisputeType;
    }

    public void setLabDisputeType(Long labDisputeType) {
        this.labDisputeType = labDisputeType;
    }
    public String getLabDisputeTypeName() {
        return labDisputeTypeName;
    }

    public void setLabDisputeTypeName(String labDisputeTypeName) {
        this.labDisputeTypeName = labDisputeTypeName;
    }
    public String getCaseReport() {
        return caseReport;
    }

    public void setCaseReport(String caseReport) {
        this.caseReport = caseReport;
    }
    public Long getCaseState() {
        return caseState;
    }

    public void setCaseState(Long caseState) {
        this.caseState = caseState;
    }
    public String getCaseStateName() {
        return caseStateName;
    }

    public void setCaseStateName(String caseStateName) {
        this.caseStateName = caseStateName;
    }
    public Long getPayState() {
        return payState;
    }

    public void setPayState(Long payState) {
        this.payState = payState;
    }
    public String getPayStateName() {
        return payStateName;
    }

    public void setPayStateName(String payStateName) {
        this.payStateName = payStateName;
    }
    public Integer getHearCount() {
        return hearCount;
    }

    public void setHearCount(Integer hearCount) {
        this.hearCount = hearCount;
    }
    
     public List<PartyVO> getPartyList() {
        return partyList;
     }

     public void setPartyList(List<PartyVO> partyList) {
        this.partyList = partyList;
     }
}
