package com.ejianc.business.law.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 执行信息登记表
 * 
 * @author generator
 * 
 */
public class ExecutiveRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String operatorCode; // 经办人联系方式
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long executiveStateId; // 执行案状态
    private String executiveStateName; // 执行案状态名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date executiveStartDate; // 执行立案日期
    private String executiveCode; // 执行案号
    private Long payObjectId; // 支付对象
    private String payObjectName; // 支付对象名称
    private BigDecimal executiveAmount; // 执行金额
    private Long payTypeId; // 支付方式
    private String payTypeName; // 支付方式名称
    private BigDecimal frozenPrice; // 冻结金额
    private BigDecimal actualPaymentPrice; // 实际支付金额
    private Long executiveCountId; // 执行法院
    private String executiveCountName; // 执行法院名称
    private String executiveJudgeName; // 执行法官名称
    private String executiveJudgeCode; // 执行法官联系方式
    private Long executiveTypeId; // 执行措施
    private String executiveTypeName; // 执行措施名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date executiveEndDate; // 执行结案日期
    private String applyName; // 申请人代理人信息
    private String applyOrgName; // 申请人代理人单位
    private String applyCode; // 申请人代理人电话
    private Long caseId; // 案件编号
    private String caseName; // 案件编号名称
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getExecutiveStateId() {
        return executiveStateId;
    }

    public void setExecutiveStateId(Long executiveStateId) {
        this.executiveStateId = executiveStateId;
    }
    public String getExecutiveStateName() {
        return executiveStateName;
    }

    public void setExecutiveStateName(String executiveStateName) {
        this.executiveStateName = executiveStateName;
    }
    public Date getExecutiveStartDate() {
        return executiveStartDate;
    }

    public void setExecutiveStartDate(Date executiveStartDate) {
        this.executiveStartDate = executiveStartDate;
    }
    public String getExecutiveCode() {
        return executiveCode;
    }

    public void setExecutiveCode(String executiveCode) {
        this.executiveCode = executiveCode;
    }
    public Long getPayObjectId() {
        return payObjectId;
    }

    public void setPayObjectId(Long payObjectId) {
        this.payObjectId = payObjectId;
    }
    public String getPayObjectName() {
        return payObjectName;
    }

    public void setPayObjectName(String payObjectName) {
        this.payObjectName = payObjectName;
    }
    public BigDecimal getExecutiveAmount() {
        return executiveAmount;
    }

    public void setExecutiveAmount(BigDecimal executiveAmount) {
        this.executiveAmount = executiveAmount;
    }
    public Long getPayTypeId() {
        return payTypeId;
    }

    public void setPayTypeId(Long payTypeId) {
        this.payTypeId = payTypeId;
    }
    public String getPayTypeName() {
        return payTypeName;
    }

    public void setPayTypeName(String payTypeName) {
        this.payTypeName = payTypeName;
    }
    public BigDecimal getFrozenPrice() {
        return frozenPrice;
    }

    public void setFrozenPrice(BigDecimal frozenPrice) {
        this.frozenPrice = frozenPrice;
    }
    public BigDecimal getActualPaymentPrice() {
        return actualPaymentPrice;
    }

    public void setActualPaymentPrice(BigDecimal actualPaymentPrice) {
        this.actualPaymentPrice = actualPaymentPrice;
    }
    public Long getExecutiveCountId() {
        return executiveCountId;
    }

    public void setExecutiveCountId(Long executiveCountId) {
        this.executiveCountId = executiveCountId;
    }
    public String getExecutiveCountName() {
        return executiveCountName;
    }

    public void setExecutiveCountName(String executiveCountName) {
        this.executiveCountName = executiveCountName;
    }
    public String getExecutiveJudgeName() {
        return executiveJudgeName;
    }

    public void setExecutiveJudgeName(String executiveJudgeName) {
        this.executiveJudgeName = executiveJudgeName;
    }
    public String getExecutiveJudgeCode() {
        return executiveJudgeCode;
    }

    public void setExecutiveJudgeCode(String executiveJudgeCode) {
        this.executiveJudgeCode = executiveJudgeCode;
    }
    public Long getExecutiveTypeId() {
        return executiveTypeId;
    }

    public void setExecutiveTypeId(Long executiveTypeId) {
        this.executiveTypeId = executiveTypeId;
    }
    public String getExecutiveTypeName() {
        return executiveTypeName;
    }

    public void setExecutiveTypeName(String executiveTypeName) {
        this.executiveTypeName = executiveTypeName;
    }
    public Date getExecutiveEndDate() {
        return executiveEndDate;
    }

    public void setExecutiveEndDate(Date executiveEndDate) {
        this.executiveEndDate = executiveEndDate;
    }
    public String getApplyName() {
        return applyName;
    }

    public void setApplyName(String applyName) {
        this.applyName = applyName;
    }
    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }
    @ReferSerialTransfer(referCode = "law-case-registe")
    public Long getCaseId() {
        return caseId;
    }
    @ReferDeserialTransfer
    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }
    public String getCaseName() {
        return caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }
    
}
