package com.ejianc.business.law.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.law.vo.PartyVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 案件登记表
 *
 * @author generator
 */
public class CaseRegisteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String operatorCode; // 经办人联系方式
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String caseCode; // 案件编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date cognizanceDate; // 收案日期
    private BigDecimal sueAmount; // 起诉金额（元）
    private Long departmentId; // 涉案项目部
    private String departmentName; // 涉案项目部名称
    private Long projectId; // 工程
    private String projectName; // 工程名称
    private BigDecimal contractCost; // 合同造价（万元）
    private String disputeType; // 纠纷类型
    private String disputeTypeName; // 纠纷类型名称
    private Long labDisputeType; // 劳务类纠纷
    private String labDisputeTypeName; // 劳务类纠纷名称
    private String caseReport; // 案情通报
    private Long caseState; // 案件状态
    private String caseStateName; // 案件状态名称
    private Long payState; // 付款状态
    private String payStateName; // 付款状态名称
    private Integer hearCount; // 审理次数
    private String cognizanceType; // 收案渠道
    private BigDecimal sueAmountOne; // 起诉相关金额（元）
    private String caseName; // 案件名称
    private Long plaintiffMainId; // 主原告id
    private String plaintiffMainName; // 主原告名称
    private Long plaintiffOtherId; // 其他原告id
    private String plaintiffOtherName; // 其他原告名称
    private Long defendantMainId; // 主被告id
    private String defendantMainName; // 主被告名称
    private Long defendantOtherId; // 其他被告id
    private String defendantOtherName; // 其他被告名称
    private String caseResult; // 案件结果
    private String caseReportLast; // 案情通报
    private String frozenId; // 资金冻结单id
    private String thawId; // 资金解冻单id
    private Long firstCourtId; // 一审法院
    private String firstCourtName; // 一审法院名称
    private String firstJudgeName; // 法官名称
    private String firstJudgeCode; // 法官联系方式
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstStartDate; // 开庭日期
    private String firstCode; // 一审案号
    private Long firstTypeId; // 审理程序
    private String firstTypeName; // 审理程序名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstEndDate; // 结案日期
    private Long firstResultId; // 案件结果
    private String firstResultName; // 案件结果
    private BigDecimal firstEndAmount; // 结案金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstAppealDate; // 上诉截至日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstLastDate; // 再审截至日期
    private Long secondCourtId; // 二审法院
    private String secondCourtName; // 二审法院名称
    private String secondJudgeName; // 法官名称
    private String secondJudgeCode; // 法官联系方式
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date secondStartDate; // 开庭日期
    private String secondCode; // 二审案号
    private Long secondTypeId; // 审理程序
    private String secondTypeName; // 审理程序名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date secondEndDate; // 结案日期
    private Long secondResultId; // 案件结果
    private String secondResultName; // 案件结果
    private BigDecimal secondEndAmount; // 结案金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date secondAppealDate; // 上诉截至日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date secondLastDate; // 再审截至日期
    private Long thirdCourtId; // 三审法院
    private String thirdCourtName; // 三审法院名称
    private String thirdJudgeName; // 法官名称
    private String thirdJudgeCode; // 法官联系方式
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date thirdStartDate; // 开庭日期
    private String thirdCode; // 三审案号
    private Long thirdTypeId; // 审理程序
    private String thirdTypeName; // 审理程序名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date thirdEndDate; // 结案日期
    private Long thirdResultId; // 案件结果
    private String thirdResultName; // 案件结果
    private BigDecimal thirdEndAmount; // 结案金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date thirdAppealDate; // 上诉截至日期
    private Integer caseNum; // 案件进度0123

    private BigDecimal secondAmount; // 上诉金额
    private BigDecimal thirdAmount; // 再审金额

    public List<DepartmentVO> getDepartmentList() {
        return departmentList;
    }

    private List<CaseRegisteInfoVO> registeInfoEntityList = new ArrayList<>(); // 案件登记审理信息子表

    public List<CaseRegisteInfoVO> getRegisteInfoEntityList() {
        return registeInfoEntityList;
    }

    public void setRegisteInfoEntityList(List<CaseRegisteInfoVO> registeInfoEntityList) {
        this.registeInfoEntityList = registeInfoEntityList;
    }

    public void setDepartmentList(List<DepartmentVO> departmentList) {
        this.departmentList = departmentList;
    }

    private List<DepartmentVO> departmentList = new ArrayList<>(); // 涉案项目部登记


    public BigDecimal getSecondAmount() {
        return secondAmount;
    }

    public void setSecondAmount(BigDecimal secondAmount) {
        this.secondAmount = secondAmount;
    }

    public BigDecimal getThirdAmount() {
        return thirdAmount;
    }

    public void setThirdAmount(BigDecimal thirdAmount) {
        this.thirdAmount = thirdAmount;
    }

    private List<PartyVO> partyList = new ArrayList<>(); // 当事人登记表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }

    public Date getCognizanceDate() {
        return cognizanceDate;
    }

    public void setCognizanceDate(Date cognizanceDate) {
        this.cognizanceDate = cognizanceDate;
    }

    public BigDecimal getSueAmount() {
        return sueAmount;
    }

    public void setSueAmount(BigDecimal sueAmount) {
        this.sueAmount = sueAmount;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BigDecimal getContractCost() {
        return contractCost;
    }

    public void setContractCost(BigDecimal contractCost) {
        this.contractCost = contractCost;
    }

    public String getDisputeType() {
        return disputeType;
    }

    public void setDisputeType(String disputeType) {
        this.disputeType = disputeType;
    }

    public String getDisputeTypeName() {
        return disputeTypeName;
    }

    public void setDisputeTypeName(String disputeTypeName) {
        this.disputeTypeName = disputeTypeName;
    }

    public Long getLabDisputeType() {
        return labDisputeType;
    }

    public void setLabDisputeType(Long labDisputeType) {
        this.labDisputeType = labDisputeType;
    }

    public String getLabDisputeTypeName() {
        return labDisputeTypeName;
    }

    public void setLabDisputeTypeName(String labDisputeTypeName) {
        this.labDisputeTypeName = labDisputeTypeName;
    }

    public String getCaseReport() {
        return caseReport;
    }

    public void setCaseReport(String caseReport) {
        this.caseReport = caseReport;
    }

    public Long getCaseState() {
        return caseState;
    }

    public void setCaseState(Long caseState) {
        this.caseState = caseState;
    }

    public String getCaseStateName() {
        return caseStateName;
    }

    public void setCaseStateName(String caseStateName) {
        this.caseStateName = caseStateName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayState() {
        return payState;
    }

    @ReferDeserialTransfer
    public void setPayState(Long payState) {
        this.payState = payState;
    }

    public String getPayStateName() {
        return payStateName;
    }

    public void setPayStateName(String payStateName) {
        this.payStateName = payStateName;
    }

    public Integer getHearCount() {
        return hearCount;
    }

    public void setHearCount(Integer hearCount) {
        this.hearCount = hearCount;
    }

    public String getCognizanceType() {
        return cognizanceType;
    }

    public void setCognizanceType(String cognizanceType) {
        this.cognizanceType = cognizanceType;
    }

    public BigDecimal getSueAmountOne() {
        return sueAmountOne;
    }

    public void setSueAmountOne(BigDecimal sueAmountOne) {
        this.sueAmountOne = sueAmountOne;
    }

    public String getCaseName() {
        return caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }

    public Long getPlaintiffMainId() {
        return plaintiffMainId;
    }

    public void setPlaintiffMainId(Long plaintiffMainId) {
        this.plaintiffMainId = plaintiffMainId;
    }

    public String getPlaintiffMainName() {
        return plaintiffMainName;
    }

    public void setPlaintiffMainName(String plaintiffMainName) {
        this.plaintiffMainName = plaintiffMainName;
    }

    public Long getPlaintiffOtherId() {
        return plaintiffOtherId;
    }

    public void setPlaintiffOtherId(Long plaintiffOtherId) {
        this.plaintiffOtherId = plaintiffOtherId;
    }

    public String getPlaintiffOtherName() {
        return plaintiffOtherName;
    }

    public void setPlaintiffOtherName(String plaintiffOtherName) {
        this.plaintiffOtherName = plaintiffOtherName;
    }

    public Long getDefendantMainId() {
        return defendantMainId;
    }

    public void setDefendantMainId(Long defendantMainId) {
        this.defendantMainId = defendantMainId;
    }

    public String getDefendantMainName() {
        return defendantMainName;
    }

    public void setDefendantMainName(String defendantMainName) {
        this.defendantMainName = defendantMainName;
    }

    public Long getDefendantOtherId() {
        return defendantOtherId;
    }

    public void setDefendantOtherId(Long defendantOtherId) {
        this.defendantOtherId = defendantOtherId;
    }

    public String getDefendantOtherName() {
        return defendantOtherName;
    }

    public void setDefendantOtherName(String defendantOtherName) {
        this.defendantOtherName = defendantOtherName;
    }

    public List<PartyVO> getPartyList() {
        return partyList;
    }

    public void setPartyList(List<PartyVO> partyList) {
        this.partyList = partyList;
    }

    public String getCaseResult() {
        return caseResult;
    }

    public void setCaseResult(String caseResult) {
        this.caseResult = caseResult;
    }

    public String getCaseReportLast() {
        return caseReportLast;
    }

    public void setCaseReportLast(String caseReportLast) {
        this.caseReportLast = caseReportLast;
    }

    public String getfrozenId() {
        return frozenId;
    }

    public void setfrozenId(String frozenId) {
        this.frozenId = frozenId;
    }

    public String getthawId() {
        return thawId;
    }

    public void setthawId(String thawId) {
        this.thawId = thawId;
    }

    public Long getFirstCourtId() {
        return firstCourtId;
    }

    public void setFirstCourtId(Long firstCourtId) {
        this.firstCourtId = firstCourtId;
    }

    public String getFirstCourtName() {
        return firstCourtName;
    }

    public void setFirstCourtName(String firstCourtName) {
        this.firstCourtName = firstCourtName;
    }

    public String getFirstJudgeName() {
        return firstJudgeName;
    }

    public void setFirstJudgeName(String firstJudgeName) {
        this.firstJudgeName = firstJudgeName;
    }

    public String getFirstJudgeCode() {
        return firstJudgeCode;
    }

    public void setFirstJudgeCode(String firstJudgeCode) {
        this.firstJudgeCode = firstJudgeCode;
    }

    public Date getFirstStartDate() {
        return firstStartDate;
    }

    public void setFirstStartDate(Date firstStartDate) {
        this.firstStartDate = firstStartDate;
    }

    public String getFirstCode() {
        return firstCode;
    }

    public void setFirstCode(String firstCode) {
        this.firstCode = firstCode;
    }

    public Long getFirstTypeId() {
        return firstTypeId;
    }

    public void setFirstTypeId(Long firstTypeId) {
        this.firstTypeId = firstTypeId;
    }

    public String getFirstTypeName() {
        return firstTypeName;
    }

    public void setFirstTypeName(String firstTypeName) {
        this.firstTypeName = firstTypeName;
    }

    public Date getFirstEndDate() {
        return firstEndDate;
    }

    public void setFirstEndDate(Date firstEndDate) {
        this.firstEndDate = firstEndDate;
    }

    public Long getFirstResultId() {
        return firstResultId;
    }

    public void setFirstResultId(Long firstResultId) {
        this.firstResultId = firstResultId;
    }

    public String getFirstResultName() {
        return firstResultName;
    }

    public void setFirstResultName(String firstResultName) {
        this.firstResultName = firstResultName;
    }

    public BigDecimal getFirstEndAmount() {
        return firstEndAmount;
    }

    public void setFirstEndAmount(BigDecimal firstEndAmount) {
        this.firstEndAmount = firstEndAmount;
    }

    public Date getFirstAppealDate() {
        return firstAppealDate;
    }

    public void setFirstAppealDate(Date firstAppealDate) {
        this.firstAppealDate = firstAppealDate;
    }

    public Date getFirstLastDate() {
        return firstLastDate;
    }

    public void setFirstLastDate(Date firstLastDate) {
        this.firstLastDate = firstLastDate;
    }

    public Long getSecondCourtId() {
        return secondCourtId;
    }

    public void setSecondCourtId(Long secondCourtId) {
        this.secondCourtId = secondCourtId;
    }

    public String getSecondCourtName() {
        return secondCourtName;
    }

    public void setSecondCourtName(String secondCourtName) {
        this.secondCourtName = secondCourtName;
    }

    public String getSecondJudgeName() {
        return secondJudgeName;
    }

    public void setSecondJudgeName(String secondJudgeName) {
        this.secondJudgeName = secondJudgeName;
    }

    public String getSecondJudgeCode() {
        return secondJudgeCode;
    }

    public void setSecondJudgeCode(String secondJudgeCode) {
        this.secondJudgeCode = secondJudgeCode;
    }

    public Date getSecondStartDate() {
        return secondStartDate;
    }

    public void setSecondStartDate(Date secondStartDate) {
        this.secondStartDate = secondStartDate;
    }

    public String getSecondCode() {
        return secondCode;
    }

    public void setSecondCode(String secondCode) {
        this.secondCode = secondCode;
    }

    public Long getSecondTypeId() {
        return secondTypeId;
    }

    public void setSecondTypeId(Long secondTypeId) {
        this.secondTypeId = secondTypeId;
    }

    public String getSecondTypeName() {
        return secondTypeName;
    }

    public void setSecondTypeName(String secondTypeName) {
        this.secondTypeName = secondTypeName;
    }

    public Date getSecondEndDate() {
        return secondEndDate;
    }

    public void setSecondEndDate(Date secondEndDate) {
        this.secondEndDate = secondEndDate;
    }

    public Long getSecondResultId() {
        return secondResultId;
    }

    public void setSecondResultId(Long secondResultId) {
        this.secondResultId = secondResultId;
    }

    public String getSecondResultName() {
        return secondResultName;
    }

    public void setSecondResultName(String secondResultName) {
        this.secondResultName = secondResultName;
    }

    public BigDecimal getSecondEndAmount() {
        return secondEndAmount;
    }

    public void setSecondEndAmount(BigDecimal secondEndAmount) {
        this.secondEndAmount = secondEndAmount;
    }

    public Date getSecondAppealDate() {
        return secondAppealDate;
    }

    public void setSecondAppealDate(Date secondAppealDate) {
        this.secondAppealDate = secondAppealDate;
    }

    public Date getSecondLastDate() {
        return secondLastDate;
    }

    public void setSecondLastDate(Date secondLastDate) {
        this.secondLastDate = secondLastDate;
    }

    public Long getThirdCourtId() {
        return thirdCourtId;
    }

    public void setThirdCourtId(Long thirdCourtId) {
        this.thirdCourtId = thirdCourtId;
    }

    public String getThirdCourtName() {
        return thirdCourtName;
    }

    public void setThirdCourtName(String thirdCourtName) {
        this.thirdCourtName = thirdCourtName;
    }

    public String getThirdJudgeName() {
        return thirdJudgeName;
    }

    public void setThirdJudgeName(String thirdJudgeName) {
        this.thirdJudgeName = thirdJudgeName;
    }

    public String getThirdJudgeCode() {
        return thirdJudgeCode;
    }

    public void setThirdJudgeCode(String thirdJudgeCode) {
        this.thirdJudgeCode = thirdJudgeCode;
    }

    public Date getThirdStartDate() {
        return thirdStartDate;
    }

    public void setThirdStartDate(Date thirdStartDate) {
        this.thirdStartDate = thirdStartDate;
    }

    public String getThirdCode() {
        return thirdCode;
    }

    public void setThirdCode(String thirdCode) {
        this.thirdCode = thirdCode;
    }

    public Long getThirdTypeId() {
        return thirdTypeId;
    }

    public void setThirdTypeId(Long thirdTypeId) {
        this.thirdTypeId = thirdTypeId;
    }

    public String getThirdTypeName() {
        return thirdTypeName;
    }

    public void setThirdTypeName(String thirdTypeName) {
        this.thirdTypeName = thirdTypeName;
    }

    public Date getThirdEndDate() {
        return thirdEndDate;
    }

    public void setThirdEndDate(Date thirdEndDate) {
        this.thirdEndDate = thirdEndDate;
    }

    public Long getThirdResultId() {
        return thirdResultId;
    }

    public void setThirdResultId(Long thirdResultId) {
        this.thirdResultId = thirdResultId;
    }

    public String getThirdResultName() {
        return thirdResultName;
    }

    public void setThirdResultName(String thirdResultName) {
        this.thirdResultName = thirdResultName;
    }

    public BigDecimal getThirdEndAmount() {
        return thirdEndAmount;
    }

    public void setThirdEndAmount(BigDecimal thirdEndAmount) {
        this.thirdEndAmount = thirdEndAmount;
    }

    public Date getThirdAppealDate() {
        return thirdAppealDate;
    }

    public void setThirdAppealDate(Date thirdAppealDate) {
        this.thirdAppealDate = thirdAppealDate;
    }

    public Integer getCaseNum() {
        return caseNum;
    }

    public void setCaseNum(Integer caseNum) {
        this.caseNum = caseNum;
    }
}
