package com.ejianc.business.law.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 资金解冻表
 *
 * @author generator
 */
public class ThawFundVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long caseId; // 案件id
    private String caseCode; // 案件编号
    private Long frozenId; // 冻结id
    private String frozenCode; // 冻结编码
    private Long thawState; // 解冻状态
    private String thawStateName; // 解冻状态名称
    private Long thawType; // 解冻类型
    private String thawTypeName; // 解冻类型名称
    private Long departmentId; // 项目部
    private String departmentName; // 项目部名称
    private Long projectId; // 工程
    private String projectName; // 工程名称
    private BigDecimal thawAmount; // 解冻金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date thawDate; // 完全解冻日期
    private Long lawsuitCode; // 诉讼案号
    private String lawsuitCodeName; // 诉讼案号名称
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private BigDecimal unfreezableAmount; //可解冻金额
    private Long frozenType;//冻结类型
    private String frozenTypeName; //冻结类型名称
    private BigDecimal totalFrozenPrice;//冻结总金额

    public BigDecimal getTotalFrozenPrice() {
        return totalFrozenPrice;
    }

    public void setTotalFrozenPrice(BigDecimal totalFrozenPrice) {
        this.totalFrozenPrice = totalFrozenPrice;
    }

    public Long getFrozenType() {
        return frozenType;
    }

    public void setFrozenType(Long frozenType) {
        this.frozenType = frozenType;
    }

    public String getFrozenTypeName() {
        return frozenTypeName;
    }

    public void setFrozenTypeName(String frozenTypeName) {
        this.frozenTypeName = frozenTypeName;
    }



    public BigDecimal getUnfreezableAmount() {
        return unfreezableAmount;
    }

    public void setUnfreezableAmount(BigDecimal unfreezableAmount) {
        this.unfreezableAmount = unfreezableAmount;
    }

    private List<ThawFundZiVO> thawFundZiList = new ArrayList<>(); // 资金解冻表子表

    public List<ThawFundZiVO> getThawFundZiList() {
        return thawFundZiList;
    }

    public void setThawFundZiList(List<ThawFundZiVO> thawFundZiList) {
        this.thawFundZiList = thawFundZiList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "law-case-registe")
    public Long getCaseId() {
        return caseId;
    }

    @ReferDeserialTransfer
    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }

    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }

    @ReferSerialTransfer(referCode = "law-frozen-fund")
    public Long getFrozenId() {
        return frozenId;
    }

    @ReferDeserialTransfer
    public void setFrozenId(Long frozenId) {
        this.frozenId = frozenId;
    }

    public String getFrozenCode() {
        return frozenCode;
    }

    public void setFrozenCode(String frozenCode) {
        this.frozenCode = frozenCode;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getThawState() {
        return thawState;
    }

    @ReferDeserialTransfer
    public void setThawState(Long thawState) {
        this.thawState = thawState;
    }

    public String getThawStateName() {
        return thawStateName;
    }

    public void setThawStateName(String thawStateName) {
        this.thawStateName = thawStateName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getThawType() {
        return thawType;
    }

    @ReferDeserialTransfer
    public void setThawType(Long thawType) {
        this.thawType = thawType;
    }

    public String getThawTypeName() {
        return thawTypeName;
    }

    public void setThawTypeName(String thawTypeName) {
        this.thawTypeName = thawTypeName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BigDecimal getThawAmount() {
        return thawAmount;
    }

    public void setThawAmount(BigDecimal thawAmount) {
        this.thawAmount = thawAmount;
    }

    public Date getThawDate() {
        return thawDate;
    }

    public void setThawDate(Date thawDate) {
        this.thawDate = thawDate;
    }

    public Long getLawsuitCode() {
        return lawsuitCode;
    }

    public void setLawsuitCode(Long lawsuitCode) {
        this.lawsuitCode = lawsuitCode;
    }

    public String getLawsuitCodeName() {
        return lawsuitCodeName;
    }

    public void setLawsuitCodeName(String lawsuitCodeName) {
        this.lawsuitCodeName = lawsuitCodeName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}
