package com.ejianc.business.law.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 案件台账
 * 
 * @author generator
 * 
 */
public class LedgerVO extends CaseRegisteVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private String orgCode; // 组织编号
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String operatorCode; // 经办人联系方式
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long caseId; // 案件id
    private String caseCode; // 案件编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date cognizanceDate; // 收案日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结案日期
    private BigDecimal sueAmount; // 起诉金额（元）
    private BigDecimal endAmount; // 结案金额
    private Long departmentId; // 涉案项目部
    private String departmentName; // 涉案项目部名称
    private Long projectId; // 工程
    private String projectName; // 工程名称
    private String contractCost; // 合同造价（万元）
    private String disputeType; // 纠纷类型
    private String disputeTypeName; // 纠纷类型名称
    private Long labDisputeType; // 劳务类纠纷
    private String labDisputeTypeName; // 劳务类纠纷名称
    private Long caseState; // 案件状态
    private String caseStateName; // 案件状态名称
    private Long caseResultId; // 案件结果id
    private String caseResultName; // 案件结果
    private Long payState; // 付款状态
    private String payStateName; // 付款状态名称
    private Integer hearCount; // 审理次数
    private Long plaintiffId; // 原告id
    private String plaintiffName; // 原告
    private Long otherDefendantId; // 其他被告id
    private String otherDefendantName; // 其他被告
    private Long thirdPartyId; // 第三人id
    private String thirdPartyName; // 第三人
    private Long frozenId;//冻结id
    private String frozenCode;//冻结编号
    private Long thawId;//解冻id
    private String thawCode;//解冻编号
    private Long infoId;//审理id
    private Integer caseType;//案件类型
    private List<InfoRegisterVO> infoRegisterVOS = new ArrayList<>();
    private List<FrozenFundVO> frozenFundVOS = new ArrayList<>();
    private List<ThawFundVO> thawFundVOS = new ArrayList<>();

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getCaseId() {
        return caseId;
    }

    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }
    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }
    public Date getCognizanceDate() {
        return cognizanceDate;
    }

    public void setCognizanceDate(Date cognizanceDate) {
        this.cognizanceDate = cognizanceDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getSueAmount() {
        return sueAmount;
    }

    public void setSueAmount(BigDecimal sueAmount) {
        this.sueAmount = sueAmount;
    }
    public BigDecimal getEndAmount() {
        return endAmount;
    }

    public void setEndAmount(BigDecimal endAmount) {
        this.endAmount = endAmount;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getContractCost() {
        return contractCost;
    }

    public void setContractCost(String contractCost) {
        this.contractCost = contractCost;
    }

    public String getDisputeType() {
        return disputeType;
    }

    public void setDisputeType(String disputeType) {
        this.disputeType = disputeType;
    }
    public String getDisputeTypeName() {
        return disputeTypeName;
    }

    public void setDisputeTypeName(String disputeTypeName) {
        this.disputeTypeName = disputeTypeName;
    }
    public Long getLabDisputeType() {
        return labDisputeType;
    }

    public void setLabDisputeType(Long labDisputeType) {
        this.labDisputeType = labDisputeType;
    }
    public String getLabDisputeTypeName() {
        return labDisputeTypeName;
    }

    public void setLabDisputeTypeName(String labDisputeTypeName) {
        this.labDisputeTypeName = labDisputeTypeName;
    }
    public Long getCaseState() {
        return caseState;
    }

    public void setCaseState(Long caseState) {
        this.caseState = caseState;
    }
    public String getCaseStateName() {
        return caseStateName;
    }

    public void setCaseStateName(String caseStateName) {
        this.caseStateName = caseStateName;
    }
    public Long getCaseResultId() {
        return caseResultId;
    }

    public void setCaseResultId(Long caseResultId) {
        this.caseResultId = caseResultId;
    }
    public String getCaseResultName() {
        return caseResultName;
    }

    public void setCaseResultName(String caseResultName) {
        this.caseResultName = caseResultName;
    }
    public Long getPayState() {
        return payState;
    }

    public void setPayState(Long payState) {
        this.payState = payState;
    }
    public String getPayStateName() {
        return payStateName;
    }

    public void setPayStateName(String payStateName) {
        this.payStateName = payStateName;
    }
    public Integer getHearCount() {
        return hearCount;
    }

    public void setHearCount(Integer hearCount) {
        this.hearCount = hearCount;
    }
    public Long getPlaintiffId() {
        return plaintiffId;
    }

    public void setPlaintiffId(Long plaintiffId) {
        this.plaintiffId = plaintiffId;
    }
    public String getPlaintiffName() {
        return plaintiffName;
    }

    public void setPlaintiffName(String plaintiffName) {
        this.plaintiffName = plaintiffName;
    }
    public Long getOtherDefendantId() {
        return otherDefendantId;
    }

    public void setOtherDefendantId(Long otherDefendantId) {
        this.otherDefendantId = otherDefendantId;
    }
    public String getOtherDefendantName() {
        return otherDefendantName;
    }

    public void setOtherDefendantName(String otherDefendantName) {
        this.otherDefendantName = otherDefendantName;
    }
    public Long getThirdPartyId() {
        return thirdPartyId;
    }

    public void setThirdPartyId(Long thirdPartyId) {
        this.thirdPartyId = thirdPartyId;
    }
    public String getThirdPartyName() {
        return thirdPartyName;
    }

    public void setThirdPartyName(String thirdPartyName) {
        this.thirdPartyName = thirdPartyName;
    }

    public Long getFrozenId() {
        return frozenId;
    }

    public void setFrozenId(Long frozenId) {
        this.frozenId = frozenId;
    }

    public String getFrozenCode() {
        return frozenCode;
    }

    public void setFrozenCode(String frozenCode) {
        this.frozenCode = frozenCode;
    }

    public Long getThawId() {
        return thawId;
    }

    public void setThawId(Long thawId) {
        this.thawId = thawId;
    }

    public String getThawCode() {
        return thawCode;
    }

    public void setThawCode(String thawCode) {
        this.thawCode = thawCode;
    }

    public Long getInfoId() {
        return infoId;
    }

    public void setInfoId(Long infoId) {
        this.infoId = infoId;
    }

    public Integer getCaseType() {
        return caseType;
    }

    public void setCaseType(Integer caseType) {
        this.caseType = caseType;
    }

    public List<InfoRegisterVO> getInfoRegisterVOS() {
        return infoRegisterVOS;
    }

    public void setInfoRegisterVOS(List<InfoRegisterVO> infoRegisterVOS) {
        this.infoRegisterVOS = infoRegisterVOS;
    }

    public List<FrozenFundVO> getFrozenFundVOS() {
        return frozenFundVOS;
    }

    public void setFrozenFundVOS(List<FrozenFundVO> frozenFundVOS) {
        this.frozenFundVOS = frozenFundVOS;
    }

    public List<ThawFundVO> getThawFundVOS() {
        return thawFundVOS;
    }

    public void setThawFundVOS(List<ThawFundVO> thawFundVOS) {
        this.thawFundVOS = thawFundVOS;
    }


}
