package com.ejianc.business.law.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.law.bean.PartyEntity;
/**
 * 案件登记表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_law_case_register")
public class CaseRegisteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="operator_code")
    private String operatorCode; // 经办人联系方式
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="case_code")
    private String caseCode; // 案件编号
    @TableField(value="cognizance_date")
    private Date cognizanceDate; // 收案日期
    @TableField(value="sue_amount")
    private BigDecimal sueAmount; // 起诉金额（元）
    @TableField(value="department_id")
    private Long departmentId; // 涉案项目部
    @TableField(value="department_name")
    private String departmentName; // 涉案项目部名称
    @TableField(value="project_id")
    private Long projectId; // 工程
    @TableField(value="project_name")
    private String projectName; // 工程名称
    @TableField(value="contract_cost")
    private BigDecimal contractCost; // 合同造价（万元）
    @TableField(value="dispute_type")
    private Long disputeType; // 纠纷类型
    @TableField(value="dispute_type_name")
    private String disputeTypeName; // 纠纷类型名称
    @TableField(value="lab_dispute_type")
    private Long labDisputeType; // 劳务类纠纷
    @TableField(value="lab_dispute_type_name")
    private String labDisputeTypeName; // 劳务类纠纷名称
    @TableField(value="case_report")
    private String caseReport; // 案情通报
    @TableField(value="case_state")
    private Long caseState; // 案件状态
    @TableField(value="case_state_name")
    private String caseStateName; // 案件状态名称
    @TableField(value="pay_state")
    private Long payState; // 付款状态
    @TableField(value="pay_state_name")
    private String payStateName; // 付款状态名称
    @TableField(value="hear_count")
    private Integer hearCount; // 审理次数
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="partyService", pidName = "zhuId")
    private List<PartyEntity> partyList = new ArrayList<>(); // 当事人登记表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }
    public Date getCognizanceDate() {
        return cognizanceDate;
    }

    public void setCognizanceDate(Date cognizanceDate) {
        this.cognizanceDate = cognizanceDate;
    }
    public BigDecimal getSueAmount() {
        return sueAmount;
    }

    public void setSueAmount(BigDecimal sueAmount) {
        this.sueAmount = sueAmount;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getContractCost() {
        return contractCost;
    }

    public void setContractCost(BigDecimal contractCost) {
        this.contractCost = contractCost;
    }
    public Long getDisputeType() {
        return disputeType;
    }

    public void setDisputeType(Long disputeType) {
        this.disputeType = disputeType;
    }
    public String getDisputeTypeName() {
        return disputeTypeName;
    }

    public void setDisputeTypeName(String disputeTypeName) {
        this.disputeTypeName = disputeTypeName;
    }
    public Long getLabDisputeType() {
        return labDisputeType;
    }

    public void setLabDisputeType(Long labDisputeType) {
        this.labDisputeType = labDisputeType;
    }
    public String getLabDisputeTypeName() {
        return labDisputeTypeName;
    }

    public void setLabDisputeTypeName(String labDisputeTypeName) {
        this.labDisputeTypeName = labDisputeTypeName;
    }
    public String getCaseReport() {
        return caseReport;
    }

    public void setCaseReport(String caseReport) {
        this.caseReport = caseReport;
    }
    public Long getCaseState() {
        return caseState;
    }

    public void setCaseState(Long caseState) {
        this.caseState = caseState;
    }
    public String getCaseStateName() {
        return caseStateName;
    }

    public void setCaseStateName(String caseStateName) {
        this.caseStateName = caseStateName;
    }
    public Long getPayState() {
        return payState;
    }

    public void setPayState(Long payState) {
        this.payState = payState;
    }
    public String getPayStateName() {
        return payStateName;
    }

    public void setPayStateName(String payStateName) {
        this.payStateName = payStateName;
    }
    public Integer getHearCount() {
        return hearCount;
    }

    public void setHearCount(Integer hearCount) {
        this.hearCount = hearCount;
    }
    

    public List<PartyEntity> getPartyList() {
        return partyList;
    }

    public void setPartyList(List<PartyEntity> partyList) {
        this.partyList = partyList;
    }
}
