package com.ejianc.business.law.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.law.bean.CasePaymentZiEntity;
/**
 * 案件付款情况登记表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_law_case_payment")
public class CasePaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="case_id")
    private Long caseId; // 案件id
    @TableField(value="case_code")
    private String caseCode; // 案件编号
    @TableField(value="case_name")
    private String caseName; // 案件名称
    @TableField(value="payment_state")
    private Long paymentState; // 付款状态
    @TableField(value="pay_state_name")
    private String payStateName; // 付款状态名称
    @TableField(value="department_id")
    private Long departmentId; // 项目部
    @TableField(value="department_name")
    private String departmentName; // 项目部名称
    @TableField(value="project_id")
    private Long projectId; // 工程
    @TableField(value="project_name")
    private String projectName; // 工程名称
    @TableField(value="payment_type")
    private Long paymentType; // 付款类型
    @TableField(value="lawsuit_code")
    private String lawsuitCode; // 诉讼编号
    @TableField(value="payable_company")
    private String payableCompany; // 应付单位
    @TableField(value="total_amount_payable")
    private BigDecimal totalAmountPayable; // 应付总金额
    @TableField(value="total_amount_unpaid")
    private BigDecimal totalAmountUnpaid; // 未付总金额
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="payment_type_name")
    private String paymentTypeName; // 付款类型名称
    @TableField(value="case_report")
    private Long caseReport; // 案情通报
    @TableField(value="case_report_name")
    private String caseReportName; // 案情通报名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="casePaymentZiService",pidName = "zhuId")
    private List<CasePaymentZiEntity> casePaymentZiList = new ArrayList<>(); // 案件付款情况登记子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getCaseId() {
        return caseId;
    }

    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }
    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }
    public String getCaseName() {
        return caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }
    public Long getPaymentState() {
        return paymentState;
    }

    public void setPaymentState(Long paymentState) {
        this.paymentState = paymentState;
    }
    public String getPayStateName() {
        return payStateName;
    }

    public void setPayStateName(String payStateName) {
        this.payStateName = payStateName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Long paymentType) {
        this.paymentType = paymentType;
    }
    public String getLawsuitCode() {
        return lawsuitCode;
    }

    public void setLawsuitCode(String lawsuitCode) {
        this.lawsuitCode = lawsuitCode;
    }
    public String getPayableCompany() {
        return payableCompany;
    }

    public void setPayableCompany(String payableCompany) {
        this.payableCompany = payableCompany;
    }
    public BigDecimal getTotalAmountPayable() {
        return totalAmountPayable;
    }

    public void setTotalAmountPayable(BigDecimal totalAmountPayable) {
        this.totalAmountPayable = totalAmountPayable;
    }
    public BigDecimal getTotalAmountUnpaid() {
        return totalAmountUnpaid;
    }

    public void setTotalAmountUnpaid(BigDecimal totalAmountUnpaid) {
        this.totalAmountUnpaid = totalAmountUnpaid;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getPaymentTypeName() {
        return paymentTypeName;
    }

    public void setPaymentTypeName(String paymentTypeName) {
        this.paymentTypeName = paymentTypeName;
    }
    public Long getCaseReport() {
        return caseReport;
    }

    public void setCaseReport(Long caseReport) {
        this.caseReport = caseReport;
    }
    public String getCaseReportName() {
        return caseReportName;
    }

    public void setCaseReportName(String caseReportName) {
        this.caseReportName = caseReportName;
    }
    

    public List<CasePaymentZiEntity> getCasePaymentZiList() {
        return casePaymentZiList;
    }

    public void setCasePaymentZiList(List<CasePaymentZiEntity> casePaymentZiList) {
        this.casePaymentZiList = casePaymentZiList;
    }
}
