package com.ejianc.business.law.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.law.bean.PartyEntity;
/**
 * 案件登记表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_law_case_register")
public class CaseRegisteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="operator_code")
    private String operatorCode; // 经办人联系方式
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="case_code")
    private String caseCode; // 案件编号
    @TableField(value="cognizance_date")
    private Date cognizanceDate; // 收案日期
    @TableField(value="sue_amount")
    private BigDecimal sueAmount; // 起诉金额（元）
    @TableField(value="department_id")
    private Long departmentId; // 涉案项目部
    @TableField(value="department_name")
    private String departmentName; // 涉案项目部名称
    @TableField(value="project_id")
    private Long projectId; // 工程
    @TableField(value="project_name")
    private String projectName; // 工程名称
    @TableField(value="contract_cost")
    private BigDecimal contractCost; // 合同造价（万元）
    @TableField(value="dispute_type")
    private String disputeType; // 纠纷类型
    @TableField(value="dispute_type_name")
    private String disputeTypeName; // 纠纷类型名称
    @TableField(value="lab_dispute_type")
    private Long labDisputeType; // 劳务类纠纷
    @TableField(value="lab_dispute_type_name")
    private String labDisputeTypeName; // 劳务类纠纷名称
    @TableField(value="case_report")
    private String caseReport; // 案情通报
    @TableField(value="case_state")
    private Long caseState; // 案件状态
    @TableField(value="case_state_name")
    private String caseStateName; // 案件状态名称
    @TableField(value="pay_state")
    private Long payState; // 付款状态
    @TableField(value="pay_state_name")
    private String payStateName; // 付款状态名称
    @TableField(value="hear_count")
    private Integer hearCount; // 审理次数
    @TableField(value="cognizance_type")
    private String cognizanceType; // 收案渠道
    @TableField(value="sue_amount_one")
    private BigDecimal sueAmountOne; // 起诉相关金额（元）
    @TableField(value="case_name")
    private String caseName; // 案件名称
    @TableField(value="plaintiff_main_id")
    private Long plaintiffMainId; // 主原告id
    @TableField(value="plaintiff_main_name")
    private String plaintiffMainName; // 主原告名称
    @TableField(value="plaintiff_other_id")
    private Long plaintiffOtherId; // 其他原告id
    @TableField(value="plaintiff_other_name")
    private String plaintiffOtherName; // 其他原告名称
    @TableField(value="defendant_main_id")
    private Long defendantMainId; // 主被告id
    @TableField(value="defendant_main_name")
    private String defendantMainName; // 主被告名称
    @TableField(value="defendant_other_id")
    private Long defendantOtherId; // 其他被告id
    @TableField(value="defendant_other_name")
    private String defendantOtherName; // 其他被告名称
    @TableField(value="case_result")
    private String caseResult; // 案件结果
    @TableField(value="case_report_last")
    private String caseReportLast; // 案情通报
    @TableField(value="frozen_code")
    private String frozenCode; // 资金冻结单编号
    @TableField(value="unfreeze_code")
    private String unfreezeCode; // 资金解结单编号
    @TableField(value="first_court_id")
    private Long firstCourtId; // 一审法院
    @TableField(value="first_court_name")
    private String firstCourtName; // 一审法院名称
    @TableField(value="first_judge_name")
    private String firstJudgeName; // 法官名称
    @TableField(value="first_judge_code")
    private String firstJudgeCode; // 法官联系方式
    @TableField(value="first_start_date")
    private Date firstStartDate; // 开庭日期
    @TableField(value="first_code")
    private String firstCode; // 一审案号
    @TableField(value="first_type_id")
    private Long firstTypeId; // 审理程序
    @TableField(value="first_type_name")
    private String firstTypeName; // 审理程序名称
    @TableField(value="first_end_date")
    private Date firstEndDate; // 结案日期
    @TableField(value="first_result_id")
    private Long firstResultId; // 案件结果
    @TableField(value="first_result_name")
    private String firstResultName; // 案件结果
    @TableField(value="first_end_amount")
    private BigDecimal firstEndAmount; // 结案金额
    @TableField(value="first_appeal_date")
    private Date firstAppealDate; // 上诉截至日期
    @TableField(value="first_last_date")
    private Date firstLastDate; // 再审截至日期
    @TableField(value="second_court_id")
    private Long secondCourtId; // 二审法院
    @TableField(value="second_court_name")
    private String secondCourtName; // 二审法院名称
    @TableField(value="second_judge_name")
    private String secondJudgeName; // 法官名称
    @TableField(value="second_judge_code")
    private String secondJudgeCode; // 法官联系方式
    @TableField(value="second_start_date")
    private Date secondStartDate; // 开庭日期
    @TableField(value="second_code")
    private String secondCode; // 二审案号
    @TableField(value="second_type_id")
    private Long secondTypeId; // 审理程序
    @TableField(value="second_type_name")
    private String secondTypeName; // 审理程序名称
    @TableField(value="second_end_date")
    private Date secondEndDate; // 结案日期
    @TableField(value="second_result_id")
    private Long secondResultId; // 案件结果
    @TableField(value="second_result_name")
    private String secondResultName; // 案件结果
    @TableField(value="second_end_amount")
    private BigDecimal secondEndAmount; // 结案金额
    @TableField(value="second_appeal_date")
    private Date secondAppealDate; // 上诉截至日期
    @TableField(value="second_last_date")
    private Date secondLastDate; // 再审截至日期
    @TableField(value="third_court_id")
    private Long thirdCourtId; // 三审法院
    @TableField(value="third_court_name")
    private String thirdCourtName; // 三审法院名称
    @TableField(value="third_judge_name")
    private String thirdJudgeName; // 法官名称
    @TableField(value="third_judge_code")
    private String thirdJudgeCode; // 法官联系方式
    @TableField(value="third_start_date")
    private Date thirdStartDate; // 开庭日期
    @TableField(value="third_code")
    private String thirdCode; // 三审案号
    @TableField(value="third_type_id")
    private Long thirdTypeId; // 审理程序
    @TableField(value="third_type_name")
    private String thirdTypeName; // 审理程序名称
    @TableField(value="third_end_date")
    private Date thirdEndDate; // 结案日期
    @TableField(value="third_result_id")
    private Long thirdResultId; // 案件结果
    @TableField(value="third_result_name")
    private String thirdResultName; // 案件结果
    @TableField(value="third_end_amount")
    private BigDecimal thirdEndAmount; // 结案金额
    @TableField(value="third_appeal_date")
    private Date thirdAppealDate; // 上诉截至日期
    @TableField(value="case_num")
    private Integer caseNum; // 案件进度0123
    @TableField(value="second_amount")
    private BigDecimal secondAmount; // 上诉金额
    @TableField(value="third_amount")
    private BigDecimal thirdAmount; // 再审金额


    public BigDecimal getSecondAmount() {
        return secondAmount;
    }

    public void setSecondAmount(BigDecimal secondAmount) {
        this.secondAmount = secondAmount;
    }

    public BigDecimal getThirdAmount() {
        return thirdAmount;
    }

    public void setThirdAmount(BigDecimal thirdAmount) {
        this.thirdAmount = thirdAmount;
    }

    @TableField(exist=false)
    @SubEntity(serviceName="partyService", pidName = "zhuId")
    private List<PartyEntity> partyList = new ArrayList<>(); // 当事人登记表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getCaseCode() {
        return caseCode;
    }

    public void setCaseCode(String caseCode) {
        this.caseCode = caseCode;
    }
    public Date getCognizanceDate() {
        return cognizanceDate;
    }

    public void setCognizanceDate(Date cognizanceDate) {
        this.cognizanceDate = cognizanceDate;
    }
    public BigDecimal getSueAmount() {
        return sueAmount;
    }

    public void setSueAmount(BigDecimal sueAmount) {
        this.sueAmount = sueAmount;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getContractCost() {
        return contractCost;
    }

    public void setContractCost(BigDecimal contractCost) {
        this.contractCost = contractCost;
    }
    public String getDisputeType() {
        return disputeType;
    }

    public void setDisputeType(String disputeType) {
        this.disputeType = disputeType;
    }
    public String getDisputeTypeName() {
        return disputeTypeName;
    }

    public void setDisputeTypeName(String disputeTypeName) {
        this.disputeTypeName = disputeTypeName;
    }
    public Long getLabDisputeType() {
        return labDisputeType;
    }

    public void setLabDisputeType(Long labDisputeType) {
        this.labDisputeType = labDisputeType;
    }
    public String getLabDisputeTypeName() {
        return labDisputeTypeName;
    }

    public void setLabDisputeTypeName(String labDisputeTypeName) {
        this.labDisputeTypeName = labDisputeTypeName;
    }
    public String getCaseReport() {
        return caseReport;
    }

    public void setCaseReport(String caseReport) {
        this.caseReport = caseReport;
    }
    public Long getCaseState() {
        return caseState;
    }

    public void setCaseState(Long caseState) {
        this.caseState = caseState;
    }
    public String getCaseStateName() {
        return caseStateName;
    }

    public void setCaseStateName(String caseStateName) {
        this.caseStateName = caseStateName;
    }
    public Long getPayState() {
        return payState;
    }

    public void setPayState(Long payState) {
        this.payState = payState;
    }
    public String getPayStateName() {
        return payStateName;
    }

    public void setPayStateName(String payStateName) {
        this.payStateName = payStateName;
    }
    public Integer getHearCount() {
        return hearCount;
    }

    public void setHearCount(Integer hearCount) {
        this.hearCount = hearCount;
    }


    public String getCognizanceType() {
        return cognizanceType;
    }

    public void setCognizanceType(String cognizanceType) {
        this.cognizanceType = cognizanceType;
    }

    public BigDecimal getSueAmountOne() {
        return sueAmountOne;
    }

    public void setSueAmountOne(BigDecimal sueAmountOne) {
        this.sueAmountOne = sueAmountOne;
    }

    public String getCaseName() {
        return caseName;
    }

    public void setCaseName(String caseName) {
        this.caseName = caseName;
    }

    public Long getPlaintiffMainId() {
        return plaintiffMainId;
    }

    public void setPlaintiffMainId(Long plaintiffMainId) {
        this.plaintiffMainId = plaintiffMainId;
    }

    public String getPlaintiffMainName() {
        return plaintiffMainName;
    }

    public void setPlaintiffMainName(String plaintiffMainName) {
        this.plaintiffMainName = plaintiffMainName;
    }

    public Long getPlaintiffOtherId() {
        return plaintiffOtherId;
    }

    public void setPlaintiffOtherId(Long plaintiffOtherId) {
        this.plaintiffOtherId = plaintiffOtherId;
    }

    public String getPlaintiffOtherName() {
        return plaintiffOtherName;
    }

    public void setPlaintiffOtherName(String plaintiffOtherName) {
        this.plaintiffOtherName = plaintiffOtherName;
    }

    public Long getDefendantMainId() {
        return defendantMainId;
    }

    public void setDefendantMainId(Long defendantMainId) {
        this.defendantMainId = defendantMainId;
    }

    public String getDefendantMainName() {
        return defendantMainName;
    }

    public void setDefendantMainName(String defendantMainName) {
        this.defendantMainName = defendantMainName;
    }

    public Long getDefendantOtherId() {
        return defendantOtherId;
    }

    public void setDefendantOtherId(Long defendantOtherId) {
        this.defendantOtherId = defendantOtherId;
    }

    public String getDefendantOtherName() {
        return defendantOtherName;
    }

    public void setDefendantOtherName(String defendantOtherName) {
        this.defendantOtherName = defendantOtherName;
    }

    public List<PartyEntity> getPartyList() {
        return partyList;
    }

    public void setPartyList(List<PartyEntity> partyList) {
        this.partyList = partyList;
    }

    public String getCaseResult() {
        return caseResult;
    }

    public void setCaseResult(String caseResult) {
        this.caseResult = caseResult;
    }

    public String getCaseReportLast() {
        return caseReportLast;
    }

    public void setCaseReportLast(String caseReportLast) {
        this.caseReportLast = caseReportLast;
    }

    public String getFrozenCode() {
        return frozenCode;
    }

    public void setFrozenCode(String frozenCode) {
        this.frozenCode = frozenCode;
    }

    public String getUnfreezeCode() {
        return unfreezeCode;
    }

    public void setUnfreezeCode(String unfreezeCode) {
        this.unfreezeCode = unfreezeCode;
    }

    public Long getFirstCourtId() {
        return firstCourtId;
    }

    public void setFirstCourtId(Long firstCourtId) {
        this.firstCourtId = firstCourtId;
    }

    public String getFirstCourtName() {
        return firstCourtName;
    }

    public void setFirstCourtName(String firstCourtName) {
        this.firstCourtName = firstCourtName;
    }

    public String getFirstJudgeName() {
        return firstJudgeName;
    }

    public void setFirstJudgeName(String firstJudgeName) {
        this.firstJudgeName = firstJudgeName;
    }

    public String getFirstJudgeCode() {
        return firstJudgeCode;
    }

    public void setFirstJudgeCode(String firstJudgeCode) {
        this.firstJudgeCode = firstJudgeCode;
    }

    public Date getFirstStartDate() {
        return firstStartDate;
    }

    public void setFirstStartDate(Date firstStartDate) {
        this.firstStartDate = firstStartDate;
    }

    public String getFirstCode() {
        return firstCode;
    }

    public void setFirstCode(String firstCode) {
        this.firstCode = firstCode;
    }

    public Long getFirstTypeId() {
        return firstTypeId;
    }

    public void setFirstTypeId(Long firstTypeId) {
        this.firstTypeId = firstTypeId;
    }

    public String getFirstTypeName() {
        return firstTypeName;
    }

    public void setFirstTypeName(String firstTypeName) {
        this.firstTypeName = firstTypeName;
    }

    public Date getFirstEndDate() {
        return firstEndDate;
    }

    public void setFirstEndDate(Date firstEndDate) {
        this.firstEndDate = firstEndDate;
    }

    public Long getFirstResultId() {
        return firstResultId;
    }

    public void setFirstResultId(Long firstResultId) {
        this.firstResultId = firstResultId;
    }

    public String getFirstResultName() {
        return firstResultName;
    }

    public void setFirstResultName(String firstResultName) {
        this.firstResultName = firstResultName;
    }

    public BigDecimal getFirstEndAmount() {
        return firstEndAmount;
    }

    public void setFirstEndAmount(BigDecimal firstEndAmount) {
        this.firstEndAmount = firstEndAmount;
    }

    public Date getFirstAppealDate() {
        return firstAppealDate;
    }

    public void setFirstAppealDate(Date firstAppealDate) {
        this.firstAppealDate = firstAppealDate;
    }

    public Date getFirstLastDate() {
        return firstLastDate;
    }

    public void setFirstLastDate(Date firstLastDate) {
        this.firstLastDate = firstLastDate;
    }

    public Long getSecondCourtId() {
        return secondCourtId;
    }

    public void setSecondCourtId(Long secondCourtId) {
        this.secondCourtId = secondCourtId;
    }

    public String getSecondCourtName() {
        return secondCourtName;
    }

    public void setSecondCourtName(String secondCourtName) {
        this.secondCourtName = secondCourtName;
    }

    public String getSecondJudgeName() {
        return secondJudgeName;
    }

    public void setSecondJudgeName(String secondJudgeName) {
        this.secondJudgeName = secondJudgeName;
    }

    public String getSecondJudgeCode() {
        return secondJudgeCode;
    }

    public void setSecondJudgeCode(String secondJudgeCode) {
        this.secondJudgeCode = secondJudgeCode;
    }

    public Date getSecondStartDate() {
        return secondStartDate;
    }

    public void setSecondStartDate(Date secondStartDate) {
        this.secondStartDate = secondStartDate;
    }

    public String getSecondCode() {
        return secondCode;
    }

    public void setSecondCode(String secondCode) {
        this.secondCode = secondCode;
    }

    public Long getSecondTypeId() {
        return secondTypeId;
    }

    public void setSecondTypeId(Long secondTypeId) {
        this.secondTypeId = secondTypeId;
    }

    public String getSecondTypeName() {
        return secondTypeName;
    }

    public void setSecondTypeName(String secondTypeName) {
        this.secondTypeName = secondTypeName;
    }

    public Date getSecondEndDate() {
        return secondEndDate;
    }

    public void setSecondEndDate(Date secondEndDate) {
        this.secondEndDate = secondEndDate;
    }

    public Long getSecondResultId() {
        return secondResultId;
    }

    public void setSecondResultId(Long secondResultId) {
        this.secondResultId = secondResultId;
    }

    public String getSecondResultName() {
        return secondResultName;
    }

    public void setSecondResultName(String secondResultName) {
        this.secondResultName = secondResultName;
    }

    public BigDecimal getSecondEndAmount() {
        return secondEndAmount;
    }

    public void setSecondEndAmount(BigDecimal secondEndAmount) {
        this.secondEndAmount = secondEndAmount;
    }

    public Date getSecondAppealDate() {
        return secondAppealDate;
    }

    public void setSecondAppealDate(Date secondAppealDate) {
        this.secondAppealDate = secondAppealDate;
    }

    public Date getSecondLastDate() {
        return secondLastDate;
    }

    public void setSecondLastDate(Date secondLastDate) {
        this.secondLastDate = secondLastDate;
    }

    public Long getThirdCourtId() {
        return thirdCourtId;
    }

    public void setThirdCourtId(Long thirdCourtId) {
        this.thirdCourtId = thirdCourtId;
    }

    public String getThirdCourtName() {
        return thirdCourtName;
    }

    public void setThirdCourtName(String thirdCourtName) {
        this.thirdCourtName = thirdCourtName;
    }

    public String getThirdJudgeName() {
        return thirdJudgeName;
    }

    public void setThirdJudgeName(String thirdJudgeName) {
        this.thirdJudgeName = thirdJudgeName;
    }

    public String getThirdJudgeCode() {
        return thirdJudgeCode;
    }

    public void setThirdJudgeCode(String thirdJudgeCode) {
        this.thirdJudgeCode = thirdJudgeCode;
    }

    public Date getThirdStartDate() {
        return thirdStartDate;
    }

    public void setThirdStartDate(Date thirdStartDate) {
        this.thirdStartDate = thirdStartDate;
    }

    public String getThirdCode() {
        return thirdCode;
    }

    public void setThirdCode(String thirdCode) {
        this.thirdCode = thirdCode;
    }

    public Long getThirdTypeId() {
        return thirdTypeId;
    }

    public void setThirdTypeId(Long thirdTypeId) {
        this.thirdTypeId = thirdTypeId;
    }

    public String getThirdTypeName() {
        return thirdTypeName;
    }

    public void setThirdTypeName(String thirdTypeName) {
        this.thirdTypeName = thirdTypeName;
    }

    public Date getThirdEndDate() {
        return thirdEndDate;
    }

    public void setThirdEndDate(Date thirdEndDate) {
        this.thirdEndDate = thirdEndDate;
    }

    public Long getThirdResultId() {
        return thirdResultId;
    }

    public void setThirdResultId(Long thirdResultId) {
        this.thirdResultId = thirdResultId;
    }

    public String getThirdResultName() {
        return thirdResultName;
    }

    public void setThirdResultName(String thirdResultName) {
        this.thirdResultName = thirdResultName;
    }

    public BigDecimal getThirdEndAmount() {
        return thirdEndAmount;
    }

    public void setThirdEndAmount(BigDecimal thirdEndAmount) {
        this.thirdEndAmount = thirdEndAmount;
    }

    public Date getThirdAppealDate() {
        return thirdAppealDate;
    }

    public void setThirdAppealDate(Date thirdAppealDate) {
        this.thirdAppealDate = thirdAppealDate;
    }

    public Integer getCaseNum() {
        return caseNum;
    }

    public void setCaseNum(Integer caseNum) {
        this.caseNum = caseNum;
    }
}
