package com.ejianc.business.law.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.law.bean.CaseRegisteEntity;
import com.ejianc.business.law.bean.LedgerEntity;
import com.ejianc.business.law.service.ICaseRegisteService;
import com.ejianc.business.law.service.ILedgerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("caseRegiste") 
public class CaseRegisteBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ICaseRegisteService service;
	@Autowired
	private ILedgerService ledgerService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */

	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		CaseRegisteEntity entity = service.getById(billId);
		LedgerEntity ledgerEntity = ledgerService.getOne(Wrappers.<LedgerEntity>lambdaQuery().eq(LedgerEntity::getCaseId, entity.getId()));
		//案件台账关联更新
		if (entity != null){
			ledgerEntity.setCaseId(entity.getId());//案件编号
			ledgerEntity.setCaseCode(entity.getCaseCode());
			ledgerEntity.setEndDate(entity.getCognizanceDate());//收案日期
			ledgerEntity.setSueAmount(entity.getSueAmount());//起诉金额
			ledgerEntity.setDepartmentName(entity.getDepartmentName());//涉案项目部
			ledgerEntity.setProjectName(entity.getProjectName());//工程
			ledgerEntity.setDisputeType(entity.getDisputeType());//纠纷类型
			ledgerEntity.setDisputeTypeName(entity.getDisputeTypeName());
			ledgerEntity.setCaseState(entity.getCaseState());//案件状态
			ledgerEntity.setCaseStateName(entity.getCaseStateName());
			ledgerEntity.setPayState(entity.getPayState());//付款状态
			ledgerEntity.setPayStateName(entity.getPayStateName());
			ledgerEntity.setPlaintiffId(entity.getPlaintiffMainId());//原告
			ledgerEntity.setPlaintiffName(entity.getPlaintiffMainName());
			ledgerEntity.setOtherDefendantId(entity.getDefendantOtherId());//其他被告
			ledgerEntity.setOtherDefendantName(entity.getDefendantOtherName());
			ledgerEntity.setThirdPartyId(entity.getDefendantMainId());//第三人
			ledgerEntity.setThirdPartyName(entity.getDefendantMainName());
			ledgerService.saveOrUpdate(ledgerEntity);
















//			LedgerEntity ledgerEntity = new LedgerEntity();
//			ledgerEntity.setBillCode(entity.getBillCode());//单据编码
//			ledgerEntity.setOrgId(entity.getOrgId());//组织id
//			ledgerEntity.setOrgName(entity.getOrgName());//组织名称
//			ledgerEntity.setCaseId(billId);//案件id
//			ledgerEntity.setCaseCode(entity.getCaseCode());//案件编号
//			ledgerEntity.setCognizanceDate(entity.getCognizanceDate());//收案日期
//			ledgerEntity.setSueAmount(entity.getSueAmount());//起诉金额
//			ledgerEntity.setDepartmentId(entity.getDepartmentId());//涉案项目部
//			ledgerEntity.setDepartmentName(entity.getDepartmentName());//设按项目部名称
//			ledgerEntity.setProjectId(entity.getProjectId());//工程
//			ledgerEntity.setProjectName(entity.getProjectName());//工程名称
//			ledgerEntity.setContractCost(entity.getContractCost());//合同造价
//			//ledgerEntity.setDisputeType(entity.getDisputeType());//纠纷类型
//			ledgerEntity.setDisputeTypeName(entity.getDisputeTypeName());//纠纷类型名称
//			//ledgerEntity.setCaseState(entity.getCaseState());//案件状态
//			ledgerEntity.setCaseStateName(entity.getCaseStateName());//案件状态名称
//			ledgerEntity.setPayStateName(entity.getPayStateName());//付款状态
//			ledgerService.saveOrUpdate(ledgerEntity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
