/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.law.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.law.bean.CaseRegisteEntity;
import com.ejianc.business.law.bean.InfoRegisterEntity;
import com.ejianc.business.law.bean.LedgerEntity;
import com.ejianc.business.law.bean.PartyEntity;
import com.ejianc.business.law.service.ICaseRegisteService;
import com.ejianc.business.law.service.IInfoRegisterService;
import com.ejianc.business.law.service.ILedgerService;
import com.ejianc.business.law.vo.CaseRegisteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"caseRegiste"})
public class CaseRegisteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ICaseRegisteService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInfoRegisterService infoRegisterService;
    @Autowired
    private ILedgerService ledgerService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CaseRegisteVO> saveOrUpdate(@RequestBody CaseRegisteVO saveOrUpdateVO) {
        CaseRegisteEntity entity = (CaseRegisteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CaseRegisteEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        List<PartyEntity> partyList = entity.getPartyList();
        String a = "";
        String b = "";
        String c = "";
        for (PartyEntity partyEntity : partyList) {
            if ("\u539f\u544a".equals(partyEntity.getPartyTypeName())) {
                if ("".equals(a)) {
                    a = a + partyEntity.getPartyName();
                    continue;
                }
                a = a + "," + partyEntity.getPartyName();
                continue;
            }
            if ("\u5176\u4ed6\u88ab\u544a".equals(partyEntity.getPartyTypeName())) {
                if ("".equals(b)) {
                    b = b + partyEntity.getPartyName();
                    continue;
                }
                b = b + "," + partyEntity.getPartyName();
                continue;
            }
            if (!"\u7b2c\u4e09\u4eba".equals(partyEntity.getPartyTypeName())) continue;
            if ("".equals(c)) {
                c = c + partyEntity.getPartyName();
                continue;
            }
            c = c + "," + partyEntity.getPartyName();
        }
        entity.setPlaintiffOtherName(a);
        entity.setDefendantOtherName(b);
        entity.setDefendantMainName(c);
        this.service.saveOrUpdate((Object)entity, false);
        CaseRegisteVO vo = (CaseRegisteVO)BeanMapper.map((Object)((Object)entity), CaseRegisteVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CaseRegisteVO> queryDetail(Long id) {
        CaseRegisteEntity entity = (CaseRegisteEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u65e0\u6b64\u6761\u6570\u636e\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("case_id", new Parameter("eq", (Object)id));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List infoRegisterEntities = this.infoRegisterService.queryList(param);
        for (InfoRegisterEntity infoRegisterEntity : infoRegisterEntities) {
            if (infoRegisterEntity.getHearCount() == 1) {
                entity.setFirstCourtId(infoRegisterEntity.getFirstCourtId());
                entity.setFirstCourtName(infoRegisterEntity.getFirstCourtName());
                entity.setFirstJudgeName(infoRegisterEntity.getFirstJudgeName());
                entity.setFirstJudgeCode(infoRegisterEntity.getFirstJudgeCode());
                entity.setFirstStartDate(infoRegisterEntity.getFirstStartDate());
                entity.setFirstCode(infoRegisterEntity.getFirstCode());
                entity.setFirstTypeId(infoRegisterEntity.getFirstTypeId());
                entity.setFirstTypeName(infoRegisterEntity.getFirstTypeName());
                entity.setFirstEndDate(infoRegisterEntity.getFirstEndDate());
                entity.setFirstEndAmount(infoRegisterEntity.getFirstEndAmount());
                entity.setFirstResultId(infoRegisterEntity.getFirstResultId());
                entity.setFirstResultName(infoRegisterEntity.getFirstResultName());
                entity.setFirstAppealDate(infoRegisterEntity.getFirstAppealDate());
                entity.setFirstLastDate(infoRegisterEntity.getFirstLastDate());
                continue;
            }
            if (infoRegisterEntity.getHearCount() == 2) {
                entity.setSecondCourtId(infoRegisterEntity.getFirstCourtId());
                entity.setSecondCourtName(infoRegisterEntity.getFirstCourtName());
                entity.setSecondJudgeName(infoRegisterEntity.getFirstJudgeName());
                entity.setSecondJudgeCode(infoRegisterEntity.getFirstJudgeCode());
                entity.setSecondStartDate(infoRegisterEntity.getFirstStartDate());
                entity.setSecondCode(infoRegisterEntity.getFirstCode());
                entity.setSecondTypeId(infoRegisterEntity.getFirstTypeId());
                entity.setSecondTypeName(infoRegisterEntity.getFirstTypeName());
                entity.setSecondEndDate(infoRegisterEntity.getFirstEndDate());
                entity.setSecondEndAmount(infoRegisterEntity.getFirstEndAmount());
                entity.setSecondResultId(infoRegisterEntity.getFirstResultId());
                entity.setSecondResultName(infoRegisterEntity.getFirstResultName());
                entity.setSecondAppealDate(infoRegisterEntity.getFirstAppealDate());
                entity.setSecondLastDate(infoRegisterEntity.getFirstLastDate());
                entity.setSecondAmount(infoRegisterEntity.getAppealAmount());
                continue;
            }
            if (infoRegisterEntity.getHearCount() != 3) continue;
            entity.setThirdCourtId(infoRegisterEntity.getFirstCourtId());
            entity.setThirdCourtName(infoRegisterEntity.getFirstCourtName());
            entity.setThirdJudgeName(infoRegisterEntity.getFirstJudgeName());
            entity.setThirdJudgeCode(infoRegisterEntity.getFirstJudgeCode());
            entity.setThirdStartDate(infoRegisterEntity.getFirstStartDate());
            entity.setThirdCode(infoRegisterEntity.getFirstCode());
            entity.setThirdTypeId(infoRegisterEntity.getFirstTypeId());
            entity.setThirdTypeName(infoRegisterEntity.getFirstTypeName());
            entity.setThirdEndDate(infoRegisterEntity.getFirstEndDate());
            entity.setThirdEndAmount(infoRegisterEntity.getFirstEndAmount());
            entity.setThirdResultId(infoRegisterEntity.getFirstResultId());
            entity.setThirdResultName(infoRegisterEntity.getFirstResultName());
            entity.setThirdAppealDate(infoRegisterEntity.getFirstAppealDate());
            entity.setThirdAmount(infoRegisterEntity.getThirdAmount());
        }
        CaseRegisteVO vo = (CaseRegisteVO)BeanMapper.map((Object)((Object)entity), CaseRegisteVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CaseRegisteVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CaseRegisteVO caseRegisteVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CaseRegisteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        param.getOrderMap().put("hearCount", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CaseRegisteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CaseRegiste-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCaseRegisteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CaseRegisteVO>> refCaseRegisteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject con;
        String hearCount;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && StringUtils.isNotEmpty((CharSequence)(hearCount = (con = JSONObject.parseObject((String)condition)).getString("hearCount")))) {
            if (hearCount.equals("1")) {
                param.getParams().put("hearCount", new Parameter("eq", (Object)0));
            } else if (hearCount.equals("2")) {
                param.getParams().put("hearCount", new Parameter("eq", (Object)1));
            } else {
                param.getParams().put("hearCount", new Parameter("eq", (Object)2));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CaseRegisteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/DisputeTypeData"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray DisputeTypeData() {
        String str = "[{\"value\": \"1\", \"title\": \"\u4e70\u5356\u5408\u540c\u7ea0\u7eb7\", \"label\": \"\u4e70\u5356\u5408\u540c\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"2\", \"title\": \"\u79df\u8d41\u5408\u540c\u7ea0\u7eb7\", \"label\": \"\u79df\u8d41\u5408\u540c\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"3\", \"title\": \"\u5efa\u8bbe\u5de5\u7a0b\u5408\u540c\u7ea0\u7eb7\", \"label\": \"\u5efa\u8bbe\u5de5\u7a0b\u5408\u540c\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"4\", \"title\": \"\u52b3\u52a1\u7c7b\u7ea0\u7eb7\", \"label\": \"\u52b3\u52a1\u7c7b\u7ea0\u7eb7\", \"children\":[{\"value\": \"41\", \"title\": \"\u52b3\u52a1\u5408\u540c\u7ea0\u7eb7\", \"label\": \"\u52b3\u52a1\u5408\u540c\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"42\", \"title\": \"\u8ffd\u7d22\u52b3\u52a8\u62a5\u916c\u7ea0\u7eb7\", \"label\": \"\u8ffd\u7d22\u52b3\u52a8\u62a5\u916c\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"43\", \"title\": \"\u63d0\u4f9b\u52b3\u52a1\u8005\u53d7\u5bb3\u8d23\u4efb\u7ea0\u7eb7\", \"label\": \"\u63d0\u4f9b\u52b3\u52a1\u8005\u53d7\u5bb3\u8d23\u4efb\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"44\", \"title\": \"\u52b3\u52a8\u4e89\u8bae\uff08\u5458\u5de5\uff09\", \"label\": \"\u52b3\u52a8\u4e89\u8bae\uff08\u5458\u5de5\uff09\", \"children\":[]}]},{\"value\": \"5\", \"title\": \"\u6c11\u95f4\u501f\u8d37\u7ea0\u7eb7\", \"label\": \"\u6c11\u95f4\u501f\u8d37\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"6\", \"title\": \"\u627f\u63fd\u5408\u540c\u7ea0\u7eb7\", \"label\": \"\u627f\u63fd\u5408\u540c\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"7\", \"title\": \"\u5176\u4ed6\u7c7b\u7ea0\u7eb7\", \"label\": \"\u5176\u4ed6\u7c7b\u7ea0\u7eb7\", \"children\":[{\"value\": \"71\", \"title\": \"\u503a\u6743\u8f6c\u8ba9\u7ea0\u7eb7\", \"label\": \"\u503a\u6743\u8f6c\u8ba9\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"72\", \"title\": \"\u8ffd\u507f\u6743\u7ea0\u7eb7\", \"label\": \"\u8ffd\u507f\u6743\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"73\", \"title\": \"\u4e0d\u5f53\u5f97\u5229\u7ea0\u7eb7\", \"label\": \"\u4e0d\u5f53\u5f97\u5229\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"74\", \"title\": \"\u8fd4\u8fd8\u539f\u7269\u7ea0\u7eb7\", \"label\": \"\u8fd4\u8fd8\u539f\u7269\u7ea0\u7eb7\", \"children\":[]},{\"value\": \"75\", \"title\": \"\u884c\u653f\u8bc9\u8bbc\", \"label\": \"\u884c\u653f\u8bc9\u8bbc\", \"children\":[]}]}]";
        return JSONObject.parseArray((String)str);
    }

    private void ledgerSaveOrUpdate(CaseRegisteEntity entity) {
        LedgerEntity ledgerEntity = (LedgerEntity)((Object)this.ledgerService.getOne((Wrapper)Wrappers.lambdaQuery().eq(LedgerEntity::getCaseId, (Object)entity.getId())));
        if (ledgerEntity != null) {
            ledgerEntity.setCaseId(entity.getId());
            ledgerEntity.setCaseCode(entity.getCaseCode());
            ledgerEntity.setEndDate(entity.getCognizanceDate());
            ledgerEntity.setSueAmount(entity.getSueAmount());
            ledgerEntity.setDepartmentName(entity.getDepartmentName());
            ledgerEntity.setProjectName(entity.getProjectName());
            ledgerEntity.setDisputeType(entity.getDisputeType());
            ledgerEntity.setDisputeTypeName(entity.getDisputeTypeName());
            ledgerEntity.setCaseState(entity.getCaseState());
            ledgerEntity.setCaseStateName(entity.getCaseStateName());
            ledgerEntity.setPayState(entity.getPayState());
            ledgerEntity.setPayStateName(entity.getPayStateName());
            ledgerEntity.setPlaintiffId(entity.getPlaintiffMainId());
            ledgerEntity.setPlaintiffName(entity.getPlaintiffMainName());
            ledgerEntity.setOtherDefendantId(entity.getDefendantOtherId());
            ledgerEntity.setOtherDefendantName(entity.getDefendantOtherName());
            ledgerEntity.setThirdPartyId(entity.getDefendantMainId());
            ledgerEntity.setThirdPartyName(entity.getDefendantMainName());
            this.ledgerService.saveOrUpdate((Object)ledgerEntity);
        } else {
            LedgerEntity newEntity = new LedgerEntity();
            newEntity.setCaseId(entity.getId());
            newEntity.setCaseCode(entity.getCaseCode());
            newEntity.setEndDate(entity.getCognizanceDate());
            newEntity.setSueAmount(entity.getSueAmount());
            newEntity.setDepartmentName(entity.getDepartmentName());
            newEntity.setProjectName(entity.getProjectName());
            newEntity.setDisputeType(entity.getDisputeType());
            newEntity.setDisputeTypeName(entity.getDisputeTypeName());
            newEntity.setCaseState(entity.getCaseState());
            newEntity.setCaseStateName(entity.getCaseStateName());
            newEntity.setPayState(entity.getPayState());
            newEntity.setPayStateName(entity.getPayStateName());
            newEntity.setPlaintiffId(entity.getPlaintiffMainId());
            newEntity.setPlaintiffName(entity.getPlaintiffMainName());
            newEntity.setOtherDefendantId(entity.getDefendantOtherId());
            newEntity.setOtherDefendantName(entity.getDefendantOtherName());
            newEntity.setThirdPartyId(entity.getDefendantMainId());
            newEntity.setThirdPartyName(entity.getDefendantMainName());
            this.ledgerService.saveOrUpdate((Object)newEntity);
        }
    }
}

