/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.law.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.law.bean.CaseRegisteEntity;
import com.ejianc.business.law.bean.ProsecutionCaseRegisterEntity;
import com.ejianc.business.law.desktop.vo.CaseBaseVO;
import com.ejianc.business.law.desktop.vo.CaseCompareVO;
import com.ejianc.business.law.service.ICaseRegisteService;
import com.ejianc.business.law.service.IProsecutionCaseRegisterService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"deskTop"})
public class DeskTopController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICaseRegisteService caseRegisterService;
    @Autowired
    private IProsecutionCaseRegisterService prosecutionCaseRegisterService;

    @RequestMapping(value={"/queryBaseNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CaseBaseVO> queryBaseNum() {
        Date date = new Date();
        CaseBaseVO caseBaseVO = new CaseBaseVO();
        QueryWrapper caseWrapper = new QueryWrapper();
        caseWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        List registerEntities = this.caseRegisterService.list((Wrapper)caseWrapper);
        List progressCases = registerEntities.stream().filter(s -> s.getCaseStateName() != null && !"\u5df2\u7ed3\u6848".equals(s.getCaseStateName())).collect(Collectors.toList());
        List importantCases = progressCases.stream().filter(s -> "1".equals(s.getImportFlag())).collect(Collectors.toList());
        List thisYearAddCases = registerEntities.stream().filter(s -> s.getCognizanceDate() != null && s.getCognizanceDate().after(DateUtil.beginOfYear((Date)date)) && s.getCognizanceDate().before(DateUtil.endOfYear((Date)date))).collect(Collectors.toList());
        List thisYearEndCases = thisYearAddCases.stream().filter(s -> "\u5df2\u7ed3\u6848".equals(s.getCaseStateName())).collect(Collectors.toList());
        caseBaseVO.setProgressCases(Integer.valueOf(progressCases.size()));
        caseBaseVO.setImportantCases(Integer.valueOf(importantCases.size()));
        caseBaseVO.setThisYearAddCases(Integer.valueOf(thisYearAddCases.size()));
        caseBaseVO.setThisYearEndCases(Integer.valueOf(thisYearEndCases.size()));
        BigDecimal progressCasesMny = progressCases.stream().filter(s -> s.getSueAmount() != null).map(CaseRegisteEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal importantCasesMny = importantCases.stream().filter(s -> s.getSueAmount() != null).map(CaseRegisteEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearAddCasesMny = thisYearAddCases.stream().filter(s -> s.getSueAmount() != null).map(CaseRegisteEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearEndCasesMny = thisYearEndCases.stream().filter(s -> s.getSueAmount() != null).map(CaseRegisteEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        caseBaseVO.setProgressCasesMny(progressCasesMny);
        caseBaseVO.setImportantCasesMny(importantCasesMny);
        caseBaseVO.setThisYearAddCasesMny(thisYearAddCasesMny);
        caseBaseVO.setThisYearEndMny(thisYearEndCasesMny);
        QueryWrapper prosecutionCaseWrapper = new QueryWrapper();
        caseWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        List prosecutionCaseEntities = this.prosecutionCaseRegisterService.list((Wrapper)prosecutionCaseWrapper);
        List progressProsecutionCases = prosecutionCaseEntities.stream().filter(s -> s.getCaseStateName() != null && !"\u5df2\u7ed3\u6848".equals(s.getCaseStateName())).collect(Collectors.toList());
        List importantProsecutionCases = progressProsecutionCases.stream().filter(s -> "1".equals(s.getImportFlag())).collect(Collectors.toList());
        List thisYearAddProsecutionCases = prosecutionCaseEntities.stream().filter(s -> s.getCognizanceDate() != null && s.getCognizanceDate().after(DateUtil.beginOfYear((Date)date)) && s.getCognizanceDate().before(DateUtil.endOfYear((Date)date))).collect(Collectors.toList());
        List thisYearEndProsecutionCases = thisYearAddProsecutionCases.stream().filter(s -> "\u5df2\u7ed3\u6848".equals(s.getCaseStateName())).collect(Collectors.toList());
        caseBaseVO.setProProgressCases(Integer.valueOf(progressProsecutionCases.size()));
        caseBaseVO.setProImportantCases(Integer.valueOf(importantProsecutionCases.size()));
        caseBaseVO.setProThisYearAddCases(Integer.valueOf(thisYearAddProsecutionCases.size()));
        caseBaseVO.setProThisYearEndCases(Integer.valueOf(thisYearEndProsecutionCases.size()));
        BigDecimal proProgressCasesMny = progressProsecutionCases.stream().filter(s -> s.getSueAmount() != null).map(ProsecutionCaseRegisterEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proImportantCasesMny = importantProsecutionCases.stream().filter(s -> s.getSueAmount() != null).map(ProsecutionCaseRegisterEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearAddCasesMny = thisYearAddProsecutionCases.stream().filter(s -> s.getSueAmount() != null).map(ProsecutionCaseRegisterEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearEndCasesMny = thisYearEndProsecutionCases.stream().filter(s -> s.getSueAmount() != null).map(ProsecutionCaseRegisterEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        caseBaseVO.setProProgressCasesMny(proProgressCasesMny);
        caseBaseVO.setProImportantCasesMny(proImportantCasesMny);
        caseBaseVO.setProThisYearAddCasesMny(proThisYearAddCasesMny);
        caseBaseVO.setProThisYearEndMny(proThisYearEndCasesMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u6848\u4ef6\u7edf\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)caseBaseVO);
    }

    @RequestMapping(value={"/queryCaseTypeProportion"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> queryCaseTypeProportion(String type) {
        ArrayList caseTypeResult = new ArrayList();
        if ("case".equals(type)) {
            QueryWrapper caseWrapper = new QueryWrapper();
            caseWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
            caseWrapper.between((Object)"cognizance_date", (Object)(LocalDate.now().getYear() + "-1-1"), (Object)(LocalDate.now().getYear() + "-12-31"));
            List thisYearAddCases = this.caseRegisterService.list((Wrapper)caseWrapper);
            Map<String, List<CaseRegisteEntity>> caseTypeMap = thisYearAddCases.stream().collect(Collectors.groupingBy(s -> StringUtils.isNotBlank((CharSequence)s.getDisputeTypeName()) ? s.getDisputeTypeName() : "\u5176\u4ed6"));
            for (Map.Entry<String, List<CaseRegisteEntity>> caseTypeEntry : caseTypeMap.entrySet()) {
                List<CaseRegisteEntity> caseTypeList = caseTypeEntry.getValue();
                BigDecimal allMny = caseTypeList.stream().filter(s -> s.getSueAmount() != null).map(CaseRegisteEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("type", caseTypeEntry.getKey());
                map.put("value", allMny.toString());
                map.put("num", caseTypeList.size() + "");
                caseTypeResult.add(map);
            }
        } else {
            QueryWrapper proCaseWrapper = new QueryWrapper();
            proCaseWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
            proCaseWrapper.between((Object)"cognizance_date", (Object)(LocalDate.now().getYear() + "-1-1"), (Object)(LocalDate.now().getYear() + "-12-31"));
            List thisYearAddProCases = this.prosecutionCaseRegisterService.list((Wrapper)proCaseWrapper);
            Map<String, List<ProsecutionCaseRegisterEntity>> proCaseTypeMap = thisYearAddProCases.stream().collect(Collectors.groupingBy(s -> StringUtils.isNotBlank((CharSequence)s.getDisputeTypeName()) ? s.getDisputeTypeName() : "\u5176\u4ed6"));
            for (Map.Entry<String, List<ProsecutionCaseRegisterEntity>> proCaseTypeEntry : proCaseTypeMap.entrySet()) {
                List<ProsecutionCaseRegisterEntity> caseTypeList = proCaseTypeEntry.getValue();
                BigDecimal allMny = caseTypeList.stream().filter(s -> s.getSueAmount() != null).map(ProsecutionCaseRegisterEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("type", proCaseTypeEntry.getKey());
                map.put("value", allMny.toString());
                map.put("num", caseTypeList.size() + "");
                caseTypeResult.add(map);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6848\u4ef6\u7c7b\u578b\u5360\u6bd4\u6210\u529f\uff01", caseTypeResult);
    }

    @RequestMapping(value={"/queryCaseCompare"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CaseCompareVO> queryCaseCompare(String type) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        ArrayList<BigDecimal> caseMny = new ArrayList<BigDecimal>();
        ArrayList<Integer> caseNum = new ArrayList<Integer>();
        ArrayList<String> dateList = new ArrayList<String>();
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        for (int i = 3; i >= 0; --i) {
            BigDecimal totalMny = new BigDecimal(0.0);
            param.getParams().put("cognizanceDate", new Parameter("between", (Object)(LocalDate.now().getYear() - i + startMonth + (LocalDate.now().getYear() - i) + endMonth)));
            if ("case".equals(type)) {
                List caseEntities = this.caseRegisterService.queryList(param);
                this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u6570\u636e\u5171{}\u6761\u3002", (Object)(LocalDate.now().getYear() - i), (Object)caseEntities.size());
                param.getParams().remove("cognizanceDate");
                for (BaseEntity entity : caseEntities) {
                    if (entity.getSueAmount() == null) continue;
                    totalMny = totalMny.add(entity.getSueAmount());
                }
                caseMny.add(totalMny);
                this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u91d1\u989d:{}\u3002", (Object)(LocalDate.now().getYear() - i), (Object)totalMny);
                if (i != 3) {
                    dateList.add(LocalDate.now().getYear() - i + "");
                }
                caseNum.add(caseEntities.size());
                continue;
            }
            List proCaseEntities = this.prosecutionCaseRegisterService.queryList(param);
            this.logger.info("-----------{}\u5e74\u8d77\u8bc9\u6848\u4ef6\u6570\u636e\u5171{}\u6761\u3002", (Object)(LocalDate.now().getYear() - i), (Object)proCaseEntities.size());
            param.getParams().remove("cognizanceDate");
            for (BaseEntity entity : proCaseEntities) {
                if (entity.getSueAmount() == null) continue;
                totalMny = totalMny.add(entity.getSueAmount());
            }
            caseMny.add(totalMny);
            this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u91d1\u989d:{}\u3002", (Object)(LocalDate.now().getYear() - i), (Object)totalMny);
            if (i != 3) {
                dateList.add(LocalDate.now().getYear() - i + "");
            }
            caseNum.add(proCaseEntities.size());
        }
        CaseCompareVO caseCompareVO = new CaseCompareVO();
        caseCompareVO.setDateList(dateList);
        caseCompareVO.setCaseMny(caseMny);
        caseCompareVO.setCaseNum(caseNum);
        return CommonResponse.success((String)"\u67e5\u8be2\u8fd1\u4e09\u5e74\u6848\u4ef6\u4fe1\u606f\u6210\u529f\uff01", (Object)caseCompareVO);
    }
}

