package com.ejianc.business.law.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.law.bean.*;
import com.ejianc.business.law.desktop.vo.CaseBaseVO;
import com.ejianc.business.law.desktop.vo.CaseCompareVO;
import com.ejianc.business.law.service.*;
import com.ejianc.business.law.vo.DepartmentVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: jiang
 * @Date: 2023/9/11 11:03
 * @Description
 *      主题门户接口
 **/
@Controller
@RequestMapping("deskTop")
public class DeskTopController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICaseRegisteService caseRegisterService;

    @Autowired
    private IProsecutionCaseRegisterService prosecutionCaseRegisterService;

    @Autowired
    private IExecutiveRegisterService executiveService;

    @Autowired
    private IProsecutionExecutiveRegisterService proExecutiveService;

    @Autowired
    private IInfoRegisterService infoRegisterService;

    /**
     *
     * @Description queryBaseNum
     * 查询案件数量：
     *      通用：已提交、审批通过
     *      1.起诉案件：
     *          在办案件：案件状态为非已结案
     *          在办重大案件：重大案件标识
     *          本年新增案件：收案时间为今年
     *          本年结案案件：收案时间为今年、案件状态为非已结案
     *      2.应诉案件：同上
     *
     */
    @RequestMapping(value = "/queryBaseNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CaseBaseVO> queryBaseNum() {

        Date date = new Date();
        CaseBaseVO caseBaseVO = new CaseBaseVO();
        /**
         * 应诉案件
         */
        QueryWrapper<CaseRegisteEntity> caseWrapper = new QueryWrapper<>();
        caseWrapper.in("bill_state", Arrays.asList(1,3));
        List<CaseRegisteEntity> registerEntities = caseRegisterService.list(caseWrapper);
        //在办案件
        List<CaseRegisteEntity> progressCases = registerEntities.stream()
                .filter(s -> s.getCaseStateName() != null &&
                        !"已结案".equals(s.getCaseStateName()))
                .collect(Collectors.toList());
        //在办重大案件
        List<CaseRegisteEntity> importantCases = progressCases.stream().filter(s -> "1".equals(s.getImportFlag())).collect(Collectors.toList());
        //本年新增案件
        List<CaseRegisteEntity> thisYearAddCases = registerEntities.stream().filter(s ->
                s.getCognizanceDate() != null &&
                        s.getCognizanceDate().after(DateUtil.beginOfYear(date)) &&
                        s.getCognizanceDate().before(DateUtil.endOfYear(date))

        ).collect(Collectors.toList());
        //本年结案案件
        List<CaseRegisteEntity> thisYearEndCases = thisYearAddCases.stream().filter(s ->
                "已结案".equals(s.getCaseStateName())
        ).collect(Collectors.toList());

        caseBaseVO.setProgressCases(progressCases.size());
        caseBaseVO.setImportantCases(importantCases.size());
        caseBaseVO.setThisYearAddCases(thisYearAddCases.size());
        caseBaseVO.setThisYearEndCases(thisYearEndCases.size());

        BigDecimal progressCasesMny = progressCases.stream().filter(s -> s.getSueAmount() != null)
                .map(CaseRegisteEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal importantCasesMny = importantCases.stream().filter(s -> s.getSueAmount() != null)
                .map(CaseRegisteEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearAddCasesMny = thisYearAddCases.stream().filter(s -> s.getSueAmount() != null)
                .map(CaseRegisteEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearEndCasesMny = thisYearEndCases.stream().filter(s -> s.getSueAmount() != null)
                .map(CaseRegisteEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        caseBaseVO.setProgressCasesMny(progressCasesMny);
        caseBaseVO.setImportantCasesMny(importantCasesMny);
        caseBaseVO.setThisYearAddCasesMny(thisYearAddCasesMny);
        caseBaseVO.setThisYearEndMny(thisYearEndCasesMny);

        /**
         * 起诉案件
         */
        QueryWrapper<ProsecutionCaseRegisterEntity> prosecutionCaseWrapper = new QueryWrapper<>();
        prosecutionCaseWrapper.in("bill_state", Arrays.asList(1,3));
        List<ProsecutionCaseRegisterEntity> prosecutionCaseEntities = prosecutionCaseRegisterService.list(prosecutionCaseWrapper);
        //在办案件
        List<ProsecutionCaseRegisterEntity> progressProsecutionCases = prosecutionCaseEntities.stream()
                .filter(s -> s.getCaseStateName() != null &&
                        !"已结案".equals(s.getCaseStateName()))
                .collect(Collectors.toList());
        //在办重大案件
        List<ProsecutionCaseRegisterEntity> importantProsecutionCases = progressProsecutionCases.stream().filter(s -> "1".equals(s.getImportFlag())).collect(Collectors.toList());
        //本年新增案件
        List<ProsecutionCaseRegisterEntity> thisYearAddProsecutionCases = prosecutionCaseEntities.stream().filter(s ->
                s.getCognizanceDate() != null &&
                        s.getCognizanceDate().after(DateUtil.beginOfYear(date)) &&
                        s.getCognizanceDate().before(DateUtil.endOfYear(date))

        ).collect(Collectors.toList());
        //本年结案案件
        List<ProsecutionCaseRegisterEntity> thisYearEndProsecutionCases = thisYearAddProsecutionCases.stream().filter(s ->
                "已结案".equals(s.getCaseStateName())
        ).collect(Collectors.toList());

        caseBaseVO.setProProgressCases(progressProsecutionCases.size());
        caseBaseVO.setProImportantCases(importantProsecutionCases.size());
        caseBaseVO.setProThisYearAddCases(thisYearAddProsecutionCases.size());
        caseBaseVO.setProThisYearEndCases(thisYearEndProsecutionCases.size());

        BigDecimal proProgressCasesMny = progressProsecutionCases.stream().filter(s -> s.getSueAmount() != null)
                .map(ProsecutionCaseRegisterEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proImportantCasesMny = importantProsecutionCases.stream().filter(s -> s.getSueAmount() != null)
                .map(ProsecutionCaseRegisterEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearAddCasesMny = thisYearAddProsecutionCases.stream().filter(s -> s.getSueAmount() != null)
                .map(ProsecutionCaseRegisterEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearEndCasesMny = thisYearEndProsecutionCases.stream().filter(s -> s.getSueAmount() != null)
                .map(ProsecutionCaseRegisterEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        caseBaseVO.setProProgressCasesMny(proProgressCasesMny);
        caseBaseVO.setProImportantCasesMny(proImportantCasesMny);
        caseBaseVO.setProThisYearAddCasesMny(proThisYearAddCasesMny);
        caseBaseVO.setProThisYearEndMny(proThisYearEndCasesMny);




        return CommonResponse.success("查询案件统计数据成功！",caseBaseVO);

    }


    /**
     *

     * @Description queryCaseTypeProportion
     * 查询案件类型占比：
     *      1、已提交、审批通过
     *      2、收案日期为今年
     *
     */
    @RequestMapping(value = "/queryCaseTypeProportion", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String,String>>> queryCaseTypeProportion(String type){
        List<Map<String, String>> caseTypeResult = new ArrayList<>();

        if("case".equals(type)){
            /**
             *  应诉案件类型占比
             */
            QueryWrapper<CaseRegisteEntity> caseWrapper = new QueryWrapper<>();
            caseWrapper.in("bill_state", Arrays.asList(1,3));
            caseWrapper.between("cognizance_date", LocalDate.now().getYear()+"-1-1",LocalDate.now().getYear()+"-12-31");
            List<CaseRegisteEntity> thisYearAddCases = caseRegisterService.list(caseWrapper);

            Map<String, List<CaseRegisteEntity>> caseTypeMap = thisYearAddCases.stream()
                    .collect(Collectors.groupingBy(
                            s -> StringUtils.isNotBlank(s.getDisputeTypeName()) ? s.getDisputeTypeName() : "其他"));
            for (Map.Entry<String, List<CaseRegisteEntity>> caseTypeEntry : caseTypeMap.entrySet()) {
                List<CaseRegisteEntity> caseTypeList = caseTypeEntry.getValue();
                BigDecimal allMny = caseTypeList.stream().filter(s -> s.getSueAmount() != null)
                        .map(CaseRegisteEntity::getSueAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                Map<String, String> map = new HashMap<>();
                map.put("type",caseTypeEntry.getKey());
                map.put("value",allMny.toString());
                map.put("num",caseTypeList.size()+"");
                caseTypeResult.add(map);
            }
        } else {
            /**
             *  起诉案件类型占比
             */
            QueryWrapper<ProsecutionCaseRegisterEntity> proCaseWrapper = new QueryWrapper<>();
            proCaseWrapper.in("bill_state", Arrays.asList(1,3));
            proCaseWrapper.between("cognizance_date", LocalDate.now().getYear()+"-1-1",LocalDate.now().getYear()+"-12-31");
            List<ProsecutionCaseRegisterEntity> thisYearAddProCases = prosecutionCaseRegisterService.list(proCaseWrapper);

            Map<String, List<ProsecutionCaseRegisterEntity>> proCaseTypeMap = thisYearAddProCases.stream()
                    .collect(Collectors.groupingBy(
                            s -> StringUtils.isNotBlank(s.getDisputeTypeName()) ? s.getDisputeTypeName() : "其他"));
            for (Map.Entry<String, List<ProsecutionCaseRegisterEntity>> proCaseTypeEntry : proCaseTypeMap.entrySet()) {
                List<ProsecutionCaseRegisterEntity> caseTypeList = proCaseTypeEntry.getValue();
                BigDecimal allMny = caseTypeList.stream().filter(s -> s.getSueAmount() != null)
                        .map(ProsecutionCaseRegisterEntity::getSueAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                Map<String, String> map = new HashMap<>();
                map.put("type",proCaseTypeEntry.getKey());
                map.put("value",allMny.toString());
                map.put("num",caseTypeList.size()+"");
                caseTypeResult.add(map);
            }
        }
        return CommonResponse.success("查询案件类型占比成功！",caseTypeResult);
    }

    /**
     * 近3年案件对比
     *
     * @return
     */
    @RequestMapping(value = "/queryCaseCompare", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CaseCompareVO> queryCaseCompare(String type) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        /**
         * 获取近三年的案件金额、数量
         */
        List<BigDecimal> caseMny = new ArrayList<>();//案件金额
        List<Integer> caseNum = new ArrayList<>();//案件数量
        List<String> dateList = new ArrayList<>();//年份
        String startMonth = "-1-1,";
        String endMonth = "-12-31";


        for (int i = 3; i >= 0; i--) {
            BigDecimal totalMny = new BigDecimal(0.0);

            param.getParams().put("cognizanceDate", new Parameter(QueryParam.BETWEEN,
                    (LocalDate.now().getYear() - i) + startMonth + (LocalDate.now().getYear() - i) + endMonth));
            if("case".equals(type)){
                List<CaseRegisteEntity> caseEntities = caseRegisterService.queryList(param);
                logger.info("-----------{}年应诉案件数据共{}条。", LocalDate.now().getYear() - i,caseEntities.size());
                param.getParams().remove("cognizanceDate");
                for (CaseRegisteEntity entity : caseEntities) {
                    if(entity.getSueAmount() != null){
                        totalMny = totalMny.add(entity.getSueAmount());
                    }
                }
                caseMny.add(totalMny);
                logger.info("-----------{}年应诉案件金额:{}。", LocalDate.now().getYear() - i,totalMny);
                if (i != 3) {
                    dateList.add(LocalDate.now().getYear() - i + "");
                }
                caseNum.add(caseEntities.size());
            } else {
                List<ProsecutionCaseRegisterEntity> proCaseEntities = prosecutionCaseRegisterService.queryList(param);
                logger.info("-----------{}年起诉案件数据共{}条。", LocalDate.now().getYear() - i,proCaseEntities.size());
                param.getParams().remove("cognizanceDate");
                for (ProsecutionCaseRegisterEntity entity : proCaseEntities) {
                    if(entity.getSueAmount() != null){
                        totalMny = totalMny.add(entity.getSueAmount());
                    }
                }
                caseMny.add(totalMny);
                logger.info("-----------{}年应诉案件金额:{}。", LocalDate.now().getYear() - i,totalMny);
                if (i != 3) {
                    dateList.add(LocalDate.now().getYear() - i + "");
                }
                caseNum.add(proCaseEntities.size());
            }


        }
        CaseCompareVO caseCompareVO = new CaseCompareVO();
        caseCompareVO.setDateList(dateList);
        caseCompareVO.setCaseMny(caseMny);
        caseCompareVO.setCaseNum(caseNum);

        return CommonResponse.success("查询近三年案件信息成功！", caseCompareVO);
    }


    /**
     * @Description getCaseMnyRange
     *      应诉涉及金额区间对比
     */
    @RequestMapping(value = "/getCaseMnyRange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getCaseMnyRange() {

        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        param.getParams().put("cognizanceDate", new Parameter(QueryParam.BETWEEN,
                (LocalDate.now().getYear()) + startMonth + (LocalDate.now().getYear()) + endMonth));

        /**
         * 本年新增案件
         */
        List<CaseRegisteEntity> caseEntities = caseRegisterService.queryList(param);
        List<Map<String, String>> resultMapList = new ArrayList<>();

        List<CaseRegisteEntity> rangeList = new ArrayList<>();
        //0-10万
        rangeList = getListByRange(caseEntities, BigDecimal.ZERO, ONE_HUNDRED_THOUSAND);
        HashMap<String, String> map = new HashMap<>();
        map.put("name","0-10万");
        map.put("value",rangeList.size()+"");
        resultMapList.add(map);
        //10万-50万
        rangeList = getListByRange(caseEntities, ONE_HUNDRED_THOUSAND, FIVE_HUNDRED_THOUSAND);
        HashMap<String, String> map1 = new HashMap<>();
        map1.put("name","10万-50万");
        map1.put("value",rangeList.size()+"");
        resultMapList.add(map1);
        //50万-100万
        rangeList = getListByRange(caseEntities, FIVE_HUNDRED_THOUSAND, ONE_MILLION);
        HashMap<String, String> map2 = new HashMap<>();
        map2.put("name","50万-100万");
        map2.put("value",rangeList.size()+"");
        resultMapList.add(map2);
        //100万-500万
        rangeList = getListByRange(caseEntities, ONE_MILLION, FIVE_MILLION);
        HashMap<String, String> map3 = new HashMap<>();
        map3.put("name","100万-500万");
        map3.put("value",rangeList.size()+"");
        resultMapList.add(map3);
        //500万以上
        rangeList = getListByRange(caseEntities, FIVE_MILLION,null);
        HashMap<String, String> map4 = new HashMap<>();
        map4.put("name","500万以上");
        map4.put("value",rangeList.size()+"");
        resultMapList.add(map4);


        return CommonResponse.success("查询应诉案件金额范围对比数据成功！", resultMapList);
    }


    /**
     * 根据范围查询筛选金额
     *
     * @param list
     * @param start
     * @param end
     * @return
     */

    private static final BigDecimal ONE_HUNDRED_THOUSAND = new BigDecimal(10_0000);//十万
    private static final BigDecimal FIVE_HUNDRED_THOUSAND = new BigDecimal(50_0000);//五十万
    private static final BigDecimal ONE_MILLION = new BigDecimal(100_0000);//一百万
    private static final BigDecimal FIVE_MILLION = new BigDecimal(500_0000);//五百万
    private static final BigDecimal TEN_MILLION = new BigDecimal(1000_0000);//一千万
    private static final BigDecimal THIRTY_MILLION = new BigDecimal(3000_0000);//三千万


    private List<CaseRegisteEntity> getListByRange(List<CaseRegisteEntity> list, BigDecimal start, BigDecimal end) {
        if (start != null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(start) >= 0
                    && s.getSueAmount().compareTo(end) < 0)
                    .collect(Collectors.toList());
        }
        if (start == null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(end) < 0)
                    .collect(Collectors.toList());
        }
        if (start != null && end == null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(start) >= 0)
                    .collect(Collectors.toList());
        }
        return new ArrayList<CaseRegisteEntity>();
    }


    /**
     * @Description getCaseMnyRange
     *      起诉涉及金额区间对比
     */
    @RequestMapping(value = "/getProCaseMnyRange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getProCaseMnyRange() {

        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        param.getParams().put("cognizanceDate", new Parameter(QueryParam.BETWEEN,
                (LocalDate.now().getYear()) + startMonth + (LocalDate.now().getYear()) + endMonth));

        /**
         * 本年新增案件
         */
        List<ProsecutionCaseRegisterEntity> proCaseEntities = prosecutionCaseRegisterService.queryList(param);
        List<Map<String, String>> resultMapList = new ArrayList<>();

        List<ProsecutionCaseRegisterEntity> rangeList = new ArrayList<>();
        //0-100万
        rangeList = getProListByRange(proCaseEntities, BigDecimal.ZERO, ONE_MILLION);
        HashMap<String, String> map = new HashMap<>();
        map.put("name","0-100万");
        map.put("value",rangeList.size()+"");
        resultMapList.add(map);
        //100万-1000万
        rangeList = getProListByRange(proCaseEntities, ONE_MILLION, TEN_MILLION);
        HashMap<String, String> map1 = new HashMap<>();
        map1.put("name","100万-1000万");
        map1.put("value",rangeList.size()+"");
        resultMapList.add(map1);
        //1000万-3000万
        rangeList = getProListByRange(proCaseEntities, TEN_MILLION, THIRTY_MILLION);
        HashMap<String, String> map2 = new HashMap<>();
        map2.put("name","1000万-3000万");
        map2.put("value",rangeList.size()+"");
        resultMapList.add(map2);
        //3000万以上
        rangeList = getProListByRange(proCaseEntities, THIRTY_MILLION,null);
        HashMap<String, String> map3 = new HashMap<>();
        map3.put("name","3000万以上");
        map3.put("value",rangeList.size()+"");
        resultMapList.add(map3);


        return CommonResponse.success("查询起诉案件金额范围对比数据成功！", resultMapList);
    }


    /**
     * 根据范围查询筛选金额
     *
     * @param list
     * @param start
     * @param end
     * @return
     */

    private List<ProsecutionCaseRegisterEntity> getProListByRange(List<ProsecutionCaseRegisterEntity> list, BigDecimal start, BigDecimal end) {
        if (start != null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(start) >= 0
                    && s.getSueAmount().compareTo(end) < 0)
                    .collect(Collectors.toList());
        }
        if (start == null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(end) < 0)
                    .collect(Collectors.toList());
        }
        if (start != null && end == null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(start) >= 0)
                    .collect(Collectors.toList());
        }
        return new ArrayList<ProsecutionCaseRegisterEntity>();
    }

    /**
     * @Description queryExecutiveCase
     *      执行案件/被执行案件信息
     */
    @RequestMapping(value = "/queryExecutiveCase", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CaseBaseVO> queryExecutiveCase(QueryParam param) {

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        /** 执行立案日期 */
        param.getParams().put("executive_start_date", new Parameter(QueryParam.BETWEEN,
                (LocalDate.now().getYear()) + startMonth + (LocalDate.now().getYear()) + endMonth));

        /**
         * 应诉(被执行案件)
         */
        //本年新增
        List<ExecutiveRegisterEntity> thisYearAddCases = executiveService.queryList(param);
        //在办案件
        List<ExecutiveRegisterEntity> progressCases = thisYearAddCases.stream()
                .filter(s -> s.getExecutiveStateName() != null &&
                        "执行中".equals(s.getExecutiveStateName()))
                .collect(Collectors.toList());
        //本年结案案件
        List<ExecutiveRegisterEntity> thisYearEndCases = thisYearAddCases.stream()
                .filter(s -> s.getExecutiveStateName() != null &&
                        !"执行中".equals(s.getExecutiveStateName()))
                .collect(Collectors.toList());

        /**
         * 起诉(执行案件)
         */
        //本年新增
        List<ProsecutionExecutiveRegisterEntity> proThisYearAddCases = proExecutiveService.queryList(param);
        //在办案件
        List<ProsecutionExecutiveRegisterEntity> proProgressCases = proThisYearAddCases.stream()
                .filter(s -> s.getExecutiveStateName() != null &&
                        "执行中".equals(s.getExecutiveStateName()))
                .collect(Collectors.toList());
        //本年结案案件
        List<ProsecutionExecutiveRegisterEntity> proThisYearEndCases = proThisYearAddCases.stream()
                .filter(s -> s.getExecutiveStateName() != null &&
                        !"执行中".equals(s.getExecutiveStateName()))
                .collect(Collectors.toList());
        CaseBaseVO caseBaseVO = new CaseBaseVO();

        caseBaseVO.setProgressCases(progressCases.size());
        caseBaseVO.setThisYearAddCases(thisYearAddCases.size());
        caseBaseVO.setThisYearEndCases(thisYearEndCases.size());

        caseBaseVO.setProProgressCases(proThisYearAddCases.size());
        caseBaseVO.setProThisYearAddCases(proProgressCases.size());
        caseBaseVO.setProThisYearEndCases(proThisYearEndCases.size());

        return CommonResponse.success("查询执行案件信息成功！", caseBaseVO);
    }

    /**
     * @Description getInfoRank
     *      查询本年度法院应诉审理案件排名
     */
    @RequestMapping(value = "/getInfoRank", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getInfoRank() {


        List<Map<String, String>> infoRank = infoRegisterService.getInfoRank();

        return CommonResponse.success("查询应诉案件法院排名成功！", infoRank);
    }


}
