package com.ejianc.business.law.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ejianc.business.law.bean.*;

import com.ejianc.business.law.bidAreaVO.InfoAreaVO;
import com.ejianc.business.law.desktop.vo.CaseBaseVO;
import com.ejianc.business.law.desktop.vo.CaseCompareVO;
import com.ejianc.business.law.service.*;
import com.ejianc.business.law.utils.EJCDateUtil;
import com.ejianc.business.law.utils.TreeNodeBUtil;
import com.ejianc.business.law.vo.DepartmentVO;
import com.ejianc.business.law.vo.InfoRegisterVO;
import com.ejianc.business.law.vo.LawHistoryVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

import com.ejianc.business.law.bidAreaVO.AreaDataVO;

import static com.ejianc.business.law.utils.AddressResolutionUtil.*;
import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * @Author: jiang
 * @Date: 2023/9/11 11:03
 * @Description 主题门户接口
 **/
@Controller
@RequestMapping("deskTop")
public class DeskTopController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICaseRegisteService caseRegisterService;

    @Autowired
    private IProsecutionCaseRegisterService prosecutionCaseRegisterService;

    @Autowired
    private IExecutiveRegisterService executiveService;

    @Autowired
    private IProsecutionExecutiveRegisterService proExecutiveService;

    @Autowired
    private IInfoRegisterService infoRegisterService;

    @Autowired
    private ILawHistoryService lawHistoryService;

    /**
     * @Description queryBaseNum
     * 查询案件数量：
     * 通用：已提交、审批通过
     * 1.起诉案件：
     * 在办案件：案件状态为非已结案
     * 在办重大案件：重大案件标识
     * 本年新增案件：收案时间为今年
     * 本年结案案件：收案时间为今年、案件状态为非已结案
     * 2.应诉案件：同上
     */
    @RequestMapping(value = "/queryBaseNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CaseBaseVO> queryBaseNum() {

        Date date = new Date();
        CaseBaseVO caseBaseVO = new CaseBaseVO();
        /**
         * 应诉案件
         */
        QueryWrapper<CaseRegisteEntity> caseWrapper = new QueryWrapper<>();
        caseWrapper.in("bill_state", Arrays.asList(1, 3));
        List<CaseRegisteEntity> registerEntities = caseRegisterService.list(caseWrapper);
        //在办案件
        List<CaseRegisteEntity> progressCases = registerEntities.stream()
                .filter(s -> s.getCaseStateName() != null &&
                        !"已结案".equals(s.getCaseStateName()))
                .collect(Collectors.toList());
        //在办重大案件
        List<CaseRegisteEntity> importantCases = progressCases.stream().filter(s -> "1".equals(s.getImportFlag())).collect(Collectors.toList());
        //本年新增案件
        List<CaseRegisteEntity> thisYearAddCases = registerEntities.stream().filter(s ->
                s.getCognizanceDate() != null &&
                        s.getCognizanceDate().after(DateUtil.beginOfYear(date)) &&
                        s.getCognizanceDate().before(DateUtil.endOfYear(date))

        ).collect(Collectors.toList());
        //本年结案案件
        List<CaseRegisteEntity> thisYearEndCases = thisYearAddCases.stream().filter(s ->
                "已结案".equals(s.getCaseStateName())
        ).collect(Collectors.toList());

        caseBaseVO.setProgressCases(progressCases.size());
        caseBaseVO.setImportantCases(importantCases.size());
        caseBaseVO.setThisYearAddCases(thisYearAddCases.size());
        caseBaseVO.setThisYearEndCases(thisYearEndCases.size());

        BigDecimal progressCasesMny = progressCases.stream().filter(s -> s.getSueAmount() != null)
                .map(CaseRegisteEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal importantCasesMny = importantCases.stream().filter(s -> s.getSueAmount() != null)
                .map(CaseRegisteEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearAddCasesMny = thisYearAddCases.stream().filter(s -> s.getSueAmount() != null)
                .map(CaseRegisteEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearEndCasesMny = thisYearEndCases.stream().filter(s -> s.getSueAmount() != null)
                .map(CaseRegisteEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        caseBaseVO.setProgressCasesMny(progressCasesMny);
        caseBaseVO.setImportantCasesMny(importantCasesMny);
        caseBaseVO.setThisYearAddCasesMny(thisYearAddCasesMny);
        caseBaseVO.setThisYearEndMny(thisYearEndCasesMny);

        /**
         * 起诉案件
         */
        QueryWrapper<ProsecutionCaseRegisterEntity> prosecutionCaseWrapper = new QueryWrapper<>();
        prosecutionCaseWrapper.in("bill_state", Arrays.asList(1, 3));
        List<ProsecutionCaseRegisterEntity> prosecutionCaseEntities = prosecutionCaseRegisterService.list(prosecutionCaseWrapper);
        //在办案件
        List<ProsecutionCaseRegisterEntity> progressProsecutionCases = prosecutionCaseEntities.stream()
                .filter(s -> s.getCaseStateName() != null &&
                        !"已结案".equals(s.getCaseStateName()))
                .collect(Collectors.toList());
        //在办重大案件
        List<ProsecutionCaseRegisterEntity> importantProsecutionCases = progressProsecutionCases.stream().filter(s -> "1".equals(s.getImportFlag())).collect(Collectors.toList());
        //本年新增案件
        List<ProsecutionCaseRegisterEntity> thisYearAddProsecutionCases = prosecutionCaseEntities.stream().filter(s ->
                s.getCognizanceDate() != null &&
                        s.getCognizanceDate().after(DateUtil.beginOfYear(date)) &&
                        s.getCognizanceDate().before(DateUtil.endOfYear(date))

        ).collect(Collectors.toList());
        //本年结案案件
        List<ProsecutionCaseRegisterEntity> thisYearEndProsecutionCases = thisYearAddProsecutionCases.stream().filter(s ->
                "已结案".equals(s.getCaseStateName())
        ).collect(Collectors.toList());

        caseBaseVO.setProProgressCases(progressProsecutionCases.size());
        caseBaseVO.setProImportantCases(importantProsecutionCases.size());
        caseBaseVO.setProThisYearAddCases(thisYearAddProsecutionCases.size());
        caseBaseVO.setProThisYearEndCases(thisYearEndProsecutionCases.size());

        BigDecimal proProgressCasesMny = progressProsecutionCases.stream().filter(s -> s.getSueAmount() != null)
                .map(ProsecutionCaseRegisterEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proImportantCasesMny = importantProsecutionCases.stream().filter(s -> s.getSueAmount() != null)
                .map(ProsecutionCaseRegisterEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearAddCasesMny = thisYearAddProsecutionCases.stream().filter(s -> s.getSueAmount() != null)
                .map(ProsecutionCaseRegisterEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearEndCasesMny = thisYearEndProsecutionCases.stream().filter(s -> s.getSueAmount() != null)
                .map(ProsecutionCaseRegisterEntity::getSueAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        caseBaseVO.setProProgressCasesMny(proProgressCasesMny);
        caseBaseVO.setProImportantCasesMny(proImportantCasesMny);
        caseBaseVO.setProThisYearAddCasesMny(proThisYearAddCasesMny);
        caseBaseVO.setProThisYearEndMny(proThisYearEndCasesMny);


        return CommonResponse.success("查询案件统计数据成功！", caseBaseVO);

    }


    /**
     * @Description queryCaseTypeProportion
     * 查询案件类型占比：
     * 1、已提交、审批通过
     * 2、收案日期为今年
     */
    @RequestMapping(value = "/queryCaseTypeProportion", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> queryCaseTypeProportion(String type) {
        List<Map<String, String>> caseTypeResult = new ArrayList<>();

        if ("case".equals(type)) {
            /**
             *  应诉案件类型占比
             */
            QueryWrapper<CaseRegisteEntity> caseWrapper = new QueryWrapper<>();
            caseWrapper.in("bill_state", Arrays.asList(1, 3));
            caseWrapper.between("cognizance_date", LocalDate.now().getYear() + "-1-1", LocalDate.now().getYear() + "-12-31");
            List<CaseRegisteEntity> thisYearAddCases = caseRegisterService.list(caseWrapper);

            Map<String, List<CaseRegisteEntity>> caseTypeMap = thisYearAddCases.stream()
                    .collect(Collectors.groupingBy(
                            s -> StringUtils.isNotBlank(s.getDisputeTypeName()) ? s.getDisputeTypeName() : "其他"));
            for (Map.Entry<String, List<CaseRegisteEntity>> caseTypeEntry : caseTypeMap.entrySet()) {
                List<CaseRegisteEntity> caseTypeList = caseTypeEntry.getValue();
                BigDecimal allMny = caseTypeList.stream().filter(s -> s.getSueAmount() != null)
                        .map(CaseRegisteEntity::getSueAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                Map<String, String> map = new HashMap<>();
                map.put("type", caseTypeEntry.getKey());
                map.put("value", allMny.toString());
                map.put("num", caseTypeList.size() + "");
                caseTypeResult.add(map);
            }
        } else {
            /**
             *  起诉案件类型占比
             */
            QueryWrapper<ProsecutionCaseRegisterEntity> proCaseWrapper = new QueryWrapper<>();
            proCaseWrapper.in("bill_state", Arrays.asList(1, 3));
            proCaseWrapper.between("cognizance_date", LocalDate.now().getYear() + "-1-1", LocalDate.now().getYear() + "-12-31");
            List<ProsecutionCaseRegisterEntity> thisYearAddProCases = prosecutionCaseRegisterService.list(proCaseWrapper);

            Map<String, List<ProsecutionCaseRegisterEntity>> proCaseTypeMap = thisYearAddProCases.stream()
                    .collect(Collectors.groupingBy(
                            s -> StringUtils.isNotBlank(s.getDisputeTypeName()) ? s.getDisputeTypeName() : "其他"));
            for (Map.Entry<String, List<ProsecutionCaseRegisterEntity>> proCaseTypeEntry : proCaseTypeMap.entrySet()) {
                List<ProsecutionCaseRegisterEntity> caseTypeList = proCaseTypeEntry.getValue();
                BigDecimal allMny = caseTypeList.stream().filter(s -> s.getSueAmount() != null)
                        .map(ProsecutionCaseRegisterEntity::getSueAmount)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                Map<String, String> map = new HashMap<>();
                map.put("type", proCaseTypeEntry.getKey());
                map.put("value", allMny.toString());
                map.put("num", caseTypeList.size() + "");
                caseTypeResult.add(map);
            }
        }
        return CommonResponse.success("查询案件类型占比成功！", caseTypeResult);
    }

    /**
     * 近3年案件对比
     *
     * @return
     */
    @RequestMapping(value = "/queryCaseCompare", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CaseCompareVO> queryCaseCompare(String type) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));

        /**
         * 获取近三年的案件金额、数量
         */
        List<BigDecimal> caseMny = new ArrayList<>();//案件金额
        List<Integer> caseNum = new ArrayList<>();//案件数量
        List<String> dateList = new ArrayList<>();//年份
        String startMonth = "-1-1,";
        String endMonth = "-12-31";


        for (int i = 3; i >= 0; i--) {
            BigDecimal totalMny = new BigDecimal(0.0);

            param.getParams().put("cognizanceDate", new Parameter(QueryParam.BETWEEN,
                    (LocalDate.now().getYear() - i) + startMonth + (LocalDate.now().getYear() - i) + endMonth));
            if ("case".equals(type)) {
                List<CaseRegisteEntity> caseEntities = caseRegisterService.queryList(param);
                logger.info("-----------{}年应诉案件数据共{}条。", LocalDate.now().getYear() - i, caseEntities.size());
                param.getParams().remove("cognizanceDate");
                for (CaseRegisteEntity entity : caseEntities) {
                    if (entity.getSueAmount() != null) {
                        totalMny = totalMny.add(entity.getSueAmount());
                    }
                }
                caseMny.add(totalMny);
                logger.info("-----------{}年应诉案件金额:{}。", LocalDate.now().getYear() - i, totalMny);
                if (i != 3) {
                    dateList.add(LocalDate.now().getYear() - i + "");
                }
                caseNum.add(caseEntities.size());
            } else {
                List<ProsecutionCaseRegisterEntity> proCaseEntities = prosecutionCaseRegisterService.queryList(param);
                logger.info("-----------{}年起诉案件数据共{}条。", LocalDate.now().getYear() - i, proCaseEntities.size());
                param.getParams().remove("cognizanceDate");
                for (ProsecutionCaseRegisterEntity entity : proCaseEntities) {
                    if (entity.getSueAmount() != null) {
                        totalMny = totalMny.add(entity.getSueAmount());
                    }
                }
                caseMny.add(totalMny);
                logger.info("-----------{}年应诉案件金额:{}。", LocalDate.now().getYear() - i, totalMny);
                if (i != 3) {
                    dateList.add(LocalDate.now().getYear() - i + "");
                }
                caseNum.add(proCaseEntities.size());
            }


        }
        CaseCompareVO caseCompareVO = new CaseCompareVO();
        caseCompareVO.setDateList(dateList);
        caseCompareVO.setCaseMny(caseMny);
        caseCompareVO.setCaseNum(caseNum);

        return CommonResponse.success("查询近三年案件信息成功！", caseCompareVO);
    }


    /**
     * @Description getCaseMnyRange
     * 应诉涉及金额区间对比
     */
    @RequestMapping(value = "/getCaseMnyRange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getCaseMnyRange() {

        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));

        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        param.getParams().put("cognizanceDate", new Parameter(QueryParam.BETWEEN,
                (LocalDate.now().getYear()) + startMonth + (LocalDate.now().getYear()) + endMonth));

        /**
         * 本年新增案件
         */
        List<CaseRegisteEntity> caseEntities = caseRegisterService.queryList(param);
        List<Map<String, String>> resultMapList = new ArrayList<>();

        List<CaseRegisteEntity> rangeList = new ArrayList<>();
        //0-10万
        rangeList = getListByRange(caseEntities, BigDecimal.ZERO, ONE_HUNDRED_THOUSAND);
        HashMap<String, String> map = new HashMap<>();
        map.put("name", "0-10万");
        map.put("value", rangeList.size() + "");
        resultMapList.add(map);
        //10万-50万
        rangeList = getListByRange(caseEntities, ONE_HUNDRED_THOUSAND, FIVE_HUNDRED_THOUSAND);
        HashMap<String, String> map1 = new HashMap<>();
        map1.put("name", "10万-50万");
        map1.put("value", rangeList.size() + "");
        resultMapList.add(map1);
        //50万-100万
        rangeList = getListByRange(caseEntities, FIVE_HUNDRED_THOUSAND, ONE_MILLION);
        HashMap<String, String> map2 = new HashMap<>();
        map2.put("name", "50万-100万");
        map2.put("value", rangeList.size() + "");
        resultMapList.add(map2);
        //100万-500万
        rangeList = getListByRange(caseEntities, ONE_MILLION, FIVE_MILLION);
        HashMap<String, String> map3 = new HashMap<>();
        map3.put("name", "100万-500万");
        map3.put("value", rangeList.size() + "");
        resultMapList.add(map3);
        //500万以上
        rangeList = getListByRange(caseEntities, FIVE_MILLION, null);
        HashMap<String, String> map4 = new HashMap<>();
        map4.put("name", "500万以上");
        map4.put("value", rangeList.size() + "");
        resultMapList.add(map4);


        return CommonResponse.success("查询应诉案件金额范围对比数据成功！", resultMapList);
    }


    /**
     * 根据范围查询筛选金额
     *
     * @param list
     * @param start
     * @param end
     * @return
     */

    private static final BigDecimal ONE_HUNDRED_THOUSAND = new BigDecimal(10_0000);//十万
    private static final BigDecimal FIVE_HUNDRED_THOUSAND = new BigDecimal(50_0000);//五十万
    private static final BigDecimal ONE_MILLION = new BigDecimal(100_0000);//一百万
    private static final BigDecimal FIVE_MILLION = new BigDecimal(500_0000);//五百万
    private static final BigDecimal TEN_MILLION = new BigDecimal(1000_0000);//一千万
    private static final BigDecimal THIRTY_MILLION = new BigDecimal(3000_0000);//三千万


    private List<CaseRegisteEntity> getListByRange(List<CaseRegisteEntity> list, BigDecimal start, BigDecimal end) {
        if (start != null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(start) >= 0
                    && s.getSueAmount().compareTo(end) < 0)
                    .collect(Collectors.toList());
        }
        if (start == null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(end) < 0)
                    .collect(Collectors.toList());
        }
        if (start != null && end == null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(start) >= 0)
                    .collect(Collectors.toList());
        }
        return new ArrayList<CaseRegisteEntity>();
    }


    /**
     * @Description getCaseMnyRange
     * 起诉涉及金额区间对比
     */
    @RequestMapping(value = "/getProCaseMnyRange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getProCaseMnyRange() {

        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));

        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        param.getParams().put("cognizanceDate", new Parameter(QueryParam.BETWEEN,
                (LocalDate.now().getYear()) + startMonth + (LocalDate.now().getYear()) + endMonth));

        /**
         * 本年新增案件
         */
        List<ProsecutionCaseRegisterEntity> proCaseEntities = prosecutionCaseRegisterService.queryList(param);
        List<Map<String, String>> resultMapList = new ArrayList<>();

        List<ProsecutionCaseRegisterEntity> rangeList = new ArrayList<>();
        //0-100万
        rangeList = getProListByRange(proCaseEntities, BigDecimal.ZERO, ONE_MILLION);
        HashMap<String, String> map = new HashMap<>();
        map.put("name", "0-100万");
        map.put("value", rangeList.size() + "");
        resultMapList.add(map);
        //100万-1000万
        rangeList = getProListByRange(proCaseEntities, ONE_MILLION, TEN_MILLION);
        HashMap<String, String> map1 = new HashMap<>();
        map1.put("name", "100万-1000万");
        map1.put("value", rangeList.size() + "");
        resultMapList.add(map1);
        //1000万-3000万
        rangeList = getProListByRange(proCaseEntities, TEN_MILLION, THIRTY_MILLION);
        HashMap<String, String> map2 = new HashMap<>();
        map2.put("name", "1000万-3000万");
        map2.put("value", rangeList.size() + "");
        resultMapList.add(map2);
        //3000万以上
        rangeList = getProListByRange(proCaseEntities, THIRTY_MILLION, null);
        HashMap<String, String> map3 = new HashMap<>();
        map3.put("name", "3000万以上");
        map3.put("value", rangeList.size() + "");
        resultMapList.add(map3);


        return CommonResponse.success("查询起诉案件金额范围对比数据成功！", resultMapList);
    }


    /**
     * 根据范围查询筛选金额
     *
     * @param list
     * @param start
     * @param end
     * @return
     */

    private List<ProsecutionCaseRegisterEntity> getProListByRange(List<ProsecutionCaseRegisterEntity> list, BigDecimal start, BigDecimal end) {
        if (start != null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(start) >= 0
                    && s.getSueAmount().compareTo(end) < 0)
                    .collect(Collectors.toList());
        }
        if (start == null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(end) < 0)
                    .collect(Collectors.toList());
        }
        if (start != null && end == null) {
            return list.stream().filter(s -> s.getSueAmount() != null
                    && s.getSueAmount().compareTo(start) >= 0)
                    .collect(Collectors.toList());
        }
        return new ArrayList<ProsecutionCaseRegisterEntity>();
    }

    /**
     * @Description queryExecutiveCase
     * 执行案件/被执行案件信息
     */
    @RequestMapping(value = "/queryExecutiveCase", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CaseBaseVO> queryExecutiveCase(QueryParam param) {

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));

        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        /** 执行立案日期 */
        param.getParams().put("executive_start_date", new Parameter(QueryParam.BETWEEN,
                (LocalDate.now().getYear()) + startMonth + (LocalDate.now().getYear()) + endMonth));

        /**
         * 应诉(被执行案件)
         */
        //本年新增
        List<ExecutiveRegisterEntity> thisYearAddCases = executiveService.queryList(param);
        //在办案件
        List<ExecutiveRegisterEntity> progressCases = thisYearAddCases.stream()
                .filter(s -> s.getExecutiveStateName() != null &&
                        "执行中".equals(s.getExecutiveStateName()))
                .collect(Collectors.toList());
        //本年结案案件
        List<ExecutiveRegisterEntity> thisYearEndCases = thisYearAddCases.stream()
                .filter(s -> s.getExecutiveStateName() != null &&
                        !"执行中".equals(s.getExecutiveStateName()))
                .collect(Collectors.toList());
        BigDecimal progressCasesMny = progressCases.stream().filter(s -> s.getExecutiveAmount() != null)
                .map(ExecutiveRegisterEntity::getExecutiveAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearAddCasesMny = thisYearAddCases.stream().filter(s -> s.getExecutiveAmount() != null)
                .map(ExecutiveRegisterEntity::getExecutiveAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearEndCasesMny = thisYearEndCases.stream().filter(s -> s.getExecutiveAmount() != null)
                .map(ExecutiveRegisterEntity::getExecutiveAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        /**
         * 起诉(执行案件)
         */
        //本年新增
        List<ProsecutionExecutiveRegisterEntity> proThisYearAddCases = proExecutiveService.queryList(param);
        //在办案件
        List<ProsecutionExecutiveRegisterEntity> proProgressCases = proThisYearAddCases.stream()
                .filter(s -> s.getExecutiveStateName() != null &&
                        "执行中".equals(s.getExecutiveStateName()))
                .collect(Collectors.toList());
        //本年结案案件
        List<ProsecutionExecutiveRegisterEntity> proThisYearEndCases = proThisYearAddCases.stream()
                .filter(s -> s.getExecutiveStateName() != null &&
                        !"执行中".equals(s.getExecutiveStateName()))
                .collect(Collectors.toList());
        BigDecimal proProgressCasesMny = proProgressCases.stream().filter(s -> s.getExecutiveAmount() != null)
                .map(ProsecutionExecutiveRegisterEntity::getExecutiveAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearAddCasesMny = proThisYearAddCases.stream().filter(s -> s.getExecutiveAmount() != null)
                .map(ProsecutionExecutiveRegisterEntity::getExecutiveAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearEndCasesMny = proThisYearEndCases.stream().filter(s -> s.getExecutiveAmount() != null)
                .map(ProsecutionExecutiveRegisterEntity::getExecutiveAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);


        /**
         * 封装数据
         */
        CaseBaseVO caseBaseVO = new CaseBaseVO();

        //应诉
        caseBaseVO.setProgressCases(progressCases.size());
        caseBaseVO.setThisYearAddCases(thisYearAddCases.size());
        caseBaseVO.setThisYearEndCases(thisYearEndCases.size());
        caseBaseVO.setProgressCasesMny(progressCasesMny);
        caseBaseVO.setThisYearAddCasesMny(thisYearAddCasesMny);
        caseBaseVO.setThisYearEndMny(thisYearEndCasesMny);


        //起诉
        caseBaseVO.setProProgressCases(proThisYearAddCases.size());
        caseBaseVO.setProThisYearAddCases(proProgressCases.size());
        caseBaseVO.setProThisYearEndCases(proThisYearEndCases.size());
        caseBaseVO.setProProgressCasesMny(proProgressCasesMny);
        caseBaseVO.setProThisYearAddCasesMny(proThisYearAddCasesMny);
        caseBaseVO.setProThisYearEndMny(proThisYearEndCasesMny);

        return CommonResponse.success("查询执行案件信息成功！", caseBaseVO);
    }

    /**
     * @Description getInfoRank
     * 查询本年度法院应诉审理案件排名
     */
    @RequestMapping(value = "/getInfoRank", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getInfoRank() {


        List<Map<String, String>> infoRank = infoRegisterService.getInfoRank();

        return CommonResponse.success("查询应诉案件法院排名成功！", infoRank);
    }

    /**
     * 法务门户-应诉法院地图数据
     *
     * @param name
     * @param dateIn
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/getInfoArea", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getInfoArea(@RequestParam(value = "name", required = false) String name,
                                                  @RequestParam(value = "dateIn", required = false) String dateIn,
                                                  @RequestParam(value = "orgId", required = false) Long orgId) {
        return this.infoArea(name, dateIn, orgId);
    }

    public CommonResponse<JSONObject> infoArea(String name, String dateIn, Long orgId) {
        //今年
        dateIn = EJCDateUtil.getYear() + "";


        QueryWrapper<InfoRegisterEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(dateIn)) {
            queryWrapper.eq("DATE_FORMAT(first_start_date,\"%Y\")", dateIn);
        }
        queryWrapper.in("bill_state", Arrays.asList(1, 3));
        List<InfoRegisterEntity> list = infoRegisterService.list(queryWrapper);

        List<InfoAreaVO> infoAreaVOS = new ArrayList<>();
        if (ListUtil.isNotEmpty(list)) {
            List<InfoRegisterVO> infoRegisterVOS = BeanMapper.mapList(list, InfoRegisterVO.class);
            for (InfoRegisterVO infoRegisterVO : infoRegisterVOS) {
                InfoAreaVO infoAreaVO = new InfoAreaVO();
                infoAreaVO.setId(infoRegisterVO.getId());
                infoAreaVO.setOrgId(infoRegisterVO.getOrgId());
                infoAreaVO.setCourtName(infoRegisterVO.getFirstCourtName());
                if (StringUtils.isNotEmpty(infoRegisterVO.getAreaName())) {
                    String areaName = null;
                    areaName = infoRegisterVO.getAreaName().replace("/", "");
                    infoAreaVO.setAreaName(areaName);
                } else {
                    infoAreaVO.setAreaName(infoRegisterVO.getAreaName());
                }
                infoAreaVOS.add(infoAreaVO);
            }
        }
        List<Long> ids = new ArrayList<>();
        Set<String> provinceSet = new HashSet<>();
        Set<String> citySet = new HashSet<>();
        Set<String> countySet = new HashSet<>();
        String pname = null;
        for (InfoAreaVO vo : infoAreaVOS) {
            ids.add(vo.getId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(vo.getAreaName())) {
                if (vo.getAreaName().equals("台湾省")) {
                    vo.setProvince("台湾省");
                    vo.setCity("台湾省");
                    vo.setCounty("台湾省");

                    provinceSet.add("台湾省");
                    citySet.add("台湾省");
                    countySet.add("台湾省");
                } else {
                    Map<String, String> areaMap = addressResolution(vo.getAreaName());
                    if (areaMap != null) {
                        String province = areaMap.get("province") == null ? "其他" : areaMap.get("province");
                        String city = areaMap.get("city") == null ? "其他" : areaMap.get("city");
                        String county = areaMap.get("county") == null ? "其他" : areaMap.get("county");
                        vo.setProvince(province);
                        vo.setCity(city);
                        vo.setCounty(county);
                        provinceSet.add(province);
                        citySet.add(city);
                        countySet.add(county);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(name) && city.equals(name)) {
                            pname = province;
                        }
                    } else {
                        vo.setProvince("其他");
                        vo.setCity("其他");
                        vo.setCounty("其他");
                        provinceSet.add("其他");
                        citySet.add("其他");
                        countySet.add("其他");
                    }
                }
            } else {
                vo.setProvince("其他");
                vo.setCity("其他");
                vo.setCounty("其他");
                provinceSet.add("其他");
                citySet.add("其他");
                countySet.add("其他");
            }

        }

        String rangeType = null;
        List<AreaDataVO> dataVOS = new ArrayList<>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(name)) {
            if (provinceSet.contains(name)) {// 如果选择省
                rangeType = getProvincePinYin(name);
                dataVOS = projectCountByName(name, infoAreaVOS, 0);
            } else if (citySet.contains(name)) {
                rangeType = getProvincePinYin(pname) + "-" + getNamePinYinChar(name, 1);
                dataVOS = projectCountByName(name, infoAreaVOS, 1);
            }

        } else {
            if (provinceSet.size() == 1) {//同一省份
                if (citySet.size() == 1) {// 如果是同一市
                    rangeType = getProvincePinYin(provinceSet.iterator().next()) + "-" + getNamePinYinChar(citySet.iterator().next(), 1);
                    Map<String, AreaDataVO> countyMap = new HashMap<>();
                    for (InfoAreaVO vo : infoAreaVOS) {
                        String county = vo.getCounty();
                        if (!countyMap.containsKey(county)) {
                            AreaDataVO pvo = new AreaDataVO();
                            pvo.setName(county);
                            pvo.setValue(1);
                            countyMap.put(county, pvo);
                        } else {
                            AreaDataVO projectDataVO = countyMap.get(county);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            countyMap.put(county, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<AreaDataVO>(countyMap.values());
                    Map<String, List<InfoAreaVO>> map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
                    for (AreaDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<InfoAreaVO> projectCountVOS = map.get(dataVO.getName());
                            dataVO.setInfoAreaVOS(projectCountVOS);
                        }
                    }
                } else {
                    rangeType = getProvincePinYin(provinceSet.iterator().next());
                    Map<String, AreaDataVO> cityMap = new HashMap<>();
                    for (InfoAreaVO vo : infoAreaVOS) {
                        String city = vo.getCity();
                        if (!cityMap.containsKey(city)) {
                            AreaDataVO pvo = new AreaDataVO();
                            pvo.setName(city);
                            pvo.setValue(1);
                            cityMap.put(city, pvo);
                        } else {
                            AreaDataVO projectDataVO = cityMap.get(city);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            cityMap.put(city, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<AreaDataVO>(cityMap.values());
                    Map<String, List<InfoAreaVO>> map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity));
                    for (AreaDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<InfoAreaVO> projectCountVOS = map.get(dataVO.getName());
                            dataVO.setInfoAreaVOS(projectCountVOS);
                        }
                    }
                }

            } else {//不同省份
                rangeType = "China";
                Map<String, AreaDataVO> provinceMap = new HashMap<>();
                for (InfoAreaVO vo : infoAreaVOS) {
                    String province = vo.getProvince();
                    if (!provinceMap.containsKey(province)) {
                        AreaDataVO pvo = new AreaDataVO();
                        pvo.setName(province);
                        pvo.setValue(1);
                        provinceMap.put(province, pvo);
                    } else {
                        AreaDataVO projectDataVO = provinceMap.get(province);
                        projectDataVO.setValue(projectDataVO.getValue() + 1);
                        provinceMap.put(province, projectDataVO);
                    }
                }
                Map<String, List<InfoAreaVO>> map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getProvince));
                dataVOS = new ArrayList<AreaDataVO>(provinceMap.values());
                for (AreaDataVO dataVO : dataVOS) {
                    if (map.containsKey(dataVO.getName())) {
                        List<InfoAreaVO> projectCountVOS = map.get(dataVO.getName());
                        dataVO.setInfoAreaVOS(projectCountVOS);
                    }
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<AreaDataVO>() {
                @Override
                public int compare(AreaDataVO o1, AreaDataVO o2) {
                    int a = "其他".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "其他".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        //在这个地方处理四个直辖市
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        if (rangeType == null || rangeType.contains("null")) {
            rangeType = "China";
        }
        jsonObject.put("range", rangeType == null || rangeType.contains("null") ? "China" : rangeType);
        List<AreaDataVO> projectDataVOS = new ArrayList<>();
//        if (CollectionUtils.isNotEmpty(dataVOS)) {
//            Map<String, AreaDataVO> map = dataVOS.stream().collect(Collectors.toMap(k -> k.getName(), (k) -> k));
//            if (rangeType.equals("China")) {
//                //河南的省 省内
//                if (map.containsKey("河南省")) {
//                    List<InfoAreaVO> projectList = new ArrayList<>();
//                    AreaDataVO vo = map.get("河南省");
//                    if (vo != null) {
//                        projectList.addAll(vo.getInfoAreaVOS());
//                    }
//                    List<Long> areaInfoIds = projectList.stream().map(InfoAreaVO::getId).collect(Collectors.toList());
//
//                    AreaDataVO projectDataVO = new AreaDataVO();
//                    projectDataVO.setCurrentProvince("河南省");
//                    projectDataVO.setName("省内");
//                    projectDataVO.setValue(areaInfoIds.size());
//                    projectDataVOS.add(projectDataVO);
//                }
//
//                //河南省的 省外 排除其他的
//                List<Long> projectIds = new ArrayList<>();
//                for (AreaDataVO dataVO : dataVOS) {
//                    if (!"其他".equals(dataVO.getName()) && !"河南省".equals(dataVO.getName())) {
//                        List<Long> pids = dataVO.getInfoAreaVOS().stream().map(InfoAreaVO::getId).collect(Collectors.toList());
//                        projectIds.addAll(pids);
//                    }
//                }
//
//                AreaDataVO projectDataVO = new AreaDataVO();
//                projectDataVO.setName("省外");
//                projectDataVO.setValue(projectIds.size());
//                projectDataVOS.add(projectDataVO);
//                jsonObject.put("data", projectDataVOS);
//                return CommonResponse.success("查询数据成功！", jsonObject);
//            }
//        }
        jsonObject.put("data", dataVOS);
        return CommonResponse.success("查询数据成功！", jsonObject);
    }

    private List<AreaDataVO> projectCountByName(String name, List<InfoAreaVO> list, Integer type) {
        List<AreaDataVO> dataVOS = new ArrayList<>();
        Map<String, AreaDataVO> map = new HashMap<>();
        for (InfoAreaVO vo : list) {
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (voName.equals(name)) {
                if (!map.containsKey(childrenName)) {
                    AreaDataVO pvo = new AreaDataVO();
                    pvo.setName(childrenName);
                    pvo.setValue(1);
                    map.put(childrenName, pvo);
                } else {
                    AreaDataVO projectDataVO = map.get(childrenName);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    map.put(childrenName, projectDataVO);
                }
            }
        }
        Map<String, List<InfoAreaVO>> projectCountVOMap = null;
        if (type == 0) {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity));
        } else {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
        }
        ArrayList<AreaDataVO> projectDataVOS = new ArrayList<>(map.values());
        for (AreaDataVO dataVO : projectDataVOS) {
            if (map.containsKey(dataVO.getName())) {
                List<InfoAreaVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
                dataVO.setInfoAreaVOS(projectCountVOS);
            }
        }
        return projectDataVOS;

    }

    /**
     * @Description queryLawHistoryList
     *      案件历史信息合计
     * @param
     */
    @RequestMapping(value = "/queryLawHistoryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CaseCompareVO> queryLawHistoryList(@RequestBody QueryParam param) {

        List<BigDecimal> caseMny = new ArrayList<>();//案件金额
        List<Integer> caseNum = new ArrayList<>();//案件数量
        List<String> dateList = new ArrayList<>();//年份
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        for (int i = 4; i >= 0; i--) {
            param.getParams().put("year", new Parameter(QueryParam.EQ,
                    (LocalDate.now().getYear() - i)));
            QueryWrapper<LawHistoryEntity> queryWrapper = changeToQueryWrapper(param);
            List<LawHistoryEntity> lawHistoryEntities = lawHistoryService.list(queryWrapper);
            if(ListUtil.isNotEmpty(lawHistoryEntities)){
                caseMny.add(lawHistoryEntities.get(0).getMny());
                caseNum.add(lawHistoryEntities.get(0).getNum());

                if (i != 4) {
                    dateList.add(LocalDate.now().getYear() - i + "");
                }
            }


        }
        CaseCompareVO caseCompareVO = new CaseCompareVO();
        caseCompareVO.setDateList(dateList);
        caseCompareVO.setCaseMny(caseMny);
        caseCompareVO.setCaseNum(caseNum);

        return CommonResponse.success("查询案件历史信息合计数据成功！",caseCompareVO);

    }

}
