/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.law.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.law.bean.CaseRegisteEntity;
import com.ejianc.business.law.bean.ExecutiveRegisterEntity;
import com.ejianc.business.law.bean.InnerCaseEntity;
import com.ejianc.business.law.bean.LawHistoryEntity;
import com.ejianc.business.law.bean.ProsecutionCaseRegisterEntity;
import com.ejianc.business.law.bean.ProsecutionExecutiveRegisterEntity;
import com.ejianc.business.law.bidAreaVO.AreaDataVO;
import com.ejianc.business.law.bidAreaVO.InfoAreaVO;
import com.ejianc.business.law.desktop.vo.CaseBaseVO;
import com.ejianc.business.law.desktop.vo.CaseCompareVO;
import com.ejianc.business.law.desktop.vo.DepartmentRankVO;
import com.ejianc.business.law.mapper.InfoRegisterMapper;
import com.ejianc.business.law.service.ICaseRegisteService;
import com.ejianc.business.law.service.IDepartmentService;
import com.ejianc.business.law.service.IExecutiveRegisterService;
import com.ejianc.business.law.service.IInfoRegisterService;
import com.ejianc.business.law.service.IInnerCaseService;
import com.ejianc.business.law.service.ILawHistoryService;
import com.ejianc.business.law.service.IProsecutionCaseRegisterService;
import com.ejianc.business.law.service.IProsecutionDepartmentService;
import com.ejianc.business.law.service.IProsecutionExecutiveRegisterService;
import com.ejianc.business.law.utils.AddressResolutionUtil;
import com.ejianc.business.law.utils.EJCDateUtil;
import com.ejianc.business.law.vo.InfoRegisterVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"deskTop"})
public class DeskTopController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICaseRegisteService caseRegisterService;
    @Autowired
    private IProsecutionCaseRegisterService prosecutionCaseRegisterService;
    @Autowired
    private IExecutiveRegisterService executiveService;
    @Autowired
    private IProsecutionExecutiveRegisterService proExecutiveService;
    @Autowired
    private IInfoRegisterService infoRegisterService;
    @Autowired
    private ILawHistoryService lawHistoryService;
    @Autowired
    private IDepartmentService departmentService;
    @Autowired
    private IProsecutionDepartmentService proDepartmentService;
    @Autowired
    private InfoRegisterMapper registerMapper;
    @Autowired
    private IInnerCaseService innerCaseService;
    private static final BigDecimal ONE_HUNDRED_THOUSAND = new BigDecimal(100000);
    private static final BigDecimal FIVE_HUNDRED_THOUSAND = new BigDecimal(500000);
    private static final BigDecimal ONE_MILLION = new BigDecimal(1000000);
    private static final BigDecimal FIVE_MILLION = new BigDecimal(5000000);
    private static final BigDecimal TEN_MILLION = new BigDecimal(10000000);
    private static final BigDecimal THIRTY_MILLION = new BigDecimal(30000000);

    @RequestMapping(value={"/queryBaseNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CaseBaseVO> queryBaseNum() {
        Date date = new Date();
        CaseBaseVO caseBaseVO = new CaseBaseVO();
        QueryWrapper caseWrapper = new QueryWrapper();
        caseWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        List registerEntities = this.caseRegisterService.list((Wrapper)caseWrapper);
        List progressCases = registerEntities.stream().filter(s -> s.getCaseStateName() != null && !"\u5df2\u7ed3\u6848".equals(s.getCaseStateName())).collect(Collectors.toList());
        List importantCases = progressCases.stream().filter(s -> "1".equals(s.getImportFlag())).collect(Collectors.toList());
        List thisYearAddCases = registerEntities.stream().filter(s -> s.getCognizanceDate() != null && s.getCognizanceDate().after(DateUtil.beginOfYear((Date)date)) && s.getCognizanceDate().before(DateUtil.endOfYear((Date)date))).collect(Collectors.toList());
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(5, -7);
        List sevenDaysAddCases = registerEntities.stream().filter(s -> s.getCognizanceDate() != null && s.getCognizanceDate().after(DateUtil.subDays((Date)date, (int)8)) && s.getCognizanceDate().before(date)).collect(Collectors.toList());
        List thisYearEndCases = thisYearAddCases.stream().filter(s -> "\u5df2\u7ed3\u6848".equals(s.getCaseStateName())).collect(Collectors.toList());
        caseBaseVO.setProgressCases(Integer.valueOf(progressCases.size()));
        caseBaseVO.setImportantCases(Integer.valueOf(importantCases.size()));
        caseBaseVO.setThisYearAddCases(Integer.valueOf(thisYearAddCases.size()));
        caseBaseVO.setThisYearEndCases(Integer.valueOf(thisYearEndCases.size()));
        caseBaseVO.setSevenDaysAddCases(Integer.valueOf(sevenDaysAddCases.size()));
        BigDecimal progressCasesMny = progressCases.stream().filter(s -> s.getSueAmount() != null).map(CaseRegisteEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal importantCasesMny = importantCases.stream().filter(s -> s.getSueAmount() != null).map(CaseRegisteEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearAddCasesMny = thisYearAddCases.stream().filter(s -> s.getSueAmount() != null).map(CaseRegisteEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearEndCasesMny = thisYearEndCases.stream().filter(s -> s.getSueAmount() != null).map(CaseRegisteEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        caseBaseVO.setProgressCasesMny(progressCasesMny);
        caseBaseVO.setImportantCasesMny(importantCasesMny);
        caseBaseVO.setThisYearAddCasesMny(thisYearAddCasesMny);
        caseBaseVO.setThisYearEndMny(thisYearEndCasesMny);
        QueryWrapper prosecutionCaseWrapper = new QueryWrapper();
        prosecutionCaseWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        List prosecutionCaseEntities = this.prosecutionCaseRegisterService.list((Wrapper)prosecutionCaseWrapper);
        List progressProsecutionCases = prosecutionCaseEntities.stream().filter(s -> s.getCaseStateName() != null && !"\u5df2\u7ed3\u6848".equals(s.getCaseStateName())).collect(Collectors.toList());
        List importantProsecutionCases = progressProsecutionCases.stream().filter(s -> "1".equals(s.getImportFlag())).collect(Collectors.toList());
        List thisYearAddProsecutionCases = prosecutionCaseEntities.stream().filter(s -> s.getCognizanceDate() != null && s.getCognizanceDate().after(DateUtil.beginOfYear((Date)date)) && s.getCognizanceDate().before(DateUtil.endOfYear((Date)date))).collect(Collectors.toList());
        List proSevenDaysAddCases = prosecutionCaseEntities.stream().filter(s -> s.getCognizanceDate() != null && s.getCognizanceDate().after(DateUtil.subDays((Date)date, (int)8)) && s.getCognizanceDate().before(date)).collect(Collectors.toList());
        List thisYearEndProsecutionCases = thisYearAddProsecutionCases.stream().filter(s -> "\u5df2\u7ed3\u6848".equals(s.getCaseStateName())).collect(Collectors.toList());
        caseBaseVO.setProProgressCases(Integer.valueOf(progressProsecutionCases.size()));
        caseBaseVO.setProImportantCases(Integer.valueOf(importantProsecutionCases.size()));
        caseBaseVO.setProThisYearAddCases(Integer.valueOf(thisYearAddProsecutionCases.size()));
        caseBaseVO.setProThisYearEndCases(Integer.valueOf(thisYearEndProsecutionCases.size()));
        caseBaseVO.setProSevenDaysAddCases(Integer.valueOf(proSevenDaysAddCases.size()));
        BigDecimal proProgressCasesMny = progressProsecutionCases.stream().filter(s -> s.getSueAmount() != null).map(ProsecutionCaseRegisterEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proImportantCasesMny = importantProsecutionCases.stream().filter(s -> s.getSueAmount() != null).map(ProsecutionCaseRegisterEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearAddCasesMny = thisYearAddProsecutionCases.stream().filter(s -> s.getSueAmount() != null).map(ProsecutionCaseRegisterEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearEndCasesMny = thisYearEndProsecutionCases.stream().filter(s -> s.getSueAmount() != null).map(ProsecutionCaseRegisterEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        caseBaseVO.setProProgressCasesMny(proProgressCasesMny);
        caseBaseVO.setProImportantCasesMny(proImportantCasesMny);
        caseBaseVO.setProThisYearAddCasesMny(proThisYearAddCasesMny);
        caseBaseVO.setProThisYearEndMny(proThisYearEndCasesMny);
        return CommonResponse.success((String)"\u67e5\u8be2\u6848\u4ef6\u7edf\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)caseBaseVO);
    }

    @RequestMapping(value={"/queryCaseTypeProportion"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> queryCaseTypeProportion(String type) {
        ArrayList caseTypeResult = new ArrayList();
        if ("case".equals(type)) {
            QueryWrapper caseWrapper = new QueryWrapper();
            caseWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
            caseWrapper.between((Object)"cognizance_date", (Object)(LocalDate.now().getYear() + "-1-1"), (Object)(LocalDate.now().getYear() + "-12-31"));
            List thisYearAddCases = this.caseRegisterService.list((Wrapper)caseWrapper);
            Map<String, List<CaseRegisteEntity>> caseTypeMap = thisYearAddCases.stream().collect(Collectors.groupingBy(s -> StringUtils.isNotBlank((CharSequence)s.getDisputeTypeName()) ? s.getDisputeTypeName() : "\u5176\u4ed6"));
            for (Map.Entry<String, List<CaseRegisteEntity>> caseTypeEntry : caseTypeMap.entrySet()) {
                List<CaseRegisteEntity> caseTypeList = caseTypeEntry.getValue();
                BigDecimal allMny = caseTypeList.stream().filter(s -> s.getSueAmount() != null).map(CaseRegisteEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("type", caseTypeEntry.getKey());
                map.put("value", allMny.toString());
                map.put("num", caseTypeList.size() + "");
                caseTypeResult.add(map);
            }
        } else {
            QueryWrapper proCaseWrapper = new QueryWrapper();
            proCaseWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
            proCaseWrapper.between((Object)"cognizance_date", (Object)(LocalDate.now().getYear() + "-1-1"), (Object)(LocalDate.now().getYear() + "-12-31"));
            List thisYearAddProCases = this.prosecutionCaseRegisterService.list((Wrapper)proCaseWrapper);
            Map<String, List<ProsecutionCaseRegisterEntity>> proCaseTypeMap = thisYearAddProCases.stream().collect(Collectors.groupingBy(s -> StringUtils.isNotBlank((CharSequence)s.getDisputeTypeName()) ? s.getDisputeTypeName() : "\u5176\u4ed6"));
            for (Map.Entry<String, List<ProsecutionCaseRegisterEntity>> proCaseTypeEntry : proCaseTypeMap.entrySet()) {
                List<ProsecutionCaseRegisterEntity> caseTypeList = proCaseTypeEntry.getValue();
                BigDecimal allMny = caseTypeList.stream().filter(s -> s.getSueAmount() != null).map(ProsecutionCaseRegisterEntity::getSueAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("type", proCaseTypeEntry.getKey());
                map.put("value", allMny.toString());
                map.put("num", caseTypeList.size() + "");
                caseTypeResult.add(map);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6848\u4ef6\u7c7b\u578b\u5360\u6bd4\u6210\u529f\uff01", caseTypeResult);
    }

    @RequestMapping(value={"/queryCaseCompare"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CaseCompareVO> queryCaseCompare(String type) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        ArrayList<BigDecimal> caseMny = new ArrayList<BigDecimal>();
        ArrayList<Integer> caseNum = new ArrayList<Integer>();
        ArrayList<String> dateList = new ArrayList<String>();
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        for (int i = 3; i >= 0; --i) {
            BigDecimal totalMny = new BigDecimal(0.0);
            param.getParams().put("cognizanceDate", new Parameter("between", (Object)(LocalDate.now().getYear() - i + startMonth + (LocalDate.now().getYear() - i) + endMonth)));
            if ("case".equals(type)) {
                List caseEntities = this.caseRegisterService.queryList(param);
                this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u6570\u636e\u5171{}\u6761\u3002", (Object)(LocalDate.now().getYear() - i), (Object)caseEntities.size());
                param.getParams().remove("cognizanceDate");
                for (BaseEntity entity : caseEntities) {
                    if (entity.getSueAmount() == null) continue;
                    totalMny = totalMny.add(entity.getSueAmount());
                }
                caseMny.add(totalMny);
                this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u91d1\u989d:{}\u3002", (Object)(LocalDate.now().getYear() - i), (Object)totalMny);
                if (i != 3) {
                    dateList.add(LocalDate.now().getYear() - i + "");
                }
                caseNum.add(caseEntities.size());
                continue;
            }
            List proCaseEntities = this.prosecutionCaseRegisterService.queryList(param);
            this.logger.info("-----------{}\u5e74\u8d77\u8bc9\u6848\u4ef6\u6570\u636e\u5171{}\u6761\u3002", (Object)(LocalDate.now().getYear() - i), (Object)proCaseEntities.size());
            param.getParams().remove("cognizanceDate");
            for (BaseEntity entity : proCaseEntities) {
                if (entity.getSueAmount() == null) continue;
                totalMny = totalMny.add(entity.getSueAmount());
            }
            caseMny.add(totalMny);
            this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u91d1\u989d:{}\u3002", (Object)(LocalDate.now().getYear() - i), (Object)totalMny);
            if (i != 3) {
                dateList.add(LocalDate.now().getYear() - i + "");
            }
            caseNum.add(proCaseEntities.size());
        }
        CaseCompareVO caseCompareVO = new CaseCompareVO();
        caseCompareVO.setDateList(dateList);
        caseCompareVO.setCaseMny(caseMny);
        caseCompareVO.setCaseNum(caseNum);
        return CommonResponse.success((String)"\u67e5\u8be2\u8fd1\u4e09\u5e74\u6848\u4ef6\u4fe1\u606f\u6210\u529f\uff01", (Object)caseCompareVO);
    }

    @RequestMapping(value={"/getCaseMnyRange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getCaseMnyRange() {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        param.getParams().put("cognizanceDate", new Parameter("between", (Object)(LocalDate.now().getYear() + startMonth + LocalDate.now().getYear() + endMonth)));
        List caseEntities = this.caseRegisterService.queryList(param);
        ArrayList resultMapList = new ArrayList();
        List<Object> rangeList = new ArrayList();
        rangeList = this.getListByRange(caseEntities, BigDecimal.ZERO, ONE_HUNDRED_THOUSAND);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "0-10\u4e07");
        map.put("value", rangeList.size() + "");
        resultMapList.add(map);
        rangeList = this.getListByRange(caseEntities, ONE_HUNDRED_THOUSAND, FIVE_HUNDRED_THOUSAND);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("name", "10\u4e07-50\u4e07");
        map1.put("value", rangeList.size() + "");
        resultMapList.add(map1);
        rangeList = this.getListByRange(caseEntities, FIVE_HUNDRED_THOUSAND, ONE_MILLION);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("name", "50\u4e07-100\u4e07");
        map2.put("value", rangeList.size() + "");
        resultMapList.add(map2);
        rangeList = this.getListByRange(caseEntities, ONE_MILLION, FIVE_MILLION);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("name", "100\u4e07-500\u4e07");
        map3.put("value", rangeList.size() + "");
        resultMapList.add(map3);
        rangeList = this.getListByRange(caseEntities, FIVE_MILLION, null);
        HashMap<String, String> map4 = new HashMap<String, String>();
        map4.put("name", "500\u4e07\u4ee5\u4e0a");
        map4.put("value", rangeList.size() + "");
        resultMapList.add(map4);
        return CommonResponse.success((String)"\u67e5\u8be2\u5e94\u8bc9\u6848\u4ef6\u91d1\u989d\u8303\u56f4\u5bf9\u6bd4\u6570\u636e\u6210\u529f\uff01", resultMapList);
    }

    private List<CaseRegisteEntity> getListByRange(List<CaseRegisteEntity> list, BigDecimal start, BigDecimal end) {
        if (start != null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null && s.getSueAmount().compareTo(start) >= 0 && s.getSueAmount().compareTo(end) < 0).collect(Collectors.toList());
        }
        if (start == null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null && s.getSueAmount().compareTo(end) < 0).collect(Collectors.toList());
        }
        if (start != null && end == null) {
            return list.stream().filter(s -> s.getSueAmount() != null && s.getSueAmount().compareTo(start) >= 0).collect(Collectors.toList());
        }
        return new ArrayList<CaseRegisteEntity>();
    }

    @RequestMapping(value={"/getProCaseMnyRange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getProCaseMnyRange() {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        param.getParams().put("cognizanceDate", new Parameter("between", (Object)(LocalDate.now().getYear() + startMonth + LocalDate.now().getYear() + endMonth)));
        List proCaseEntities = this.prosecutionCaseRegisterService.queryList(param);
        ArrayList resultMapList = new ArrayList();
        List<Object> rangeList = new ArrayList();
        rangeList = this.getProListByRange(proCaseEntities, BigDecimal.ZERO, ONE_MILLION);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "0-100\u4e07");
        map.put("value", rangeList.size() + "");
        resultMapList.add(map);
        rangeList = this.getProListByRange(proCaseEntities, ONE_MILLION, TEN_MILLION);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("name", "100\u4e07-1000\u4e07");
        map1.put("value", rangeList.size() + "");
        resultMapList.add(map1);
        rangeList = this.getProListByRange(proCaseEntities, TEN_MILLION, THIRTY_MILLION);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("name", "1000\u4e07-3000\u4e07");
        map2.put("value", rangeList.size() + "");
        resultMapList.add(map2);
        rangeList = this.getProListByRange(proCaseEntities, THIRTY_MILLION, null);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("name", "3000\u4e07\u4ee5\u4e0a");
        map3.put("value", rangeList.size() + "");
        resultMapList.add(map3);
        return CommonResponse.success((String)"\u67e5\u8be2\u8d77\u8bc9\u6848\u4ef6\u91d1\u989d\u8303\u56f4\u5bf9\u6bd4\u6570\u636e\u6210\u529f\uff01", resultMapList);
    }

    private List<ProsecutionCaseRegisterEntity> getProListByRange(List<ProsecutionCaseRegisterEntity> list, BigDecimal start, BigDecimal end) {
        if (start != null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null && s.getSueAmount().compareTo(start) >= 0 && s.getSueAmount().compareTo(end) < 0).collect(Collectors.toList());
        }
        if (start == null && end != null) {
            return list.stream().filter(s -> s.getSueAmount() != null && s.getSueAmount().compareTo(end) < 0).collect(Collectors.toList());
        }
        if (start != null && end == null) {
            return list.stream().filter(s -> s.getSueAmount() != null && s.getSueAmount().compareTo(start) >= 0).collect(Collectors.toList());
        }
        return new ArrayList<ProsecutionCaseRegisterEntity>();
    }

    @RequestMapping(value={"/queryExecutiveCase"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CaseBaseVO> queryExecutiveCase(QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        param.getParams().put("executive_start_date", new Parameter("between", (Object)(LocalDate.now().getYear() + startMonth + LocalDate.now().getYear() + endMonth)));
        List thisYearAddCases = this.executiveService.queryList(param);
        List progressCases = thisYearAddCases.stream().filter(s -> s.getExecutiveStateName() != null && "\u6267\u884c\u4e2d".equals(s.getExecutiveStateName())).collect(Collectors.toList());
        List thisYearEndCases = thisYearAddCases.stream().filter(s -> s.getExecutiveStateName() != null && !"\u6267\u884c\u4e2d".equals(s.getExecutiveStateName())).collect(Collectors.toList());
        BigDecimal progressCasesMny = progressCases.stream().filter(s -> s.getExecutiveAmount() != null).map(ExecutiveRegisterEntity::getExecutiveAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearAddCasesMny = thisYearAddCases.stream().filter(s -> s.getExecutiveAmount() != null).map(ExecutiveRegisterEntity::getExecutiveAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearEndCasesMny = thisYearEndCases.stream().filter(s -> s.getExecutiveAmount() != null).map(ExecutiveRegisterEntity::getExecutiveAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        List proThisYearAddCases = this.proExecutiveService.queryList(param);
        QueryParam deepCopyParam = (QueryParam)Utils.deepCopy((Object)param);
        deepCopyParam.getParams().remove("executive_start_date");
        deepCopyParam.getParams().put("executiveStateName", new Parameter("eq", (Object)"\u6267\u884c\u4e2d"));
        List proProgressCases = this.proExecutiveService.queryList(param);
        List proThisYearEndCases = proThisYearAddCases.stream().filter(s -> s.getExecutiveStateName() != null && !"\u6267\u884c\u4e2d".equals(s.getExecutiveStateName())).collect(Collectors.toList());
        BigDecimal proProgressCasesMny = proProgressCases.stream().filter(s -> s.getExecutiveAmount() != null).map(ProsecutionExecutiveRegisterEntity::getExecutiveAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearAddCasesMny = proThisYearAddCases.stream().filter(s -> s.getExecutiveAmount() != null).map(ProsecutionExecutiveRegisterEntity::getExecutiveAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal proThisYearEndCasesMny = proThisYearEndCases.stream().filter(s -> s.getExecutiveAmount() != null).map(ProsecutionExecutiveRegisterEntity::getExecutiveAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        param.getParams().remove("executive_start_date");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(5, -7);
        param.getParams().put("executive_start_date", new Parameter("between", (Object)(simpleDateFormat.format(instance.getTime()) + "," + simpleDateFormat.format(date))));
        List executiveRegisterEntities = this.executiveService.queryList(param);
        List executiveRegisterSevenDays = executiveRegisterEntities.stream().filter(s -> s.getExecutiveStateName() != null && "\u6267\u884c\u4e2d".equals(s.getExecutiveStateName())).collect(Collectors.toList());
        List prosecutionExecutiveRegisterEntities = this.proExecutiveService.queryList(param);
        List prosecutionExecutiveSevenDays = prosecutionExecutiveRegisterEntities.stream().filter(s -> s.getExecutiveStateName() != null && "\u6267\u884c\u4e2d".equals(s.getExecutiveStateName())).collect(Collectors.toList());
        CaseBaseVO caseBaseVO = new CaseBaseVO();
        caseBaseVO.setProgressCases(Integer.valueOf(progressCases.size()));
        caseBaseVO.setThisYearAddCases(Integer.valueOf(thisYearAddCases.size()));
        caseBaseVO.setThisYearEndCases(Integer.valueOf(thisYearEndCases.size()));
        caseBaseVO.setProgressCasesMny(progressCasesMny);
        caseBaseVO.setThisYearAddCasesMny(thisYearAddCasesMny);
        caseBaseVO.setThisYearEndMny(thisYearEndCasesMny);
        caseBaseVO.setSevenDaysAddCases(Integer.valueOf(executiveRegisterSevenDays.size()));
        caseBaseVO.setProProgressCases(Integer.valueOf(proProgressCases.size()));
        caseBaseVO.setProThisYearAddCases(Integer.valueOf(proThisYearAddCases.size()));
        caseBaseVO.setProThisYearEndCases(Integer.valueOf(proThisYearEndCases.size()));
        caseBaseVO.setProProgressCasesMny(proProgressCasesMny);
        caseBaseVO.setProThisYearAddCasesMny(proThisYearAddCasesMny);
        caseBaseVO.setProThisYearEndMny(proThisYearEndCasesMny);
        caseBaseVO.setProSevenDaysAddCases(Integer.valueOf(prosecutionExecutiveSevenDays.size()));
        return CommonResponse.success((String)"\u67e5\u8be2\u6267\u884c\u6848\u4ef6\u4fe1\u606f\u6210\u529f\uff01", (Object)caseBaseVO);
    }

    @RequestMapping(value={"/getInfoRank"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getInfoRank() {
        List<Map<String, String>> infoRank = this.infoRegisterService.getInfoRank();
        return CommonResponse.success((String)"\u67e5\u8be2\u5e94\u8bc9\u6848\u4ef6\u6cd5\u9662\u6392\u540d\u6210\u529f\uff01", infoRank);
    }

    @RequestMapping(value={"/getInfoArea"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getInfoArea(@RequestParam(value="name", required=false) String name, @RequestParam(value="dateIn", required=false) String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.infoArea(name, dateIn, orgId);
    }

    public CommonResponse<JSONObject> infoArea(String name, String dateIn, Long orgId) {
        Map<String, List<InfoAreaVO>> map;
        dateIn = EJCDateUtil.getYear() + "";
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)dateIn)) {
            queryWrapper.eq((Object)"DATE_FORMAT(first_start_date,\"%Y\")", (Object)dateIn);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        List list = this.infoRegisterService.list((Wrapper)queryWrapper);
        ArrayList<InfoAreaVO> infoAreaVOS = new ArrayList<InfoAreaVO>();
        if (ListUtil.isNotEmpty((List)list)) {
            List infoRegisterVOS = BeanMapper.mapList((Iterable)list, InfoRegisterVO.class);
            for (InfoRegisterVO infoRegisterVO : infoRegisterVOS) {
                InfoAreaVO infoAreaVO = new InfoAreaVO();
                infoAreaVO.setId(infoRegisterVO.getId());
                infoAreaVO.setOrgId(infoRegisterVO.getOrgId());
                infoAreaVO.setCourtName(infoRegisterVO.getFirstCourtName());
                if (StringUtils.isNotEmpty((CharSequence)infoRegisterVO.getAreaName())) {
                    String areaName = null;
                    areaName = infoRegisterVO.getAreaName().replace("/", "");
                    infoAreaVO.setAreaName(areaName);
                } else {
                    infoAreaVO.setAreaName(infoRegisterVO.getAreaName());
                }
                infoAreaVOS.add(infoAreaVO);
            }
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashSet<Object> provinceSet = new HashSet<Object>();
        HashSet<String> citySet = new HashSet<String>();
        HashSet<String> countySet = new HashSet<String>();
        String pname = null;
        for (InfoAreaVO vo : infoAreaVOS) {
            ids.add(vo.getId());
            if (StringUtils.isNotEmpty((CharSequence)vo.getAreaName())) {
                if (vo.getAreaName().equals("\u53f0\u6e7e\u7701")) {
                    vo.setProvince("\u53f0\u6e7e\u7701");
                    vo.setCity("\u53f0\u6e7e\u7701");
                    vo.setCounty("\u53f0\u6e7e\u7701");
                    provinceSet.add("\u53f0\u6e7e\u7701");
                    citySet.add("\u53f0\u6e7e\u7701");
                    countySet.add("\u53f0\u6e7e\u7701");
                    continue;
                }
                Map<String, String> areaMap = AddressResolutionUtil.addressResolution(vo.getAreaName());
                if (areaMap != null) {
                    String province = areaMap.get("province") == null ? "\u5176\u4ed6" : areaMap.get("province");
                    String string = areaMap.get("city") == null ? "\u5176\u4ed6" : areaMap.get("city");
                    String string2 = areaMap.get("county") == null ? "\u5176\u4ed6" : areaMap.get("county");
                    vo.setProvince(province);
                    vo.setCity(string);
                    vo.setCounty(string2);
                    provinceSet.add(province);
                    citySet.add(string);
                    countySet.add(string2);
                    if (!StringUtils.isNotBlank((CharSequence)name) || !string.equals(name)) continue;
                    pname = province;
                    continue;
                }
                vo.setProvince("\u5176\u4ed6");
                vo.setCity("\u5176\u4ed6");
                vo.setCounty("\u5176\u4ed6");
                provinceSet.add("\u5176\u4ed6");
                citySet.add("\u5176\u4ed6");
                countySet.add("\u5176\u4ed6");
                continue;
            }
            vo.setProvince("\u5176\u4ed6");
            vo.setCity("\u5176\u4ed6");
            vo.setCounty("\u5176\u4ed6");
            provinceSet.add("\u5176\u4ed6");
            citySet.add("\u5176\u4ed6");
            countySet.add("\u5176\u4ed6");
        }
        String rangeType = null;
        List<Object> dataVOS = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (provinceSet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = this.projectCountByName(name, infoAreaVOS, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pname) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = this.projectCountByName(name, infoAreaVOS, 1);
            }
        } else if (provinceSet.size() == 1) {
            if (citySet.size() == 1) {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar((String)citySet.iterator().next(), 1);
                HashMap<String, AreaDataVO> countyMap = new HashMap<String, AreaDataVO>();
                for (InfoAreaVO infoAreaVO : infoAreaVOS) {
                    String string = infoAreaVO.getCounty();
                    if (!countyMap.containsKey(string)) {
                        AreaDataVO pvo = new AreaDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        countyMap.put(string, pvo);
                        continue;
                    }
                    AreaDataVO projectDataVO = (AreaDataVO)countyMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    countyMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(countyMap.values());
                map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
                for (AreaDataVO areaDataVO : dataVOS) {
                    if (!map.containsKey(areaDataVO.getName())) continue;
                    List<InfoAreaVO> projectCountVOS = map.get(areaDataVO.getName());
                    areaDataVO.setInfoAreaVOS(projectCountVOS);
                }
            } else {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next());
                HashMap<String, AreaDataVO> cityMap = new HashMap<String, AreaDataVO>();
                for (InfoAreaVO infoAreaVO : infoAreaVOS) {
                    String string = infoAreaVO.getCity();
                    if (!cityMap.containsKey(string)) {
                        AreaDataVO pvo = new AreaDataVO();
                        pvo.setName(string);
                        pvo.setValue(Integer.valueOf(1));
                        cityMap.put(string, pvo);
                        continue;
                    }
                    AreaDataVO projectDataVO = (AreaDataVO)cityMap.get(string);
                    projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                    cityMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(cityMap.values());
                map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity));
                for (AreaDataVO areaDataVO : dataVOS) {
                    if (!map.containsKey(areaDataVO.getName())) continue;
                    List<InfoAreaVO> projectCountVOS = map.get(areaDataVO.getName());
                    areaDataVO.setInfoAreaVOS(projectCountVOS);
                }
            }
        } else {
            rangeType = "China";
            HashMap<String, AreaDataVO> provinceMap = new HashMap<String, AreaDataVO>();
            for (InfoAreaVO infoAreaVO : infoAreaVOS) {
                String string = infoAreaVO.getProvince();
                if (!provinceMap.containsKey(string)) {
                    AreaDataVO pvo = new AreaDataVO();
                    pvo.setName(string);
                    pvo.setValue(Integer.valueOf(1));
                    provinceMap.put(string, pvo);
                    continue;
                }
                AreaDataVO projectDataVO = (AreaDataVO)provinceMap.get(string);
                projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
                provinceMap.put(string, projectDataVO);
            }
            map = infoAreaVOS.stream().collect(Collectors.groupingBy(InfoAreaVO::getProvince));
            dataVOS = new ArrayList(provinceMap.values());
            for (AreaDataVO areaDataVO : dataVOS) {
                if (!map.containsKey(areaDataVO.getName())) continue;
                List<InfoAreaVO> projectCountVOS = map.get(areaDataVO.getName());
                areaDataVO.setInfoAreaVOS(projectCountVOS);
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<AreaDataVO>(){

                @Override
                public int compare(AreaDataVO o1, AreaDataVO o2) {
                    int a = "\u5176\u4ed6".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "\u5176\u4ed6".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        if (rangeType == null || rangeType.contains("null")) {
            rangeType = "China";
        }
        jsonObject.put("range", (Object)(rangeType == null || rangeType.contains("null") ? "China" : rangeType));
        ArrayList projectDataVOS = new ArrayList();
        jsonObject.put("data", dataVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private List<AreaDataVO> projectCountByName(String name, List<InfoAreaVO> list, Integer type) {
        ArrayList dataVOS = new ArrayList();
        HashMap<String, AreaDataVO> map = new HashMap<String, AreaDataVO>();
        for (InfoAreaVO vo : list) {
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (!voName.equals(name)) continue;
            if (!map.containsKey(childrenName)) {
                AreaDataVO pvo = new AreaDataVO();
                pvo.setName(childrenName);
                pvo.setValue(Integer.valueOf(1));
                map.put(childrenName, pvo);
                continue;
            }
            AreaDataVO projectDataVO = (AreaDataVO)map.get(childrenName);
            projectDataVO.setValue(Integer.valueOf(projectDataVO.getValue() + 1));
            map.put(childrenName, projectDataVO);
        }
        Map<String, List<InfoAreaVO>> projectCountVOMap = null;
        projectCountVOMap = type == 0 ? list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCity)) : list.stream().collect(Collectors.groupingBy(InfoAreaVO::getCounty));
        ArrayList<AreaDataVO> projectDataVOS = new ArrayList<AreaDataVO>(map.values());
        for (AreaDataVO dataVO : projectDataVOS) {
            if (!map.containsKey(dataVO.getName())) continue;
            List<InfoAreaVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
            dataVO.setInfoAreaVOS(projectCountVOS);
        }
        return projectDataVOS;
    }

    @RequestMapping(value={"/queryLawHistoryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CaseCompareVO> queryLawHistoryList(@RequestBody QueryParam param) {
        ArrayList<BigDecimal> caseMny = new ArrayList<BigDecimal>();
        ArrayList<Integer> caseNum = new ArrayList<Integer>();
        ArrayList<String> dateList = new ArrayList<String>();
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        for (int i = 4; i >= 0; --i) {
            param.getParams().put("year", new Parameter("eq", (Object)(LocalDate.now().getYear() - i)));
            QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List lawHistoryEntities = this.lawHistoryService.list((Wrapper)queryWrapper);
            if (!ListUtil.isNotEmpty((List)lawHistoryEntities)) continue;
            caseMny.add(((LawHistoryEntity)((Object)lawHistoryEntities.get(0))).getMny());
            caseNum.add(((LawHistoryEntity)((Object)lawHistoryEntities.get(0))).getNum());
            if (i == 4) continue;
            dateList.add(LocalDate.now().getYear() - i + "");
        }
        CaseCompareVO caseCompareVO = new CaseCompareVO();
        caseCompareVO.setDateList(dateList);
        caseCompareVO.setCaseMny(caseMny);
        caseCompareVO.setCaseNum(caseNum);
        return CommonResponse.success((String)"\u67e5\u8be2\u6848\u4ef6\u5386\u53f2\u4fe1\u606f\u5408\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)caseCompareVO);
    }

    @RequestMapping(value={"/getDepartmentRank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DepartmentRankVO>> getDepartmentRank(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().remove("tenantId");
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        Integer year = 0;
        if (param.getParams().containsKey("cognizanceDate")) {
            year = Integer.valueOf(((Parameter)param.getParams().get("cognizanceDate")).getValue().toString());
            param.getParams().remove("cognizanceDate");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DepartmentRankVO> departmentRank = this.registerMapper.getDepartmentRank((QueryWrapper<DepartmentRankVO>)wrapper, year);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", departmentRank);
    }

    @RequestMapping(value={"/getProjectType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DepartmentRankVO>> getProjectType(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        QueryParam orderParam = new QueryParam();
        if (param.getOrderMap() != null) {
            LinkedHashMap orderMap = param.getOrderMap();
            orderParam.setOrderMap(orderMap);
            param.getOrderMap().clear();
        }
        QueryWrapper orderWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)orderParam);
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DepartmentRankVO> departmentRank = this.registerMapper.getProjectType((QueryWrapper<DepartmentRankVO>)wrapper, orderWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", departmentRank);
    }

    @RequestMapping(value={"/getProjectTypeList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DepartmentRankVO>> getProjectTypeList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().remove("tenantId");
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DepartmentRankVO> departmentRank = this.registerMapper.getProjectTypeList((QueryWrapper<DepartmentRankVO>)wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", departmentRank);
    }

    @RequestMapping(value={"/getProDepartmentRank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DepartmentRankVO>> getProDepartmentRank(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().remove("tenantId");
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        Integer year = 0;
        if (param.getParams().containsKey("cognizanceDate")) {
            year = Integer.valueOf(((Parameter)param.getParams().get("cognizanceDate")).getValue().toString());
            param.getParams().remove("cognizanceDate");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DepartmentRankVO> departmentRank = this.registerMapper.getProDepartmentRank((QueryWrapper<DepartmentRankVO>)wrapper, year);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", departmentRank);
    }

    @RequestMapping(value={"/getProProjectType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DepartmentRankVO>> getProProjectType(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        QueryParam orderParam = new QueryParam();
        if (param.getOrderMap() != null) {
            LinkedHashMap orderMap = param.getOrderMap();
            orderParam.setOrderMap(orderMap);
            param.getOrderMap().clear();
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        QueryWrapper orderWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)orderParam);
        List<DepartmentRankVO> departmentRank = this.registerMapper.getProProjectType((QueryWrapper<DepartmentRankVO>)wrapper, orderWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", departmentRank);
    }

    @RequestMapping(value={"/getProProjectTypeList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DepartmentRankVO>> getProProjectTypeList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().remove("tenantId");
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DepartmentRankVO> departmentRank = this.registerMapper.getProProjectTypeList((QueryWrapper<DepartmentRankVO>)wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", departmentRank);
    }

    @RequestMapping(value={"/queryInnerCase"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CaseBaseVO> queryInnerCase(QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        List thisYearAddCases = this.innerCaseService.queryList(param);
        List progressCases = thisYearAddCases.stream().filter(s -> s.getCaseState() != null && !"\u5df2\u7ed3\u6848".equals(s.getCaseState())).collect(Collectors.toList());
        List importantCases = progressCases.stream().filter(s -> "\u662f".equals(s.getImportantFlag())).collect(Collectors.toList());
        List thisYearEndCases = thisYearAddCases.stream().filter(s -> s.getCaseState() != null && "\u5df2\u7ed3\u6848".equals(s.getCaseState())).collect(Collectors.toList());
        if (param.getParams().containsKey("apply_date")) {
            param.getParams().remove("apply_date");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(5, -7);
        param.getParams().put("apply_date", new Parameter("between", (Object)(simpleDateFormat.format(instance.getTime()) + "," + simpleDateFormat.format(date))));
        List executiveRegisterEntities = this.innerCaseService.queryList(param);
        BigDecimal progressCasesMny = progressCases.stream().filter(s -> s.getInnerMny() != null).map(InnerCaseEntity::getInnerMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearAddCasesMny = thisYearAddCases.stream().filter(s -> s.getInnerMny() != null).map(InnerCaseEntity::getInnerMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal thisYearEndCasesMny = thisYearEndCases.stream().filter(s -> s.getInnerMny() != null).map(InnerCaseEntity::getInnerMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal importantCasesMny = importantCases.stream().filter(s -> s.getInnerMny() != null).map(InnerCaseEntity::getInnerMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        CaseBaseVO caseBaseVO = new CaseBaseVO();
        caseBaseVO.setProgressCases(Integer.valueOf(progressCases.size()));
        caseBaseVO.setThisYearAddCases(Integer.valueOf(thisYearAddCases.size()));
        caseBaseVO.setThisYearEndCases(Integer.valueOf(thisYearEndCases.size()));
        caseBaseVO.setImportantCases(Integer.valueOf(importantCases.size()));
        caseBaseVO.setProSevenDaysAddCases(Integer.valueOf(executiveRegisterEntities.size()));
        caseBaseVO.setProgressCasesMny(progressCasesMny);
        caseBaseVO.setThisYearAddCasesMny(thisYearAddCasesMny);
        caseBaseVO.setThisYearEndMny(thisYearEndCasesMny);
        caseBaseVO.setImportantCasesMny(importantCasesMny);
        return CommonResponse.success((String)"\u5185\u90e8\u4ef2\u88c1\u4fe1\u606f\u7edf\u8ba1\u67e5\u8be2\u6210\u529f\uff01", (Object)caseBaseVO);
    }

    @RequestMapping(value={"/getInnerRank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DepartmentRankVO>> getInnerRank(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().remove("tenantId");
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DepartmentRankVO> departmentRank = this.innerCaseService.getInnerRank((QueryWrapper<DepartmentRankVO>)wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5185\u90e8\u4ef2\u88c1\u6392\u540d\u6210\u529f\uff01", departmentRank);
    }

    @RequestMapping(value={"/queryInnerCaseType"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> queryInnerCaseType(String type) {
        ArrayList caseTypeResult = new ArrayList();
        QueryWrapper caseWrapper = new QueryWrapper();
        caseWrapper.in((Object)"bill_state", Arrays.asList(1, 3));
        caseWrapper.between((Object)"apply_date", (Object)(LocalDate.now().getYear() + "-1-1"), (Object)(LocalDate.now().getYear() + "-12-31"));
        List thisYearAddCases = this.innerCaseService.list((Wrapper)caseWrapper);
        Map<String, List<InnerCaseEntity>> caseTypeMap = thisYearAddCases.stream().collect(Collectors.groupingBy(s -> StringUtils.isNotBlank((CharSequence)s.getDisputeTypeName()) ? s.getDisputeTypeName() : "\u5176\u4ed6"));
        for (Map.Entry<String, List<InnerCaseEntity>> caseTypeEntry : caseTypeMap.entrySet()) {
            List<InnerCaseEntity> caseTypeList = caseTypeEntry.getValue();
            BigDecimal allMny = caseTypeList.stream().filter(s -> s.getInnerMny() != null).map(InnerCaseEntity::getInnerMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", caseTypeEntry.getKey());
            map.put("value", allMny.toString());
            map.put("num", caseTypeList.size() + "");
            caseTypeResult.add(map);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6848\u4ef6\u7c7b\u578b\u5360\u6bd4\u6210\u529f\uff01", caseTypeResult);
    }

    @RequestMapping(value={"/getInnerCaseMnyRange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> getInnerCaseMnyRange() {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        param.getParams().put("applyDate", new Parameter("between", (Object)(LocalDate.now().getYear() + startMonth + LocalDate.now().getYear() + endMonth)));
        List entities = this.innerCaseService.queryList(param);
        ArrayList resultMapList = new ArrayList();
        List<Object> rangeList = new ArrayList();
        rangeList = this.getInnerListByRange(entities, BigDecimal.ZERO, ONE_HUNDRED_THOUSAND);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "0-10\u4e07");
        map.put("value", rangeList.size() + "");
        resultMapList.add(map);
        rangeList = this.getInnerListByRange(entities, ONE_HUNDRED_THOUSAND, ONE_MILLION);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("name", "10\u4e07-100\u4e07");
        map1.put("value", rangeList.size() + "");
        resultMapList.add(map1);
        rangeList = this.getInnerListByRange(entities, ONE_MILLION, FIVE_MILLION);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("name", "100\u4e07-500\u4e07");
        map2.put("value", rangeList.size() + "");
        resultMapList.add(map2);
        rangeList = this.getInnerListByRange(entities, FIVE_MILLION, null);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("name", "500\u4e07\u4ee5\u4e0a");
        map3.put("value", rangeList.size() + "");
        resultMapList.add(map3);
        return CommonResponse.success((String)"\u67e5\u8be2\u5185\u90e8\u4ef2\u88c1\u6848\u4ef6\u91d1\u989d\u8303\u56f4\u5bf9\u6bd4\u6570\u636e\u6210\u529f\uff01", resultMapList);
    }

    private List<InnerCaseEntity> getInnerListByRange(List<InnerCaseEntity> list, BigDecimal start, BigDecimal end) {
        if (start != null && end != null) {
            return list.stream().filter(s -> s.getInnerMny() != null && s.getInnerMny().compareTo(start) >= 0 && s.getInnerMny().compareTo(end) < 0).collect(Collectors.toList());
        }
        if (start == null && end != null) {
            return list.stream().filter(s -> s.getInnerMny() != null && s.getInnerMny().compareTo(end) < 0).collect(Collectors.toList());
        }
        if (start != null && end == null) {
            return list.stream().filter(s -> s.getInnerMny() != null && s.getInnerMny().compareTo(start) >= 0).collect(Collectors.toList());
        }
        return new ArrayList<InnerCaseEntity>();
    }

    @RequestMapping(value={"/queryInnerCaseCompare"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CaseCompareVO> queryInnerCaseCompare(String type) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        ArrayList<BigDecimal> caseMny = new ArrayList<BigDecimal>();
        ArrayList<Integer> caseNum = new ArrayList<Integer>();
        ArrayList<String> dateList = new ArrayList<String>();
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        for (int i = 3; i >= 0; --i) {
            BigDecimal totalMny = new BigDecimal(0.0);
            param.getParams().put("applyDate", new Parameter("between", (Object)(LocalDate.now().getYear() - i + startMonth + (LocalDate.now().getYear() - i) + endMonth)));
            List caseEntities = this.innerCaseService.queryList(param);
            this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u6570\u636e\u5171{}\u6761\u3002", (Object)(LocalDate.now().getYear() - i), (Object)caseEntities.size());
            param.getParams().remove("cognizanceDate");
            for (InnerCaseEntity entity : caseEntities) {
                if (entity.getInnerMny() == null) continue;
                totalMny = totalMny.add(entity.getInnerMny());
            }
            caseMny.add(totalMny);
            this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u91d1\u989d:{}\u3002", (Object)(LocalDate.now().getYear() - i), (Object)totalMny);
            if (i != 3) {
                dateList.add(LocalDate.now().getYear() - i + "");
            }
            caseNum.add(caseEntities.size());
        }
        CaseCompareVO caseCompareVO = new CaseCompareVO();
        caseCompareVO.setDateList(dateList);
        caseCompareVO.setCaseMny(caseMny);
        caseCompareVO.setCaseNum(caseNum);
        return CommonResponse.success((String)"\u67e5\u8be2\u8fd1\u4e09\u5e74\u6848\u4ef6\u4fe1\u606f\u6210\u529f\uff01", (Object)caseCompareVO);
    }

    @RequestMapping(value={"/getProExDepartmentRank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DepartmentRankVO>> getProExDepartmentRank(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().remove("tenantId");
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        Integer year = 0;
        if (param.getParams().containsKey("cognizanceDate")) {
            year = Integer.valueOf(((Parameter)param.getParams().get("cognizanceDate")).getValue().toString());
            param.getParams().remove("cognizanceDate");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DepartmentRankVO> departmentRank = this.registerMapper.getProExDepartmentRank((QueryWrapper<DepartmentRankVO>)wrapper, year);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", departmentRank);
    }

    @RequestMapping(value={"/getExDepartmentRank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<DepartmentRankVO>> getExDepartmentRank(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().remove("tenantId");
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        Integer year = 0;
        if (param.getParams().containsKey("cognizanceDate")) {
            year = Integer.valueOf(((Parameter)param.getParams().get("cognizanceDate")).getValue().toString());
            param.getParams().remove("cognizanceDate");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<DepartmentRankVO> departmentRank = this.registerMapper.getExDepartmentRank((QueryWrapper<DepartmentRankVO>)wrapper, year);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", departmentRank);
    }

    @RequestMapping(value={"/queryProExCaseCompare"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CaseCompareVO> queryProExCaseCompare(String type) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        ArrayList<BigDecimal> caseMny = new ArrayList<BigDecimal>();
        ArrayList<Integer> caseNum = new ArrayList<Integer>();
        ArrayList<String> dateList = new ArrayList<String>();
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        for (int i = 3; i >= 0; --i) {
            BigDecimal totalMny = new BigDecimal(0.0);
            param.getParams().put("executiveStartDate", new Parameter("between", (Object)(LocalDate.now().getYear() - i + startMonth + (LocalDate.now().getYear() - i) + endMonth)));
            List caseEntities = this.proExecutiveService.queryList(param);
            this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u6570\u636e\u5171{}\u6761\u3002", (Object)(LocalDate.now().getYear() - i), (Object)caseEntities.size());
            param.getParams().remove("executiveStartDate");
            for (ProsecutionExecutiveRegisterEntity entity : caseEntities) {
                if (entity.getExecutiveAmount() == null) continue;
                totalMny = totalMny.add(entity.getExecutiveAmount());
            }
            caseMny.add(totalMny);
            this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u91d1\u989d:{}\u3002", (Object)(LocalDate.now().getYear() - i), (Object)totalMny);
            if (i != 3) {
                dateList.add(LocalDate.now().getYear() - i + "");
            }
            caseNum.add(caseEntities.size());
        }
        CaseCompareVO caseCompareVO = new CaseCompareVO();
        caseCompareVO.setDateList(dateList);
        caseCompareVO.setCaseMny(caseMny);
        caseCompareVO.setCaseNum(caseNum);
        return CommonResponse.success((String)"\u67e5\u8be2\u8fd13\u5e74\u7533\u8bf7\u6267\u884c\u6848\u4ef6\u5bf9\u6bd4\uff08\u8d77\u8bc9\uff09\u6210\u529f\uff01", (Object)caseCompareVO);
    }

    @RequestMapping(value={"/queryExCaseCompare"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CaseCompareVO> queryExCaseCompare(String type) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        ArrayList<BigDecimal> caseMny = new ArrayList<BigDecimal>();
        ArrayList<Integer> caseNum = new ArrayList<Integer>();
        ArrayList<String> dateList = new ArrayList<String>();
        String startMonth = "-1-1,";
        String endMonth = "-12-31";
        for (int i = 3; i >= 0; --i) {
            BigDecimal totalMny = new BigDecimal(0.0);
            param.getParams().put("executiveStartDate", new Parameter("between", (Object)(LocalDate.now().getYear() - i + startMonth + (LocalDate.now().getYear() - i) + endMonth)));
            List caseEntities = this.executiveService.queryList(param);
            this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u6570\u636e\u5171{}\u6761\u3002", (Object)(LocalDate.now().getYear() - i), (Object)caseEntities.size());
            param.getParams().remove("executiveStartDate");
            for (ExecutiveRegisterEntity entity : caseEntities) {
                if (entity.getExecutiveAmount() == null) continue;
                totalMny = totalMny.add(entity.getExecutiveAmount());
            }
            caseMny.add(totalMny);
            this.logger.info("-----------{}\u5e74\u5e94\u8bc9\u6848\u4ef6\u91d1\u989d:{}\u3002", (Object)(LocalDate.now().getYear() - i), (Object)totalMny);
            if (i != 3) {
                dateList.add(LocalDate.now().getYear() - i + "");
            }
            caseNum.add(caseEntities.size());
        }
        CaseCompareVO caseCompareVO = new CaseCompareVO();
        caseCompareVO.setDateList(dateList);
        caseCompareVO.setCaseMny(caseMny);
        caseCompareVO.setCaseNum(caseNum);
        return CommonResponse.success((String)"\u67e5\u8be2\u8fd13\u5e74\u7533\u8bf7\u6267\u884c\u6848\u4ef6\u5bf9\u6bd4\uff08\u8d77\u8bc9\uff09\u6210\u529f\uff01", (Object)caseCompareVO);
    }
}

