package com.ejianc.business.market.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 项目预备案表
 *
 * @author generator
 *
 */
public class PreparationPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String type; // 项目类型：1-自营，2-联营
    private Long orgId; // 所属组织
    private String orgName; // 所属组织名称
    private String code; // 项目编号
    private String name; // 项目名称
    private String shortName; // 项目简称
    private String address; // 项目地点
    private Long pubUnit; // 建设单位
    private String pubUnitName; // 建设单位
    private String supervisor; // 监理单位
    private String designer; // 设计单位
    private Long businessType; // 业务类型
    private String businessTypeName; // 业务类型
    private String memo; // 项目内容概述
    private String contractFlag; // 是否已签订合同
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractSignDate; // 合同签订日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedCommencementDate; // 计划开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate; // 计划竣工日期
    private BigDecimal costTotal; // 金额（元）
    private BigDecimal taxRate; // 税率
    private BigDecimal expectCostTotal; // 预计成本总额（元）
    private BigDecimal expectProfitRate; // 预计利润率（%）
    private String qualityMaintainFlag; // 是否含有质保\养护期
    private String qualityMaintainDate; // 预计质保\养护期起止日
    private BigDecimal qualityMaintainMny; // 质保\养护金额（元）
    private Integer billState; // 单据状态（审批必须字段）


    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @ReferSerialTransfer(referCode = "support-customer")
    public Long getPubUnit() {
        return pubUnit;
    }

    @ReferDeserialTransfer
    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBusinessType() {
        return businessType;
    }

    @ReferDeserialTransfer
    public void setBusinessType(Long businessType) {
        this.businessType = businessType;
    }

    public String getBusinessTypeName() {
        return businessTypeName;
    }

    public void setBusinessTypeName(String businessTypeName) {
        this.businessTypeName = businessTypeName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(String contractFlag) {
        this.contractFlag = contractFlag;
    }

    public Date getContractSignDate() {
        return contractSignDate;
    }

    public void setContractSignDate(Date contractSignDate) {
        this.contractSignDate = contractSignDate;
    }

    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getExpectCostTotal() {
        return expectCostTotal;
    }

    public void setExpectCostTotal(BigDecimal expectCostTotal) {
        this.expectCostTotal = expectCostTotal;
    }

    public BigDecimal getExpectProfitRate() {
        return expectProfitRate;
    }

    public void setExpectProfitRate(BigDecimal expectProfitRate) {
        this.expectProfitRate = expectProfitRate;
    }

    public String getQualityMaintainFlag() {
        return qualityMaintainFlag;
    }

    public void setQualityMaintainFlag(String qualityMaintainFlag) {
        this.qualityMaintainFlag = qualityMaintainFlag;
    }

    public String getQualityMaintainDate() {
        return qualityMaintainDate;
    }

    public void setQualityMaintainDate(String qualityMaintainDate) {
        this.qualityMaintainDate = qualityMaintainDate;
    }

    public BigDecimal getQualityMaintainMny() {
        return qualityMaintainMny;
    }

    public void setQualityMaintainMny(BigDecimal qualityMaintainMny) {
        this.qualityMaintainMny = qualityMaintainMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

}
