package com.ejianc.business.market.api;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.hystrix.ProjectHystrix;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.market.vo.SupplierCooperateVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 项目rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-market-web", url="${common.env.feign-client-url}", path="ejc-market-web", fallback = ProjectHystrix.class)
public interface IProjectApi {

	/**
	 * 根据sourceId查询项目详情
	 *
	 * @param sourceId
	 * @return
	 */
	@GetMapping(value = "/api/project/queryProjectBySourceId")
	public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(@RequestParam(value = "sourceId") String sourceId);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/8/21 根据项目部id查询项目信息
	 * @Description queryProjectByProjectDepartmentId
	 * @Param [sourceId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.market.vo.ProjectRegisterVO>
	 */
	@GetMapping(value = "/api/project/queryProjectByProjectDepartmentId")
	CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") String projectDepartmentId);

	/**
	 * 根据ids查询项目详情
	 *
	 * @param ids
	 * @return
	 */
	@GetMapping(value = "/api/project/queryProjectByIds")
	public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(@RequestParam(value = "ids") List<Long> ids);

	/**
	 * 根据条件查询对应项目ID列表
	 *
	 * @param projectRange 1-全部项目，2-在建项目，3-完工项目，4-本年新签项目
	 * @return
	 */
	@GetMapping(value = "/api/project/getProjectIdsByProperties")
	CommonResponse<List<Long>> getProjectIdsByProperties(@RequestParam(value = "projectRange") int projectRange);


	@GetMapping(value = "/api/project/getProjectIdsByEngineeringType")
	CommonResponse<List<Long>> getProjectIdsByEngineeringType(@RequestParam(value = "projectRange") int projectRange,@RequestParam(value = "engineeringType",required = false) Long engineeringType) ;


	/**
	 * 供方协同---用户获取有权限的项目，为空代表全部项目的权限
	 *
	 * @return
	 */
	@GetMapping(value = "/api/project/queryProjectByUserId")
	CommonResponse<List<ProjectRegisterVO>> queryProjectByUserId(@RequestParam(value = "userId") Long userId);

	/***
	 * @Author mrsir_wxp
	 * @Date 2021/2/1 查询本下启用的项目，参数为需要查询的条数，默认十条
	 * @Description queryProjectList
	 * @Param [num]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.ejianc.business.market.vo.ProjectRegisterVO>>
	 */
	@GetMapping(value = "/api/project/queryProjectList")
	CommonResponse<List<ProjectRegisterVO>> queryProjectList(@RequestParam(value = "num",defaultValue = "10") int num);
	/**
	 * @Author mrsir_wxp
	 * @Date 2021/5/18
	 * @Description queryProjectPage
	 * @Param [queryParam]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.market.vo.ProjectRegisterVO>>
	 */
	@PostMapping(value = "/api/project/queryProjectPage")
	CommonResponse<Page<ProjectRegisterVO>> queryProjectPage(@RequestBody QueryParam queryParam);

	/**
	 * @Author zhangwx
	 * @Date 2021/06/07 根据组织主键查询本下所有项目
	 * @Description queryProjectByProjectDepartmentId
	 * @Param [orgId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.ejianc.business.market.vo.ProjectRegisterVO>>
	 */
	@GetMapping(value = "/api/project/queryChildrenProjectByOrgId")
	CommonResponse<List<ProjectRegisterVO>> queryChildrenProjectByOrgId(@RequestParam(value = "orgId") Long orgId);

	/**
	 * 根据组织主键查询本下项目地址，过滤条件项目状态、关注类型
	 * @return
	 */
	@GetMapping(value = "/api/project/queryProjects")
	CommonResponse<List<Map>> queryProjects(@RequestParam(value = "orgId") Long orgId,
											@RequestParam(value = "statusList", required = false) List<String> statusList,
											@RequestParam(value = "focusTypeList", required = false) List<String> focusTypeList,
											@RequestParam(value = "engineeringTypeList", required = false) List<Long> engineeringTypeList,
											@RequestParam(value = "searchText", required = false) String searchText);

	@GetMapping("/api/project/queryProjectDetail")
	public CommonResponse<ProjectRegisterVO> queryProjectDetail(@RequestParam(value = "projectId") Long projectId);


	@PostMapping(value = "/api/project/queryProjectListByStatus")
	CommonResponse<List<Long>> queryProjectListByStatus(@RequestBody ProjectRegisterVO vo);

	/**
	 * 查询本下所有满足匹配条件的项目列表
	 *
	 * @param filterOrgVo
	 * @return
	 */
	@PostMapping(value = "/api/project/queryFilterProjects")
	CommonResponse<List<ProjectRegisterVO>> queryFilterProjects(@RequestBody FilterOrgIdVo filterOrgVo);

	/**
	 * 返回一个orgIds 根据条件过滤掉对应的orgId
	 * @param filterOrgVo
	 * @return
	 */
	@PostMapping(value = "/api/project/queryFilterOrgIds")
	CommonResponse<List<Long>> queryFilterOrgIds(@RequestBody FilterOrgIdVo filterOrgVo);

	@PostMapping(value = "/api/project/queryFilterOrgIdsBuStatus")
	CommonResponse<List<Long>> queryFilterOrgIdsBuStatus(@RequestParam(value = "status") String status);
	/**
	 * 根据供应商id查询供应商合作信息
	 *
	 * @param supplierIds
	 * @return
	 */
	@PostMapping(value = "/api/project/querySupplierCooperate")
	CommonResponse<Map<Long,List<SupplierCooperateVO>>> querySupplierCooperate(@RequestBody List<Long> supplierIds);

	@PostMapping(value = "/api/project/queryAllProj")
	CommonResponse<List<ProjectRegisterVO>> queryAllProj(@RequestBody QueryParam queryParam);


	@PostMapping(value = "/api/project/getProjectMapByCodes")
	CommonResponse<Map<String, ProjectRegisterVO>> getProjectMapByCodes(@RequestBody List<String> codes);


	/**
	 * @description: 更新项目项目阶段
	 *
	 * @param projectId
	 * @param projectStage
	 * @return {@link CommonResponse< String>}
	 * @author songlx
	 * @date: 2024/7/11
	 */
	@GetMapping("/api/project/changeProjectStage")
	CommonResponse<String> changeProjectStage(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "projectStage") String projectStage);


}
