package com.ejianc.business.consts;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 项目业务状态
 */
public enum ProjectBusinessStatusEnum {

    未开工("1", "未开工"),
    在建("2", "在建"),
    完工("3", "完工"),
    项目结清("4", "项目结清"),
    停工("5", "停工");


    private static Map<String, String> enumMap;

    static {
        enumMap = new HashMap<>();
        for (ProjectBusinessStatusEnum enumVal : ProjectBusinessStatusEnum.values()) {
            enumMap.put(enumVal.getBusinessStatus(), enumVal.getBusinessStatusName());
        }
    }

    public static String getNameByCode(String code) {
        return enumMap.get(code);
    }


    public static String getCodeByName(String name) {
        Set<String> keySet = enumMap.keySet();
        for (String key : keySet) {
            String val = enumMap.get(key);
            if (val.equals(name)) {
                return key;
            }
        }
        return null;
    }


    private String businessStatus;

    private String businessStatusName;

    ProjectBusinessStatusEnum(String businessStatus, String businessStatusName) {
        this.businessStatus = businessStatus;
        this.businessStatusName = businessStatusName;
    }

    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }

    public String getBusinessStatusName() {
        return businessStatusName;
    }

    public void setBusinessStatusName(String businessStatusName) {
        this.businessStatusName = businessStatusName;
    }

}
