package com.ejianc.business.market.api;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.market.hystrix.SupportProjectHystrix;
import com.ejianc.business.market.vo.ProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 中建科技项目rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-market-web", url="${common.env.feign-client-url}", path="ejc-market-web", fallback = SupportProjectHystrix.class)
public interface IZjkjProjectApi {

    /**
     * 根据项目Id查询项目信息
     *
     * @param id
     * @return
     */
	@GetMapping("/api/zjkj/projectApi/queryDetailById")
	CommonResponse<ProjectVO> queryDetailById(@RequestParam(value = "id") Long id);

    /**
     * 根据ids查询项目详情
     *
     * @param ids
     * @return
     */
    @PostMapping(value = "/api/zjkj/projectApi/queryProjectArray")
    CommonResponse<JSONArray> queryProjectArray(@RequestBody List<Long> ids);
    /**
     * 根据条件查询中建科技下的所有项目
     * @param
     * @return
     */
    @PostMapping(value = "/api/zjkj/projectApi/queryProjects")
    CommonResponse<List<ProjectVO>> queryProjects(@RequestBody QueryParam param);

    /**
     * 根据条件查询中建科技下的所有项目
     * @param
     * @return
     */
    @PostMapping(value = "/api/zjkj/projectApi/queryArray")
    CommonResponse<JSONArray> queryArray(@RequestBody QueryParam param);

    /**
     * 根据项目部id查询项目信息
     * @param projectDepartmentId
     * @return
     */
    @GetMapping("/api/zjkj/projectApi/queryProjectByProjectDepartmentId")
    CommonResponse<ProjectVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") Long projectDepartmentId);

    /**
     * 查询当前组织下的所有启用和在建的项目
     * @param orgId
     * @return
     */
    @GetMapping("/api/zjkj/projectApi/queryProjectsByOrgId")
    CommonResponse<List<ProjectVO>> queryProjectsByOrgId(@RequestParam("orgId") Long orgId);

    /**
     * 查询当前组织下的所有启用和在建的项目
     * @param orgId
     * @return
     */
    @GetMapping("/api/zjkj/projectApi/queryArrayByOrgId")
    CommonResponse<JSONArray> queryArrayByOrgId(@RequestParam("orgId") Long orgId);
}
