package com.ejianc.business.market.vo;

import com.ejianc.foundation.share.vo.ProjectPriceVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 项目
 * 
 * @author generator
 * 
 */
public class ProjectVO extends BaseVO {
    private static final long serialVersionUID = 1L;
	private Integer billState;
    private Long orgId; // 上级组织
    private String orgName; // 上级组织名称
    private Long projectDepartmentId; // 所属项目部Id
	private Integer state; // 状态标识（1：启用，0：停用）
    
    private String billCode; // 项目编码
    private String projectName; // 项目名称
    private Long projectAlias; // 项目别名
    private String projectAliasName; // 项目别名
    private Long constructionUnit; // 建设单位
    private String constructionUnitName; // 建设单位名称
    private String projectType; // 项目类型

    private Long promoterNature; // 发包人性质
    private String promoterNatureName; // 发包人性质名称
    private String promoterSocialCreditCode; // 统一社会信用代码
    private String promoterAdress; // 发包人地址
    private String promoterLegal; // 法人代表
    private String promoterTelephone; // 法人电话
    
    private String designUnit; // 设计单位
    private String supervisionUnit; // 监理单位
    private Long contractualModel; // 承包模式
    private String contractualModelName; // 承包模式名称
    private Long investmentSource; // 投资来源
    private String investmentSourceName; // 投资来源名称
    private Long type; // 建筑类型
    private String typeName; // 建筑类型名称
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开工日期
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 竣工日期
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualStartDate; // 实际开工日期
    private String baseType; // 基础类型
    private String structureType; // 结构类型
    private String builtArea; // 建筑面积(地上/地下)
    private String builtAllArea; // 建筑总面积
    private BigDecimal builtHeight; // 建筑高度(地上/地下）
    private String layerNumber; // 层数(地上/地下)
    private BigDecimal prefabricationRate; // 预制率
    private BigDecimal assemblyRate; // 装配率
    private String epcContractScope; // 总包合同范围
    private String specifySubcontractSscope; // 指定分包合同范围
    private Long leader; // 项目负责人
    private String leaderContactInformation; // 负责人联系方式
    private String integratedCode; // 一体化编码
    private Integer duration; // 工期
    private Long contractorUnit; // 承包单位
    private BigDecimal controlPrice; // 控制价
    private Long qualityAgreement; // 质量约定
    private String projectScale; // 工程规模
    private String priceMethod; // 计价方式
    private BigDecimal projectBiddingProfit; // 项目投标利润率
    private String consortiumWonBid; // 联合体中标
    private String investmentProject; // 融投资带动项目
    private BigDecimal quotaPriceDownwardRate; // 定额计价下浮率
    private Long build; // 施工单位
    private String contractingType; // 承包类型
    private Long signUnit; // 签约单位
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签约日期
    private Long projectCategory; // 项目类别
    private Long signStatus; // 签约状态
    private Long biddingForm; // 招标形式
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date notificationAwardDate; // 中标通知书日期
    private String projectLocation; // 工程地点
    private String projectArea; // 工程键值
    private String durationDescription; // 工期描述
    private String jobContent; // 工作内容
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualEndDate; // 实际竣工日期
    private String safeCivilizedConstructionRequirement; // 安全(文明)施工要求
    private String priceAdjustmentProcessTime; // 认价或价格调整的流程与时间
    private Long projectControlLevel; // 项目管控级别
    /**
     * 项目状态：1-未开工, 2-在建，3-完成
     */
    private String status;

    private String area; //项目地区
    private String lat; // 纬度
    private String lng; // 经度

    /************项目工程标价*************/
    private BigDecimal projectBidWinPrice; // 工程中标价(元)
    private BigDecimal civilEngineering; // 土建(元)
    private BigDecimal fix; // 安装(元)
    private BigDecimal waterSupplyDrainage; // 给排水(元)
    private BigDecimal strongCurrent; // 强电(元)
    private BigDecimal heateVentilation; // 暖通(元)
    private BigDecimal fixOther; // 其它(元)
    private BigDecimal decorate; // 装饰(元)
    private BigDecimal other; // 其它(元)
    /************项目工程标价*************/

    /************项目合同额*************/
    private BigDecimal contractAmount; // 合同额(元)
    private BigDecimal selfConstructionContractAmount; // 自施合同额(元)
    private String belong; // 合同价格形式
    /************项目合同额*************/
    
    private List<ProjectPriceVO> projectPriceList = new ArrayList<>(); // 项目工程标价
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * 项目成员
     */
    private List<Map<String, Object>> membersList;

    public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectAlias() {
        return projectAlias;
    }

    @ReferDeserialTransfer
    public void setProjectAlias(Long projectAlias) {
        this.projectAlias = projectAlias;
    }
    public String getProjectAliasName() {
		return projectAliasName;
	}

	public void setProjectAliasName(String projectAliasName) {
		this.projectAliasName = projectAliasName;
	}

    @ReferSerialTransfer(referCode="support-customer")
    public Long getConstructionUnit() {
        return constructionUnit;
    }

    @ReferDeserialTransfer
    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }

    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }

    public String getDesignUnit() {
        return designUnit;
    }

    public void setDesignUnit(String designUnit) {
        this.designUnit = designUnit;
    }

    public String getSupervisionUnit() {
        return supervisionUnit;
    }

    public void setSupervisionUnit(String supervisionUnit) {
        this.supervisionUnit = supervisionUnit;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }

    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getInvestmentSource() {
        return investmentSource;
    }

    @ReferDeserialTransfer
    public void setInvestmentSource(Long investmentSource) {
        this.investmentSource = investmentSource;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getType() {
        return type;
    }

    @ReferDeserialTransfer
    public void setType(Long type) {
        this.type = type;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getActualStartDate() {
        return actualStartDate;
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public String getBaseType() {
        return baseType;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }
 
    public String getStructureType() {
        return structureType;
    }

    public void setStructureType(String structureType) {
        this.structureType = structureType;
    }

    public String getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(String builtArea) {
        this.builtArea = builtArea;
    }

    public BigDecimal getBuiltHeight() {
        return builtHeight;
    }

    public void setBuiltHeight(BigDecimal builtHeight) {
        this.builtHeight = builtHeight;
    }

    public String getLayerNumber() {
        return layerNumber;
    }

    public void setLayerNumber(String layerNumber) {
        this.layerNumber = layerNumber;
    }

    public BigDecimal getPrefabricationRate() {
        return prefabricationRate;
    }

    public void setPrefabricationRate(BigDecimal prefabricationRate) {
        this.prefabricationRate = prefabricationRate;
    }

    public BigDecimal getAssemblyRate() {
        return assemblyRate;
    }

    public void setAssemblyRate(BigDecimal assemblyRate) {
        this.assemblyRate = assemblyRate;
    }

    public String getEpcContractScope() {
        return epcContractScope;
    }

    public void setEpcContractScope(String epcContractScope) {
        this.epcContractScope = epcContractScope;
    }

    public String getSpecifySubcontractSscope() {
        return specifySubcontractSscope;
    }

    public void setSpecifySubcontractSscope(String specifySubcontractSscope) {
        this.specifySubcontractSscope = specifySubcontractSscope;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getLeader() {
        return leader;
    }

    @ReferDeserialTransfer
    public void setLeader(Long leader) {
        this.leader = leader;
    }

    public String getLeaderContactInformation() {
        return leaderContactInformation;
    }

    public void setLeaderContactInformation(String leaderContactInformation) {
        this.leaderContactInformation = leaderContactInformation;
    }

    public String getIntegratedCode() {
        return integratedCode;
    }

    public void setIntegratedCode(String integratedCode) {
        this.integratedCode = integratedCode;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getContractorUnit() {
        return contractorUnit;
    }

    @ReferDeserialTransfer
    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public BigDecimal getControlPrice() {
        return controlPrice;
    }


    public void setControlPrice(BigDecimal controlPrice) {
        this.controlPrice = controlPrice;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getQualityAgreement() {
        return qualityAgreement;
    }

    @ReferDeserialTransfer
    public void setQualityAgreement(Long qualityAgreement) {
        this.qualityAgreement = qualityAgreement;
    }

    public String getProjectScale() {
        return projectScale;
    }

    public void setProjectScale(String projectScale) {
        this.projectScale = projectScale;
    }

    public String getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(String priceMethod) {
        this.priceMethod = priceMethod;
    }

    public BigDecimal getSelfConstructionContractAmount() {
        return selfConstructionContractAmount;
    }

    public void setSelfConstructionContractAmount(BigDecimal selfConstructionContractAmount) {
        this.selfConstructionContractAmount = selfConstructionContractAmount;
    }

    public BigDecimal getProjectBiddingProfit() {
        return projectBiddingProfit;
    }

    public void setProjectBiddingProfit(BigDecimal projectBiddingProfit) {
        this.projectBiddingProfit = projectBiddingProfit;
    }

    public String getConsortiumWonBid() {
        return consortiumWonBid;
    }

    public void setConsortiumWonBid(String consortiumWonBid) {
        this.consortiumWonBid = consortiumWonBid;
    }

    public String getInvestmentProject() {
        return investmentProject;
    }

    public void setInvestmentProject(String investmentProject) {
        this.investmentProject = investmentProject;
    }

    public BigDecimal getQuotaPriceDownwardRate() {
        return quotaPriceDownwardRate;
    }


    public void setQuotaPriceDownwardRate(BigDecimal quotaPriceDownwardRate) {
        this.quotaPriceDownwardRate = quotaPriceDownwardRate;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getBuild() {
        return build;
    }

    @ReferDeserialTransfer
    public void setBuild(Long build) {
        this.build = build;
    }

    public String getContractingType() {
        return contractingType;
    }

    public void setContractingType(String contractingType) {
        this.contractingType = contractingType;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getSignUnit() {
        return signUnit;
    }

    @ReferDeserialTransfer
    public void setSignUnit(Long signUnit) {
        this.signUnit = signUnit;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectCategory() {
        return projectCategory;
    }

    @ReferDeserialTransfer
    public void setProjectCategory(Long projectCategory) {
        this.projectCategory = projectCategory;
    }
    
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getSignStatus() {
        return signStatus;
    }

    @ReferDeserialTransfer
    public void setSignStatus(Long signStatus) {
        this.signStatus = signStatus;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getBiddingForm() {
        return biddingForm;
    }

    @ReferDeserialTransfer
    public void setBiddingForm(Long biddingForm) {
        this.biddingForm = biddingForm;
    }

    public Date getNotificationAwardDate() {
        return notificationAwardDate;
    }

    public void setNotificationAwardDate(Date notificationAwardDate) {
        this.notificationAwardDate = notificationAwardDate;
    }

    public String getProjectLocation() {
        return projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }

    public String getDurationDescription() {
        return durationDescription;
    }

    public void setDurationDescription(String durationDescription) {
        this.durationDescription = durationDescription;
    }

    public String getJobContent() {
        return jobContent;
    }

    public void setJobContent(String jobContent) {
        this.jobContent = jobContent;
    }

    public Date getActualEndDate() {
        return actualEndDate;
    }

    public void setActualEndDate(Date actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public String getSafeCivilizedConstructionRequirement() {
        return safeCivilizedConstructionRequirement;
    }

    public void setSafeCivilizedConstructionRequirement(String safeCivilizedConstructionRequirement) {
        this.safeCivilizedConstructionRequirement = safeCivilizedConstructionRequirement;
    }
 
    public String getPriceAdjustmentProcessTime() {
        return priceAdjustmentProcessTime;
    }

    /**
     * 认价或价格调整的流程与时间
     */
    public void setPriceAdjustmentProcessTime(String priceAdjustmentProcessTime) {
        this.priceAdjustmentProcessTime = priceAdjustmentProcessTime;
    }

	public List<ProjectPriceVO> getProjectPriceList() {
		return projectPriceList;
	}

	public void setProjectPriceList(List<ProjectPriceVO> projectPriceList) {
		this.projectPriceList = projectPriceList;
	}
	public BigDecimal getProjectBidWinPrice() {
		return projectBidWinPrice;
	}

	public void setProjectBidWinPrice(BigDecimal projectBidWinPrice) {
		this.projectBidWinPrice = projectBidWinPrice;
	}

	public BigDecimal getCivilEngineering() {
		return civilEngineering;
	}

	public void setCivilEngineering(BigDecimal civilEngineering) {
		this.civilEngineering = civilEngineering;
	}

	public BigDecimal getFix() {
		return fix;
	}

	public void setFix(BigDecimal fix) {
		this.fix = fix;
	}

	public BigDecimal getWaterSupplyDrainage() {
		return waterSupplyDrainage;
	}

	public void setWaterSupplyDrainage(BigDecimal waterSupplyDrainage) {
		this.waterSupplyDrainage = waterSupplyDrainage;
	}

	public BigDecimal getStrongCurrent() {
		return strongCurrent;
	}

	public void setStrongCurrent(BigDecimal strongCurrent) {
		this.strongCurrent = strongCurrent;
	}

	public BigDecimal getHeateVentilation() {
		return heateVentilation;
	}

	public void setHeateVentilation(BigDecimal heateVentilation) {
		this.heateVentilation = heateVentilation;
	}

	public BigDecimal getFixOther() {
		return fixOther;
	}

	public void setFixOther(BigDecimal fixOther) {
		this.fixOther = fixOther;
	}

	public BigDecimal getDecorate() {
		return decorate;
	}

	public void setDecorate(BigDecimal decorate) {
		this.decorate = decorate;
	}

	public BigDecimal getOther() {
		return other;
	}

	public void setOther(BigDecimal other) {
		this.other = other;
	}

	public BigDecimal getContractAmount() {
		return contractAmount;
	}

	public void setContractAmount(BigDecimal contractAmount) {
		this.contractAmount = contractAmount;
	}

	public String getBelong() {
		return belong;
	}

	public void setBelong(String belong) {
		this.belong = belong;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

    @ReferSerialTransfer(referCode="idm-org")
	public Long getOrgId() {
		return orgId;
	}

    @ReferDeserialTransfer
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getProjectDepartmentId() {
		return projectDepartmentId;
	}

	public void setProjectDepartmentId(Long projectDepartmentId) {
		this.projectDepartmentId = projectDepartmentId;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}

	public String getContractualModelName() {
		return contractualModelName;
	}

	public void setContractualModelName(String contractualModelName) {
		this.contractualModelName = contractualModelName;
	}

	public String getInvestmentSourceName() {
		return investmentSourceName;
	}

	public void setInvestmentSourceName(String investmentSourceName) {
		this.investmentSourceName = investmentSourceName;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public List<Map<String, Object>> getMembersList() {
		return membersList;
	}

	public void setMembersList(List<Map<String, Object>> membersList) {
		this.membersList = membersList;
	}

    @ReferSerialTransfer(referCode="support-defdoc")
	public Long getPromoterNature() {
		return promoterNature;
	}

    @ReferDeserialTransfer
	public void setPromoterNature(Long promoterNature) {
		this.promoterNature = promoterNature;
	}

	public String getPromoterNatureName() {
		return promoterNatureName;
	}

	public void setPromoterNatureName(String promoterNatureName) {
		this.promoterNatureName = promoterNatureName;
	}

	public String getPromoterSocialCreditCode() {
		return promoterSocialCreditCode;
	}

	public void setPromoterSocialCreditCode(String promoterSocialCreditCode) {
		this.promoterSocialCreditCode = promoterSocialCreditCode;
	}

	public String getPromoterAdress() {
		return promoterAdress;
	}

	public void setPromoterAdress(String promoterAdress) {
		this.promoterAdress = promoterAdress;
	}

	public String getPromoterLegal() {
		return promoterLegal;
	}

	public void setPromoterLegal(String promoterLegal) {
		this.promoterLegal = promoterLegal;
	}

	public String getPromoterTelephone() {
		return promoterTelephone;
	}

	public void setPromoterTelephone(String promoterTelephone) {
		this.promoterTelephone = promoterTelephone;
	}

	public String getProjectType() {
		return projectType;
	}

	public void setProjectType(String projectType) {
		this.projectType = projectType;
	}

	public String getProjectArea() {
		return projectArea;
	}

	public void setProjectArea(String projectArea) {
		this.projectArea = projectArea;
	}

    @ReferSerialTransfer(referCode="support-defdoc")
	public Long getProjectControlLevel() {
		return projectControlLevel;
	}

    @ReferDeserialTransfer
	public void setProjectControlLevel(Long projectControlLevel) {
		this.projectControlLevel = projectControlLevel;
	}

    public String getLat() {
        return lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLng() {
        return lng;
    }

    public void setLng(String lng) {
        this.lng = lng;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getBuiltAllArea() {
        return builtAllArea;
    }

    public void setBuiltAllArea(String builtAllArea) {
        this.builtAllArea = builtAllArea;
    }
}
