package com.ejianc.business.sync.api;

import com.ejianc.business.sync.hystrix.ZjwjSyncProjectHystrix;
import com.ejianc.business.sync.vo.SyncProjectRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

/**
 * 同步数据的rpc服务
 *
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-market-web", url="${common.env.feign-client-url}", path="ejc-market-web", fallback = ZjwjSyncProjectHystrix.class)
public interface IZjwjSyncProjectApi {


	/**
	 * 项目
	 *
	 * @param projectRegisterVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncProjectList")
	public CommonResponse<String> syncProjectList(List<SyncProjectRegisterVO> projectRegisterVOS);

}
