package com.ejianc.business.market.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.market.bean.ProjectVideoEntity;
import com.ejianc.business.market.service.IProjectVideoService;
import com.ejianc.business.market.vo.ProjectVideoVO;

/**
 * 项目视频
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectVideo")
public class ProjectVideoController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "POJECT_VIDEO_CODE";

    @Autowired
    private IProjectVideoService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectRegisterService projectRegisterService;


    /**
     * @description: BI 项目视频
     *
     * @param orgId 当前组织。不传默认登录组织
     * @param dateIn 年份 ： 例如 2023
     * all-全部、
     * 2023-2023年、
     * 2021-2021年、
     * 2020-2020年、
     * 2019-2019年
     * near4Year-近四年；
     * 默认今年
     * @param projectStatus
     * all-全部、
     * 1-未开工,
     * 2-在建，
     * 3-完成
     * 默认在建；
     * @return {@link CommonResponse< JSONObject>}
     * @author songlx
     * @date: 2023/4/24
     */
    @RequestMapping(value = "/getVideoList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProjectVideoVO>> getVideoList(@RequestParam(value = "orgId", required = false) Long orgId, @RequestParam(value = "dateIn", required = false) String dateIn, @RequestParam(value = "projectStatus", defaultValue = "2") String projectStatus) {
        Long _orgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        QueryParam queryParam = new QueryParam();
        List<Long> orgIds = orgApi.findChildrenByParentId(_orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, orgIds));
        //项目状态处理
        if (!"all".equals(projectStatus)) {
            queryParam.getParams().put("status", new Parameter(QueryParam.EQ, projectStatus));
        }

        if (StringUtils.isNotBlank(dateIn)) {
            if (dateIn.equals("near4Year")) {
                //查询近四年的数据
                queryParam.getParams().put("", new Parameter(QueryParam.SQL, " year(sign_date) >= year(now())-3"));
            } else if (!dateIn.equals("all")) {
                queryParam.getParams().put("", new Parameter(QueryParam.SQL, " year(sign_date) =", dateIn));
            }
        } else {
            //默认今年
            queryParam.getParams().put("", new Parameter(QueryParam.SQL, " year(sign_date) = year(now())"));
        }
        List<ProjectRegisterEntity> projectRegisterEntities = projectRegisterService.queryList(queryParam);
        List<Long> projectIds = projectRegisterEntities.stream().map(i -> i.getId()).collect(Collectors.toList());

        LambdaQueryWrapper<ProjectVideoEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(ProjectVideoEntity::getProjectId, projectIds);
        queryWrapper.and(t -> t.isNull(ProjectVideoEntity::getEnabled).or().eq(ProjectVideoEntity::getEnabled, 1));
        queryWrapper.orderByAsc(ProjectVideoEntity::getSequence);
        List<ProjectVideoEntity> list = service.list(queryWrapper);
        return CommonResponse.success(BeanMapper.mapList(list, ProjectVideoVO.class));
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectVideoVO> saveOrUpdate(@RequestBody ProjectVideoVO saveOrUpdateVO) {
        ProjectVideoEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectVideoEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        ProjectVideoVO vo = BeanMapper.map(entity, ProjectVideoVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectVideoVO> queryDetail(Long id) {
        ProjectVideoEntity entity = service.selectById(id);
        ProjectVideoVO vo = BeanMapper.map(entity, ProjectVideoVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectVideoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectVideoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProjectVideoVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectVideoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectVideoEntity> page = service.queryPage(param, false);
        IPage<ProjectVideoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectVideoVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectVideoEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectVideo-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProjectVideoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectVideoVO>> refProjectVideoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectVideoEntity> page = service.queryPage(param, false);
        IPage<ProjectVideoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectVideoVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
