package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnVO;
import com.ejianc.business.finance.api.IProjectBoardApi;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author mrsir_wxp
 * @Date 2021/3/19 移动项目看板
 * @Description StatisticsMobileController
 */

@Controller
@RequestMapping("/statistics/")
public class StatisticsMobileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectBoardApi iProjectBoardApi;

    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IProjectRegisterService projectRegisterService;

    /**
     * @Author mrsir_wxp
     * @Date 2021/3/22
     * @Description queryProjectViewBoardList 查询移动端项目看板列表
     * @param queryParam
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryProjectViewBoardList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryProjectViewBoardList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        //只查询启用的项目
        queryParam.getParams().put("validStatus", new Parameter(QueryParam.EQ, '0'));
        //租户过滤
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        Long current = System.currentTimeMillis();
        /** 经产品确认，不再进行个人权限过滤，查询整个租户项目数据 相关代码已移除 2022年6月22日12:00*/
        IPage<ProjectRegisterEntity> pageData = projectRegisterService.queryPage(queryParam,false);
        logger.info("queryPage cost :{}",System.currentTimeMillis()-current);
        IPage<JSONObject> result = new Page<>();
        if(pageData.getTotal()>0){
            List<JSONObject> rec = new ArrayList();
            for (int i = 0; i < pageData.getRecords().size(); i++) {
                ProjectRegisterEntity entity = pageData.getRecords().get(i);
                current = System.currentTimeMillis();
                CommonResponse<Integer> response1 =  warnCenterApi.queryProjectWarnNumByOrgId(entity.getProjectDepartmentId());
                logger.info("queryProjectWarnNumByOrgId cost :{}",System.currentTimeMillis()-current);
                current = System.currentTimeMillis();
                CommonResponse<JSONObject> response2 =  iProjectBoardApi.queryPayAndReceiveByProjectId(entity.getId());
                logger.info("iProjectBoardApi.queryPayAndReceiveByProjectId cost :{}",System.currentTimeMillis()-current);
                JSONObject payAndReceive = response2.getData();
                JSONObject p = new JSONObject();
                p.put("id",entity.getId());
                p.put("name",entity.getName());
                p.put("status",entity.getStatus());
                p.put("type",entity.getType());
                p.put("signDate",entity.getSignDate()==null?"": DateFormatUtil.formatDate("yyyy-MM-dd",entity.getSignDate()));
                if(response2.isSuccess()){
                    p.put("receiveMoney",payAndReceive.getBigDecimal("receiveMoney"));
                    p.put("payMoney",payAndReceive.getBigDecimal("payMoney"));
                    p.put("contractMoney",payAndReceive.getBigDecimal("contractMoney"));
                }else {
                    p.put("receiveMoney","0.00");
                    p.put("payMoney","0.00");
                    p.put("contractMoney","0.00");
                }
                if(response1.isSuccess()){
                    p.put("warnNum",response1.getData());
                }else {
                    p.put("warnNum","0");
                }
                rec.add(p);
            }
            result.setRecords(rec);
            result.setPages(pageData.getPages());
            result.setTotal(pageData.getTotal());
            result.setSize(pageData.getSize());
            result.setCurrent(pageData.getCurrent());
        }
        return CommonResponse.success(result);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/4/9
     * @Description queryCostByProjectId 移动端项目看板 根据项目id，查询项目成本数据
     * @param projectId
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryCostByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryCostByProjectId(@RequestParam("projectId") Long projectId) {
        return iProjectBoardApi.queryCostByProjectId(projectId);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/4/9
     * @Description queryCostByProjectId 移动端项目看板 根据项目id，项目资金数据
     * @param projectId
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryReceiveInfoByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryReceiveInfoByProjectId(@RequestParam("projectId") Long projectId) {
        return iProjectBoardApi.queryReceiveInfoByProjectId(projectId);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/4/9
     * @Description queryDetailByProjectId 移动端项目看板 根据项目id，查询项目基本信息
     * @param projectId
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetailByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailByProjectId(@RequestParam("projectId") Long projectId) {
        JSONObject respJSONObject = new JSONObject();
        ProjectRegisterVO resp = BeanMapper.map(projectRegisterService.queryById(projectId), ProjectRegisterVO.class);
        //查询项目成员
        CommonResponse<List<Map<String, Object>>>  membersResp = userApi.getEmployeeList(resp.getProjectDepartmentId());
        if(membersResp.isSuccess()) {
            List<Map<String, Object>> trueMembers = new ArrayList<>();
            List<Map<String, Object>> toProcess = membersResp.getData();
            Map<String,Map<String, Object>> mem = new HashMap<>();
            Map<String,List<String>> roles = new HashMap<>();
            for (int i = 0; i < toProcess.size(); i++) {
                Map<String, Object> o = toProcess.get(i);
                if(o.get("state")!=null && "1".equals(o.get("state").toString())){
                    mem.put(o.get("employeeId").toString(),o);
                    List<String> role = roles.get(o.get("employeeId").toString());
                    if(ListUtil.isEmpty(role)){
                        role = new ArrayList<>();
                        roles.put(o.get("employeeId").toString(),role);
                    }
                    if(o.get("roleName")!=null){
                        String[] list =  o.get("roleName").toString().split(",");
                        for (int j = 0; j < list.length; j++) {
                            if(!role.contains(list[j])){
                                role.add(list[j]);
                            }
                        }
                    }
                }
            }
            for (int i = 0; i < toProcess.size(); i++) {
                Map<String, Object> o = toProcess.get(i);
                if(o.get("state")!=null && "1".equals(o.get("state").toString())) {
                    List<String> role = roles.get(o.get("employeeId").toString());
                    if (null != o.get("roleName")) {
                        String[] list = o.get("roleName").toString().split(",");
                        for (int j = 0; j < list.length; j++) {
                            if (!role.contains(list[j])) {
                                role.add(list[j]);
                            }
                        }
                    }
                }
            }

            for (String key:mem.keySet()){
                Map<String, Object> member = mem.get(key);
                member.put("roleName",roles.get(key));
                trueMembers.add(member);
            }
            resp.setMembersList(trueMembers);
        }else {
            resp.setMembersList(new ArrayList<>());
        }
        respJSONObject.put("projectInfo",resp);
        CommonResponse<List<EarlyWarnVO>> response =  warnCenterApi.queryProjectWarnListByOrgId(resp.getProjectDepartmentId());
        if(response.isSuccess()) {
            respJSONObject.put("warnNum",response.getData().size());
            respJSONObject.put("warnContent",response.getData().stream().map(EarlyWarnVO::getEarlywarnContent).collect(Collectors.toList()));
        }else {
            respJSONObject.put("warnNum",0);
            respJSONObject.put("warnContent",new ArrayList<>());
        }

        return CommonResponse.success(respJSONObject);
    }

}
