package com.ejianc.business.market.service.impl;

import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("businessOpportunity")
public class BusinessOpportunityBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IBusinessOpportunityService businessOpportunityService;
	@Autowired
	private IPushMessageApi pushMessageApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		BusinessOpportunityEntity entity = businessOpportunityService.selectById(billId);
		if (StringUtils.isNotBlank(entity.getFollowPerson())) {
			PushMsgParameter parameter = new PushMsgParameter();
			List<String> channel = new ArrayList<>();
			channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
			String[] receivers = entity.getFollowPerson().split(",");
			parameter.setReceivers(receivers);// 收信人
			parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
			parameter.setMsgType("notice");
			parameter.setSubject("商机登记生效提醒");// 标题
			parameter.setContent("您好，您有一个项目（" + entity.getEngineeringName() + "）需要报名");// 内容
			parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
			parameter.setSendUserId(InvocationInfoProxy.getUserid());

			try {
				CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
				if (result.isSuccess()) {
					logger.error("消息发送成功---------------->" + result.getMsg());
				} else {
					logger.error("消息发送失败---------------->" + result.getMsg());
				}
			} catch (Exception e) {
				logger.error("调用消息中心RPC服务异常--------------" + e);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		BusinessOpportunityEntity entity = businessOpportunityService.selectById(billId);
		CommonResponse<String> checkCommonResponse = billTypeApi.checkQuote(billTypeCode, entity.getId());
		boolean success = checkCommonResponse.isSuccess();
		if (!success){
			return CommonResponse.error("已经被中标结果分析使用,不能弃审和撤回");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

}
