package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.consts.ProjectBusinessStatusEnum;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.bean.StopWorkReportEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.service.IStopWorkReportService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("stopWorkReport") 
public class StopWorkReportBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IStopWorkReportService stopWorkReportService;

	@Autowired
	private IProjectRegisterService projectRegisterService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.error("该单据不支持弃审和撤回");
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		StopWorkReportEntity entity = stopWorkReportService.selectById(billId);
		Long projectId = entity.getProjectId();
		// 项目改为停工状态
		ProjectRegisterEntity registerEntity = projectRegisterService.getById(projectId);
		LambdaUpdateWrapper<ProjectRegisterEntity> updateWrapper = Wrappers.lambdaUpdate();
		updateWrapper.eq(ProjectRegisterEntity::getId, projectId);
		updateWrapper.set(ProjectRegisterEntity::getStatus, ProjectBusinessStatusEnum.停工.getBusinessStatus());
		projectRegisterService.update(updateWrapper);

		// 记录项目停工前的状态
		LambdaUpdateWrapper<StopWorkReportEntity> stopWorkReportEntityLambdaUpdateWrapper = Wrappers.lambdaUpdate();
		stopWorkReportEntityLambdaUpdateWrapper.eq(StopWorkReportEntity::getId, billId);
		stopWorkReportEntityLambdaUpdateWrapper.set(StopWorkReportEntity::getBeforeProjectStatus, registerEntity.getStatus());
		stopWorkReportService.update(stopWorkReportEntityLambdaUpdateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不支持弃审和撤回");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
