package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.market.vo.ProjectUnpaidUncollectWarnVo;
import com.ejianc.business.market.vo.SqlParam;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/projectPayWarn/")
public class ProjectWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL_PROJECT = "/ejc-report-frontend/#/proPeportDetail?id=";
    private final static String INDEX_NAME_PROJECT_FINANCE = "project_finance";

    private final static Integer QUERY_TIMEOUT = 60;
    private final static Integer BATCH_SIZE = 1000;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired(required = false)
    private RestHighLevelClient client;



    /**
     *以项目维度，【项目未付金额（支出合同总额-合同已付款）】大于等于 【项目可用资金】+【施工合同未收款（施工合同金额-收款登记金额）*X%
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "projectMnyWarn")
    public CommonResponse<String> outIncomeMnyWarn(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if (StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            return CommonResponse.error("获取有效的租户Id列表失败！");
        }
        List<Long> tenantIds = tenantResp.getData();
        if (CollectionUtils.isEmpty(tenantIds)) {
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //1.去掉停用的预警对应的租户Id（不用任何处理）
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        //2.再去掉自定义租户ID，走自定义的预警条件
        List<SqlParam> sqlParamList = new ArrayList<>();
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        //3.除了忽略和自定义，其他都走默认预警条件
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue() / 100d);
                sqlParamList.add(p);
            }
        }
        List<Long> tids = sqlParamList.stream().map(SqlParam::getTenantId).collect(Collectors.toList());
        List<ProjectUnpaidUncollectWarnVo> list = new ArrayList<>();//返回的结果
        //查询项目统计的条数
        Long resultSize = queryIndexSize(INDEX_NAME_PROJECT_FINANCE, tids);
            SearchRequest searchRequest = new SearchRequest(INDEX_NAME_PROJECT_FINANCE);
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.must(QueryBuilders.termsQuery("tenantId", tids));
            sourceBuilder.query(boolQuery);
            sourceBuilder.size(resultSize.intValue());
            sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
            searchRequest.source(sourceBuilder);
            SearchResponse response = null;
            try {
                response = client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                for (SearchHit hit : hits) {
                    String sourceAsString = hit.getSourceAsString();
                    list.add(JSON.parseObject(sourceAsString, ProjectUnpaidUncollectWarnVo.class));
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        if (CollectionUtils.isEmpty(list)) {
            logger.error("查询ES项目的信息为空！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //分租户
        Map<Long, SqlParam> tenantMap = new HashMap<>();
        for (SqlParam sqlVo : sqlParamList) {
            tenantMap.put(sqlVo.getTenantId(), sqlVo);
        }
        List<ProjectUnpaidUncollectWarnVo> resultList = new ArrayList<>();
        for (ProjectUnpaidUncollectWarnVo vo : list) {
            SqlParam sqlParam = tenantMap.get(vo.getTenantId());
            BigDecimal ratio = new BigDecimal(sqlParam.getValue());
            //合同未收款金额
            BigDecimal hetongweishoukuanjine = vo.getHetongweishoukuanjine();
            // 合同未付款款金额
            BigDecimal hetongweifukuanjine = vo.getHetongweifukuanjine();
            //可用金额
            BigDecimal xiangmukeyongzijin = vo.getXiangmukeyongzijin();
            //【项目未付款额】大于【项目可用资金+施工合同未收款额】
            BigDecimal ratioTaxMny = ComputeUtil.safeMultiply(ComputeUtil.safeAdd(hetongweishoukuanjine, xiangmukeyongzijin), ratio);
            boolean greaterThan = ComputeUtil.isGreaterThan(hetongweifukuanjine, ratioTaxMny);
            if (greaterThan){
                vo.setHetongweifukuanjine(hetongweifukuanjine);
                vo.setHetongweishoukuanjine(hetongweishoukuanjine);
                vo.setXiangmukeyongzijin(xiangmukeyongzijin);
                vo.setPercent(sqlParam.getValue());
                vo.setRatioTaxMny(ratioTaxMny);
                vo.setOrgName(vo.getName());
                vo.setWarnLevel(sqlParam.getWarnLevel());
                resultList.add(vo);
            }
        }
        logger.info("推送数据为"+JSONObject.toJSONString(resultList));
        if (CollectionUtils.isEmpty(resultList)){
            logger.info("推送数据为空");
        }
        return sendWarnToTask(payTransToWarnVO2(resultList, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }


    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    public static void main(String[] args) {
        Long deleteTimes = 2002L;
        int i1 = deleteTimes.intValue();
        Long i = 2002L % BATCH_SIZE;
        System.out.println(deleteTimes);
        System.out.println(i);
    }


    private BigDecimal getBigDecimal(Object obj) {
        return null == obj ? BigDecimal.ZERO : new BigDecimal(obj.toString());
    }


    private List<EarlyWarnTransVO> payTransToWarnVO2(List<ProjectUnpaidUncollectWarnVo> result, JSONObject defaultWarnInfo) {
        logger.debug("以项目维度，【项目未付金额（支出合同总额-合同已付款）】大于等于 【项目可用资金】+【施工合同未收款（施工合同金额-收款登记金额）*X%预警完成，发送预警！");
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (ProjectUnpaidUncollectWarnVo m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "") + m.getProjectCode());
            vo.setPcTitle("项目未付款金额大于等于项目可用资金+施工合同未收款");
            vo.setPcUrl(PC_URL_PROJECT + m.getProjectId()+"&orgId="+m.getOrgId());
            vo.setOrgId(Long.valueOf(m.getProjectDepartmentId()));
            vo.setOrgName(m.getName());
            vo.setSourceId(m.getProjectId().toString());
            vo.setTenantId(Long.valueOf(m.getTenantId().toString()));
            vo.setWarnLevel(m.getWarnLevel());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            m.setPercent(m.getPercent() * 100);
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#projectName#", m.getName())
                            .replaceAll("#hetongweishoukuanjine#", df.format(getBigDecimal(m.getHetongweishoukuanjine())))
                            .replaceAll("#percent#", m.getPercent().toString())
                            .replaceAll("#hetongweifukuanjine#", df.format(getBigDecimal(m.getHetongweifukuanjine())))
                            .replaceAll("#xiangmukeyongzijin#", df.format(getBigDecimal(m.getXiangmukeyongzijin())))
                            .replaceAll("#ratioTaxMny#", df.format(getBigDecimal(m.getRatioTaxMny())))
            );
            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }

    private Long queryIndexSize(String indexName,List<Long> tids) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(indexName);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        // 查询参数
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must(QueryBuilders.termsQuery("tenantId", tids));

        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); // 设置超时时间

        searchRequest.source(sourceBuilder);

        try {
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            resultSize = hits.getTotalHits().value;
        } catch (IOException e) {
            try { //  重试一次
                SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                resultSize = hits.getTotalHits().value;
            } catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e1.getMessage());
            }
        }
        return resultSize;
    }
}
