package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.bean.ResumeWorkReportEntity;
import com.ejianc.business.market.mapper.ResumeWorkReportMapper;
import com.ejianc.business.market.service.IResumeWorkReportService;
import com.ejianc.business.market.vo.ResumeWorkReportVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 复工报告
 * 
 * @author generator
 * 
 */
@Service("resumeWorkReportService")
public class ResumeWorkReportServiceImpl extends BaseServiceImpl<ResumeWorkReportMapper, ResumeWorkReportEntity> implements IResumeWorkReportService{

    @Autowired
    private ResumeWorkReportMapper resumeWorkReportMapper;

    @Override
    public ResumeWorkReportVO queryByProjectId(Long projectId) {
        ResumeWorkReportVO resp = null;
        QueryWrapper<ResumeWorkReportEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        ResumeWorkReportEntity entity = resumeWorkReportMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity,ResumeWorkReportVO.class);
        }
        return resp;
    }
}
