package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.bean.StopWorkReportEntity;
import com.ejianc.business.market.mapper.StopWorkReportMapper;
import com.ejianc.business.market.service.IStopWorkReportService;
import com.ejianc.business.market.vo.StopWorkReportVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 停工报告
 * 
 * @author generator
 * 
 */
@Service("stopWorkReportService")
public class StopWorkReportServiceImpl extends BaseServiceImpl<StopWorkReportMapper, StopWorkReportEntity> implements IStopWorkReportService{

    @Autowired
    private StopWorkReportMapper stopWorkReportMapper;

    @Override
    public StopWorkReportVO queryByProjectId(Long projectId) {
        StopWorkReportVO resp = null;
        QueryWrapper<StopWorkReportEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        StopWorkReportEntity entity = stopWorkReportMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, StopWorkReportVO.class);
        }
        return resp;
    }
}
