package com.ejianc.business.market.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目登记
 */
@TableName("ejc_market_project")
public class ProjectRegisterEntity extends BaseEntity {

    private static final long serialVersionUID = -7103485558232569473L;

    /**
     * 项目编号
     */
    @TableField(value = "code")
    private String code;

    /**
     * 项目名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 所属组织
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部Id
     */
    @TableField(value = "project_department_id")
    private Long projectDepartmentId;

    /**
     * 项目状态：1-未开工, 2-在建，3-完成
     */
    @TableField(value = "status")
    private String status;

    /**
     * 项目状态：0-启用，1-停用
     */
    @TableField(value = "valid_status")
    private String validStatus;

    /**
     * 项目类型：1-自营，2-联营
     */
    @TableField(value = "type")
    private String type;

    /**
     * 管理费: 联营时展示，自营时不展示
     *
     */
    @TableField(value = "manage_charge_ratio")
    private Double manageChargeRatio;

    /**
     * 承包模式
     * 1-施工总承包，2-工程总承包，3-EPC承包，4-精细化分包，5-扩大劳务分包，6-其他
     *
     */
    @TableField(value = "contractual_model")
    private Long contractualModel;

    /**
     * 发包单位
     */
    @TableField(value = "pub_unit")
    private Long pubUnit;

    /**
     * 承包单位
     */
    @TableField(value = "contractor_unit")
    private Long contractorUnit;

    /**
     * 项目地区
     */
    @TableField(value = "area")
    private String area;

    /**
     * 详细地址
     */
    @TableField(value = "address")
    private String address;

    /**
     * 投资主体
     */
    @TableField(value = "investor")
    private Long investor;

    /**
     * 资金来源
     */
    @TableField(value = "funds_source")
    private String fundsSource;

    /**
     * 总造价(万元)
     */
    @TableField(value = "cost_total")
    private BigDecimal costTotal;

    /**
     * 招标形式
     */
    @TableField(value = "bidding_from")
    private Long biddingForm;


    /**
     * 计划开工日期
     */
    @TableField(value = "planned_commencement_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedCommencementDate;

    /**
     * 计划竣工日期
     */
    @TableField(value = "planned_finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate;

    /**
     * 建筑面积(㎡)
     */
    @TableField(value = "built_area")
    private BigDecimal builtArea;

    /**
     * 结构类型
     */
    @TableField(value = "structure_type")
    private Long structureType;

    /**
     * 工程用途
     */
    @TableField(value = "engineering_purpose")
    private Long engineeringPurpose;

    /**
     * 工程概况
     */
    @TableField(value = "project_overview")
    private String projectOverview;

    /**
     * 冗余所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 冗余承包单位名称
     */
    @TableField(value = "contractor_unit_name")
    private String contractorUnitName;

    /**
     * 冗余发包单位名称
     */
    @TableField(value = "pub_unit_name")
    private String pubUnitName;

    /**
     * 承包模式
     */
    @TableField(value = "contractual_model_name")
    private String contractualModelName;

    /**
     * 投资主体
     */
    @TableField(value = "investor_name")
    private String investorName;

    /**
     * 招标形式
     */
    @TableField(value = "bidding_form_name")
    private String biddingFormName;

    /**
     * 结构类型
     */
    @TableField(value = "structure_type_name")
    private String structureTypeName;
    /**
     * 工程用途
     */
    @TableField("engineering_purpose_name")
    private String engineeringPurposeName;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    //数据同步字段
    /**
     * 数据在第三方系统中主键值
     */
    @TableField(value = "source_id")
    private String sourceId;
    /**
     * 数据来源系统Id
     */
    @TableField(value = "system_id")
    private String systemId;

    /**
     * 签订日期
     */
    @TableField(value = "sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 项目经理
     */
    @TableField(value = "project_manager")
    private Long projectManager;

    /**
     * 项目经理名称
     */
    @TableField(value = "project_manager_name")
    private String projectManagerName;

    /**
     * 工程类型
     */
    @TableField(value = "engineering_type")
    private Long engineeringType;

    /**
     * 工程类型名称
     */
    @TableField(value = "engineering_type_name")
    private String engineeringTypeName;

    /**
     * 省份
     */
    @TableField(value = "province")
    private String province;

    /**
     * 市区
     */
    @TableField(value = "city")
    private String city;

    /**
     * 区县
     */
    @TableField(value = "region")
    private String region;

    /**
     * 是否使用材料核销
     */
    @TableField(value = "material_verification")
    private Boolean materialVerification;

    /**
     * 关注类型 0-普通项目 1-工程局重点关注 2-工程局重点监控 3-二级单位重点关注 4-二级单位重点监控
     */
    @TableField(value = "focus_type")
    private String focusType;

    @TableField(value="area_id")
    private Long areaId; // 区域id
    @TableField(value="area_code")
    private String areaCode; // 区域编码
    @TableField(value="area_name")
    private String areaName; // 区域名称
    @TableField(value="measurement_certificate")
    private java.lang.Integer measurementCertificate; // 是否有计量证书(0. 否 1. 是）
    @TableField(value="main_org_id")
    private java.lang.Long mainOrgId; // 开票主体
    @TableField(value="main_org_name")
    private java.lang.String mainOrgName; // 开票主体名称
    @TableField(value="invoice_main_category")
    private java.lang.Integer invoiceMainCategory; // 开票主体分类(0-以集团名义开票 1-以区域分公司名义开票)
    @TableField(value="tax_way")
    private java.lang.Integer taxWay; // 计税方式(0-一般计税 1-简易计税)
    @TableField("excute_construct_state")
    private String excuteConstructState;// 是否执行建造合同 0-否，1-是
    @TableField("industry_integration_flag")
    private String industryIntegrationFlag;// 是否启用业财一体化 0-否，1-是
    @TableField(value="dept_id")
    private String deptId; // 财务核算部门
    @TableField(value="dept_name")
    private String deptName; // 财务核算部门名称
    @TableField(value="provinces")
    private java.lang.String provinces; // 省市区
    @TableField(value="duty_org_id")
    private java.lang.Long dutyOrgId; // 责任单位id
    @TableField(value="duty_org_name")
    private java.lang.String dutyOrgName; // 责任单位名称
    @TableField(value="deputy_unit")
    private java.lang.String deputyUnit; // 代建单位
    @TableField(value="design_unit")
    private java.lang.String designUnit; // 设计单位
    @TableField(value="supervisor_unit")
    private java.lang.String supervisorUnit; // 监理单位
    @TableField(value="audit_unit")
    private java.lang.String auditUnit; // 审计单位
    @TableField(value="bid_project_name")
    private java.lang.String bidProjectName; // 中标告知单名称
    @TableField(value="bid_project_id")
    private java.lang.Long bidProjectId; // 中标告知单
    @TableField(value="bid_bill_code")
    private java.lang.String bidBillCode; // 中标告知单编号
    @TableField(value="project_status")
    private java.lang.String projectStatus;//工程状态 0-未开工，1-在建，2-完工未验收，3-完工验收，4-已验收未结算，5-已结算
    @TableField(exist=false)
    @SubEntity(serviceName="mainOrgRecordService",pidName = "marketProjectId")
    private List<MainOrgRecordEntity> mainOrgRecordEntities = new ArrayList<>(); // 开票主体记录
    @TableField(value="is_send_mbs")
    private String isSendMbs;//是否推送业资一体
    
    @TableField(value="mbs_dept")
    private String mbsDept;//资金系统组织
    
    @TableField(value="is_important")
    private String isImportant;//是否重要项目
    
    @TableField(value = "end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;//工程状态时间
    
    @TableField(value="wy_settle_type")
    private Long wySettleType;//网银类结算方式
    
    @TableField(value="wy_settle_code")
    private String wySettleCode;//网银类结算方式编码
    

    public Long getWySettleType() {
		return wySettleType;
	}

	public void setWySettleType(Long wySettleType) {
		this.wySettleType = wySettleType;
	}

	public String getWySettleCode() {
		return wySettleCode;
	}

	public void setWySettleCode(String wySettleCode) {
		this.wySettleCode = wySettleCode;
	}

	public String getMbsDept() {
		return mbsDept;
	}

	public void setMbsDept(String mbsDept) {
		this.mbsDept = mbsDept;
	}

	public String getIsSendMbs() {
		return isSendMbs;
	}

	public void setIsSendMbs(String isSendMbs) {
		this.isSendMbs = isSendMbs;
	}

	public String getDeptId() {
        return deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getFocusType() {
        return focusType;
    }

    public void setFocusType(String focusType) {
        this.focusType = focusType;
    }

    public Boolean getMaterialVerification() {
        return materialVerification;
    }

    public void setMaterialVerification(Boolean materialVerification) {
        this.materialVerification = materialVerification;
    }

    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Double getManageChargeRatio() {
        return manageChargeRatio;
    }

    public void setManageChargeRatio(Double manageChargeRatio) {
        this.manageChargeRatio = manageChargeRatio;
    }

    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }

    public Long getPubUnit() {
        return pubUnit;
    }

    public void setPubUnit(Long pubUnit) {
        this.pubUnit = pubUnit;
    }

    public Long getContractorUnit() {
        return contractorUnit;
    }

    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getInvestor() {
        return investor;
    }

    public void setInvestor(Long investor) {
        this.investor = investor;
    }

    public String getFundsSource() {
        return fundsSource;
    }

    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }

    public BigDecimal getCostTotal() {
        return costTotal;
    }

    public void setCostTotal(BigDecimal costTotal) {
        this.costTotal = costTotal;
    }

    public Long getBiddingForm() {
        return biddingForm;
    }

    public void setBiddingForm(Long biddingForm) {
        this.biddingForm = biddingForm;
    }

    public Date getPlannedCommencementDate() {
        return plannedCommencementDate;
    }

    public void setPlannedCommencementDate(Date plannedCommencementDate) {
        this.plannedCommencementDate = plannedCommencementDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public Long getStructureType() {
        return structureType;
    }

    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }

    public Long getEngineeringPurpose() {
        return engineeringPurpose;
    }

    public void setEngineeringPurpose(Long engineeringPurpose) {
        this.engineeringPurpose = engineeringPurpose;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getValidStatus() {
        return validStatus;
    }

    public void setValidStatus(String validStatus) {
        this.validStatus = validStatus;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getPubUnitName() {
        return pubUnitName;
    }

    public void setPubUnitName(String pubUnitName) {
        this.pubUnitName = pubUnitName;
    }

    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }

    public String getInvestorName() {
        return investorName;
    }

    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    public String getBiddingFormName() {
        return biddingFormName;
    }

    public void setBiddingFormName(String biddingFormName) {
        this.biddingFormName = biddingFormName;
    }

    public String getStructureTypeName() {
        return structureTypeName;
    }

    public void setStructureTypeName(String structureTypeName) {
        this.structureTypeName = structureTypeName;
    }

    public String getEngineeringPurposeName() {
        return engineeringPurposeName;
    }

    public void setEngineeringPurposeName(String engineeringPurposeName) {
        this.engineeringPurposeName = engineeringPurposeName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
    /**
     * 是否有计量证书(0. 否 1. 是）
     */
    public java.lang.Integer getMeasurementCertificate() {
        return measurementCertificate;
    }

    /**
     * 是否有计量证书(0. 否 1. 是）
     */
    public void setMeasurementCertificate(java.lang.Integer measurementCertificate) {
        this.measurementCertificate = measurementCertificate;
    }
    /**
     * 开票主体
     */
    public java.lang.Long getMainOrgId() {
        return mainOrgId;
    }

    /**
     * 开票主体
     */
    public void setMainOrgId(java.lang.Long mainOrgId) {
        this.mainOrgId = mainOrgId;
    }
    /**
     * 开票主体名称
     */
    public java.lang.String getMainOrgName() {
        return mainOrgName;
    }

    /**
     * 开票主体名称
     */
    public void setMainOrgName(java.lang.String mainOrgName) {
        this.mainOrgName = mainOrgName;
    }
    /**
     * 开票主体分类(0-以集团名义开票 1-以区域分公司名义开票)
     */
    public java.lang.Integer getInvoiceMainCategory() {
        return invoiceMainCategory;
    }

    /**
     * 开票主体分类(0-以集团名义开票 1-以区域分公司名义开票)
     */
    public void setInvoiceMainCategory(java.lang.Integer invoiceMainCategory) {
        this.invoiceMainCategory = invoiceMainCategory;
    }
    /**
     * 计税方式(0-一般计税 1-简易计税)
     */
    public java.lang.Integer getTaxWay() {
        return taxWay;
    }

    /**
     * 计税方式(0-一般计税 1-简易计税)
     */
    public void setTaxWay(java.lang.Integer taxWay) {
        this.taxWay = taxWay;
    }

    public String getExcuteConstructState() {
        return excuteConstructState;
    }

    public void setExcuteConstructState(String excuteConstructState) {
        this.excuteConstructState = excuteConstructState;
    }

    public String getIndustryIntegrationFlag() {
        return industryIntegrationFlag;
    }

    public void setIndustryIntegrationFlag(String industryIntegrationFlag) {
        this.industryIntegrationFlag = industryIntegrationFlag;
    }

    /**
     * 开票主体记录
     */
    public List<MainOrgRecordEntity> getMainOrgRecordEntities() {
        return mainOrgRecordEntities;
    }

    /**
     * 开票主体记录
     */
    public void setMainOrgRecordEntities(List<MainOrgRecordEntity> mainOrgRecordEntities) {
        this.mainOrgRecordEntities = mainOrgRecordEntities;
    }

    public String getProvinces() {
        return provinces;
    }

    public void setProvinces(String provinces) {
        this.provinces = provinces;
    }

    public Long getDutyOrgId() {
        return dutyOrgId;
    }

    public void setDutyOrgId(Long dutyOrgId) {
        this.dutyOrgId = dutyOrgId;
    }

    public String getDutyOrgName() {
        return dutyOrgName;
    }

    public void setDutyOrgName(String dutyOrgName) {
        this.dutyOrgName = dutyOrgName;
    }

    public String getDeputyUnit() {
        return deputyUnit;
    }

    public void setDeputyUnit(String deputyUnit) {
        this.deputyUnit = deputyUnit;
    }

    public String getDesignUnit() {
        return designUnit;
    }

    public void setDesignUnit(String designUnit) {
        this.designUnit = designUnit;
    }

    public String getSupervisorUnit() {
        return supervisorUnit;
    }

    public void setSupervisorUnit(String supervisorUnit) {
        this.supervisorUnit = supervisorUnit;
    }

    public String getAuditUnit() {
        return auditUnit;
    }

    public void setAuditUnit(String auditUnit) {
        this.auditUnit = auditUnit;
    }

    public String getBidProjectName() {
        return bidProjectName;
    }

    public void setBidProjectName(String bidProjectName) {
        this.bidProjectName = bidProjectName;
    }

    public Long getBidProjectId() {
        return bidProjectId;
    }

    public void setBidProjectId(Long bidProjectId) {
        this.bidProjectId = bidProjectId;
    }

    public String getBidBillCode() {
        return bidBillCode;
    }

    public void setBidBillCode(String bidBillCode) {
        this.bidBillCode = bidBillCode;
    }

	public java.lang.String getProjectStatus() {
		return projectStatus;
	}

	public void setProjectStatus(java.lang.String projectStatus) {
		this.projectStatus = projectStatus;
	}

	public String getIsImportant() {
		return isImportant;
	}

	public void setIsImportant(String isImportant) {
		this.isImportant = isImportant;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
    
}
