package com.ejianc.business.market.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.ejianc.framework.auth.session.SessionManager;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.market.bean.ProjectPlanEntity;
import com.ejianc.business.market.service.IProjectPlanService;
import com.ejianc.business.market.vo.ProjectPlanVO;

/**
 * 项目策划单实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("projectPlan")
public class ProjectPlanController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;

    private static final String BILL_CODE = "Project_Plan_Code";//此处需要根据实际修改
    
    @Autowired
    private IProjectPlanService service;

    @Autowired private SessionManager sessionManager;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectPlanVO> saveOrUpdate(@RequestBody ProjectPlanVO saveorUpdateVO) {
    	ProjectPlanEntity entity = BeanMapper.map(saveorUpdateVO, ProjectPlanEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (entity.getStatus() == null){
            entity.setStatus("否");
        }

    	service.saveOrUpdate(entity, false);
    	ProjectPlanVO vo = BeanMapper.map(entity, ProjectPlanVO.class);
        if (saveorUpdateVO.getOldId()!=null){
            ProjectPlanEntity oldEntity = service.selectById(saveorUpdateVO.getOldId());
            oldEntity.setStatus("是");
            if(oldEntity.getNewId()==null){
                oldEntity.setNewId(vo.getId());
            }
            service.saveOrUpdate(oldEntity,false);
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 根据项目主键，查询是否有非生效单据
     * @param projectId
     * @return
     */
    @GetMapping(value = "/getValidate")
    @ResponseBody
    public CommonResponse<List> getValidate(@RequestParam(value = "id", required = false) Long id,@RequestParam(value = "projectId") Long projectId) {
        LambdaQueryWrapper<ProjectPlanEntity> query = new LambdaQueryWrapper<>();
        // 编辑过滤自身
        if(id != null){
            query.ne(ProjectPlanEntity::getId,id);
        }
        // 校验相同项目下是否已存在自由态或审批中
        query.eq(ProjectPlanEntity::getProjectId, projectId);
        query.in(ProjectPlanEntity::getBillState,0,2,5);
        query.eq(ProjectPlanEntity::getDr,0);
        List<ProjectPlanEntity> entities =  service.list(query);
        if (CollectionUtils.isNotEmpty(entities)){
            throw new BusinessException("一个项目只能存在一个自由态或审批中的单据！");
        }else {
            LambdaQueryWrapper<ProjectPlanEntity> query1 = new LambdaQueryWrapper<>();
            query1.eq(ProjectPlanEntity::getProjectId, projectId);
            query1.in(ProjectPlanEntity::getBillState,1,3);
            query1.eq(ProjectPlanEntity::getDr,0);
            List<ProjectPlanEntity> entities1 =  service.list(query1);
            for (int i = 0; i < entities1.size(); i++){
                ProjectPlanEntity entities2 = entities1.get(i);
                if (entities1.get(i).getPlanSummary().equals("竣工总结") ) {
                    throw new BusinessException("该项目已竣工！");
                }
                if (entities2.getPlanSummary().equals("一月")){
                    entities2.setPlanSummary("1");
                }else if (entities2.getPlanSummary().equals("二月")){
                    entities2.setPlanSummary("2");
                }else if (entities2.getPlanSummary().equals("三月(一季度)")){
                    entities2.setPlanSummary("3");
                }else if (entities2.getPlanSummary().equals("四月")){
                    entities2.setPlanSummary("4");
                }else if (entities2.getPlanSummary().equals("五月")){
                    entities2.setPlanSummary("5");
                }else if (entities2.getPlanSummary().equals("六月(二季度)")){
                    entities2.setPlanSummary("6");
                }else if (entities2.getPlanSummary().equals("七月")){
                    entities2.setPlanSummary("7");
                }else if (entities2.getPlanSummary().equals("八月")){
                    entities2.setPlanSummary("8");
                }else if (entities2.getPlanSummary().equals("九月(三季度)")){
                    entities2.setPlanSummary("9");
                }else if (entities2.getPlanSummary().equals("十月")){
                    entities2.setPlanSummary("10");
                }else if (entities2.getPlanSummary().equals("十一月")){
                    entities2.setPlanSummary("11");
                }else if (entities2.getPlanSummary().equals("十二月")){
                    entities2.setPlanSummary("12");
                }else if (entities2.getPlanSummary().equals("年度总结")){
                    entities2.setPlanSummary("13");
                }
            }
            return CommonResponse.success("查询数据成功！", entities1);
        }


    }

    /**
     * @Description queryDetail 复制
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectPlanVO> queryCopyDetail(Long id) {
        ProjectPlanEntity entity = service.selectById(id);
        ProjectPlanVO vo = BeanMapper.map(entity, ProjectPlanVO.class);
        vo.setBillCode(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setBillState(null);
        vo.setDr(null);
        vo.setId(IdWorker.getId());
        vo.setOldId(id);
        vo.setYear(null);
        vo.setPlanSummaryId(null);
        vo.setStatus(null);
        vo.setNewId(null);
        CommonResponse<String> response = iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                id.toString(),
                "BT220304000000001",
                "imgUpload",
                vo.getId().toString(),
                "BT220304000000001",
                "imgUpload"
        );
        if(!response.isSuccess()){
            return CommonResponse.error(response.getMsg());
        }
        vo.setId(null);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectPlanVO> queryDetail(Long id) {
    	ProjectPlanEntity entity = service.selectById(id);
    	ProjectPlanVO vo = BeanMapper.map(entity, ProjectPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectPlanVO> vos) {
        service.removeByIds(vos.stream().map(ProjectPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectPlanVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("peojectPlanProgress");
        fuzzyFields.add("signDate");
        fuzzyFields.add("createTime");
        fuzzyFields.add("billState");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            //** 要求主表有orgId字段，保存单据所属组织 *//*
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            //** 要求主表有projectDepartmentId字段，保存单据所属项目部 *//*
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<ProjectPlanEntity> page = service.queryPage(param,false);
        IPage<ProjectPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPlanVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectPlanVO>> refProjectPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectPlanEntity> page = service.queryPage(param,false);
        IPage<ProjectPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
