package com.ejianc.business.market.service.impl;

import com.ejianc.business.market.bean.ProjectBiddingEntity;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.mapper.ProjectBiddingMapper;
import com.ejianc.business.market.service.IProjectBiddingService;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 项目中标告知单
 * 
 * @author generator
 * 
 */
@Service("projectBiddingService")
public class ProjectBiddingServiceImpl extends BaseServiceImpl<ProjectBiddingMapper, ProjectBiddingEntity> implements IProjectBiddingService{

    @Autowired
    private IProjectRegisterService registerService;

    @Override
    public Long queryContractByProject(Long projectId) {
        ProjectRegisterEntity projectRegisterEntity = registerService.queryById(projectId);

        ProjectBiddingEntity biddingEntity = this.selectById(projectRegisterEntity.getBidProjectId());
        if (biddingEntity == null) {
            throw  new BusinessException("当前项目未做项目中标告知单！");
        }

        return biddingEntity.getId();

    }
}
