/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/project/"})
public class ProjectApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectRegisterService projectRegisterService;

    @GetMapping(value={"queryProjectBySourceId"})
    public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(@RequestParam(value="sourceId") String sourceId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectRegisterService.getOne((Wrapper)queryWrapper));
        if (entity != null) {
            vo = (ProjectRegisterVO)BeanMapper.map((Object)((Object)entity), ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryProjectDetail"})
    public CommonResponse<ProjectRegisterVO> queryProjectDetail(@RequestParam(value="projectId") Long projectId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectRegisterService.selectById(projectId));
        if (entity != null) {
            vo = (ProjectRegisterVO)BeanMapper.map((Object)((Object)entity), ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryProjectByProjectDepartmentId"})
    public CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(@RequestParam(value="projectDepartmentId") Long projectDepartmentId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_department_id", (Object)projectDepartmentId);
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectRegisterService.getOne((Wrapper)queryWrapper));
        if (entity != null) {
            vo = (ProjectRegisterVO)BeanMapper.map((Object)((Object)entity), ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryProjectByIds"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(@RequestParam(value="ids") List<Long> ids) {
        List vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.projectRegisterService.list((Wrapper)queryWrapper);
        if (entitys != null) {
            vos = BeanMapper.mapList((Iterable)entitys, ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @GetMapping(value={"getProjectIdsByProperties"})
    CommonResponse<List<Long>> getProjectIdsByProperties(@RequestParam(value="projectRange") int projectRange) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean queryNewSigned = false;
        if (projectRange == 2 || projectRange == 3) {
            queryParam.getParams().put("status", new Parameter("eq", (Object)projectRange));
        } else if (projectRange == 4) {
            queryNewSigned = true;
        }
        return CommonResponse.success(this.projectRegisterService.queryProIdsByProperties(queryParam, queryNewSigned));
    }

    @GetMapping(value={"getProjectIdsByEngineeringType"})
    CommonResponse<List<Long>> getProjectIdsByEngineeringType(@RequestParam(value="projectRange") int projectRange, @RequestParam(value="engineeringType", required=false) Long engineeringType) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean queryNewSigned = false;
        if (projectRange == 2 || projectRange == 3) {
            queryParam.getParams().put("status", new Parameter("eq", (Object)projectRange));
        } else if (projectRange == 4) {
            queryNewSigned = true;
        }
        if (null != engineeringType) {
            queryParam.getParams().put("engineeringType", new Parameter("eq", (Object)engineeringType));
        }
        return CommonResponse.success(this.projectRegisterService.queryProIdsByProperties(queryParam, queryNewSigned));
    }

    @GetMapping(value={"getDataByName"})
    public CommonResponse<ProjectRegisterVO> getDataByName(@RequestParam(value="projectName") String projectName) {
        ProjectRegisterVO vo = this.projectRegisterService.getDataByName(projectName);
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"saveContractMny"})
    public CommonResponse<ProjectRegisterVO> saveContractMny(@RequestParam(value="id") Long id, @RequestParam(value="contractTaxMny") BigDecimal contractTaxMny, @RequestParam(value="contractMny") BigDecimal contractMny, Long contractId) {
        return this.projectRegisterService.saveContractMny(id, contractTaxMny, contractMny, contractId);
    }

    @PostMapping(value={"updProject"})
    public CommonResponse<String> updProject(@RequestBody ProjectRegisterVO projectRegisterVO) {
        return this.projectRegisterService.updProject(projectRegisterVO);
    }

    @GetMapping(value={"queryProjectByPid"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByPid(@RequestParam(value="pid") Long pid) {
        List vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"parent_id", (Object)pid);
        List entitys = this.projectRegisterService.list((Wrapper)queryWrapper);
        if (entitys != null) {
            vos = BeanMapper.mapList((Iterable)entitys, ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @PostMapping(value={"syncProject"})
    public CommonResponse<ProjectRegisterVO> syncProject(@RequestBody ProjectRegisterVO projectRegisterVO) {
        return this.projectRegisterService.syncProject(projectRegisterVO);
    }

    @PostMapping(value={"updateProjectByBidCost"})
    public CommonResponse<String> updateProjectByBidCost(@RequestBody ProjectRegisterVO projectRegisterVO) {
        return this.projectRegisterService.updateProjectByBidCost(projectRegisterVO);
    }
}

