package com.ejianc.business.market.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.bean.ProjectSubEntity;
import com.ejianc.business.market.service.IProjectSubService;
import com.ejianc.business.market.vo.ProjectSubVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/no_auth/api/project/")
public class NoAuthProjectApi {

    @Autowired
    private IProjectSubService projectSubService;

    /**
     * 根据项目查对应的局内分包项目
     * @param projectIds
     * @return
     */
    @PostMapping(value = "queryProjectSub")
    CommonResponse<Map<Long,List<ProjectSubVO>>> queryProjectSub(@RequestBody List<Long> projectIds){
        Map<Long,List<ProjectSubVO>> resMap = new HashMap<>();
        if(projectIds == null || projectIds.size() <= 0){
			return CommonResponse.success(resMap);
		}
        LambdaQueryWrapper<ProjectSubEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ProjectSubEntity::getDr, 0);
        lambda.in(ProjectSubEntity::getMainProjectId, projectIds);
        List<ProjectSubEntity> projectSubList = projectSubService.list(lambda);
        List<ProjectSubVO> projectSubVos = BeanMapper.mapList(projectSubList,ProjectSubVO.class);
        for(ProjectSubVO vo : projectSubVos){
            if(resMap.containsKey(vo.getMainProjectId())){
                List<ProjectSubVO> list = resMap.get(vo.getMainProjectId());
                list.add(vo);
                resMap.put(vo.getMainProjectId(),list);
            }else{
                List<ProjectSubVO> list = new ArrayList<>();
                list.add(vo);
                resMap.put(vo.getMainProjectId(),list);
            }
        }
        return CommonResponse.success(resMap);
    }
}
