package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.market.mapper.ProjectSubMapper;
import com.ejianc.business.market.bean.ProjectSubEntity;
import com.ejianc.business.market.service.IProjectSubService;

/**
 * 局内分包
 *
 * @author generator
 *
 */
@Service("projectSubService")
public class ProjectSubServiceImpl extends BaseServiceImpl<ProjectSubMapper, ProjectSubEntity> implements IProjectSubService{

    @Override
    public void delSubById(Long projectId) {
        LambdaUpdateWrapper<ProjectSubEntity> lambd = new LambdaUpdateWrapper<>();
        lambd.set(ProjectSubEntity::getDr,1);
        lambd.and(wq -> wq
                .eq(ProjectSubEntity::getMainProjectId,projectId)
                .or()
                .eq(ProjectSubEntity::getProjectId,projectId));
        super.update(lambd);
    }
}
