/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/project/"})
public class ProjectApi {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectRegisterService projectRegisterService;

    @GetMapping(value={"queryProjectBySourceId"})
    public CommonResponse<ProjectRegisterVO> queryProjectBySourceId(@RequestParam(value="sourceId") String sourceId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectRegisterService.getOne((Wrapper)queryWrapper));
        if (entity != null) {
            vo = (ProjectRegisterVO)BeanMapper.map((Object)((Object)entity), ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryProjectByProjectDepartmentId"})
    public CommonResponse<ProjectRegisterVO> queryProjectByProjectDepartmentId(@RequestParam(value="projectDepartmentId") Long projectDepartmentId) {
        ProjectRegisterVO vo = new ProjectRegisterVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_department_id", (Object)projectDepartmentId);
        ProjectRegisterEntity entity = (ProjectRegisterEntity)((Object)this.projectRegisterService.getOne((Wrapper)queryWrapper));
        if (entity != null) {
            vo = (ProjectRegisterVO)BeanMapper.map((Object)((Object)entity), ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryProjectByIds"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByIds(@RequestBody List<Long> ids) {
        List vos = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", ids);
        List entitys = this.projectRegisterService.list((Wrapper)queryWrapper);
        if (entitys != null) {
            vos = BeanMapper.mapList((Iterable)entitys, ProjectRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    @GetMapping(value={"getProjectIdsByProperties"})
    CommonResponse<List<Long>> getProjectIdsByProperties(@RequestParam(value="projectRange") int projectRange) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("validStatus", new Parameter("eq", (Object)0));
        boolean queryNewSigned = false;
        if (projectRange == 2 || projectRange == 3) {
            queryParam.getParams().put("status", new Parameter("eq", (Object)projectRange));
        } else if (projectRange == 4) {
            queryNewSigned = true;
        }
        return CommonResponse.success(this.projectRegisterService.queryProIdsByProperties(queryParam, queryNewSigned));
    }

    @GetMapping(value={"queryProjectByUserId"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectByUserId(@RequestParam(value="userId") Long userId) {
        return this.projectRegisterService.queryProjectByUserId(userId);
    }

    @GetMapping(value={"queryProjectList"})
    public CommonResponse<List<ProjectRegisterVO>> queryProjectList(@RequestParam(value="num", defaultValue="10") int num) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(num);
        queryParam.setPageIndex(1);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse response = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        List orgVOList = (List)response.getData();
        if (!response.isSuccess()) {
            return CommonResponse.error((String)"\u672c\u4e0b\u7ec4\u7ec7\u67e5\u8be2\u5931\u8d25\uff01");
        }
        queryParam.getParams().put("projectDepartmentId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("validStatus", new Parameter("eq", (Object)0));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage page = this.projectRegisterService.queryPage(queryParam, false);
        System.out.println("\u67e5\u8be2\u672c\u4e0b\u542f\u7528\u7684\u9879\u76ee\uff0c\u53c2\u6570\u4e3a\u9700\u8981\u67e5\u8be2\u7684\u6761\u6570\uff0c\u9ed8\u8ba4\u5341\u6761 page.getTotal = " + page.getTotal());
        List res = BeanMapper.mapList((Iterable)page.getRecords(), ProjectRegisterVO.class);
        System.out.println("\u67e5\u8be2\u672c\u4e0b\u542f\u7528\u7684\u9879\u76ee\uff0c\u53c2\u6570\u4e3a\u9700\u8981\u67e5\u8be2\u7684\u6761\u6570\uff0c\u9ed8\u8ba4\u5341\u6761 res.size = " + res.size());
        return CommonResponse.success((Object)res);
    }

    @PostMapping(value={"queryProjectPage"})
    public CommonResponse<Page<ProjectRegisterVO>> queryProjectPage(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse response = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        List orgVOList = (List)response.getData();
        if (!response.isSuccess()) {
            return CommonResponse.error((String)"\u672c\u4e0b\u7ec4\u7ec7\u67e5\u8be2\u5931\u8d25\uff01");
        }
        queryParam.getParams().put("projectDepartmentId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("validStatus", new Parameter("eq", (Object)0));
        queryParam.getOrderMap().putIfAbsent("createTime", "desc");
        IPage pageData = this.projectRegisterService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        if (pageData.getTotal() > 0L) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ProjectRegisterVO.class);
            result.setRecords(list);
        }
        return CommonResponse.success((Object)result);
    }

    @GetMapping(value={"queryChildrenProjectByOrgId"})
    CommonResponse<List<ProjectRegisterVO>> queryChildrenProjectByOrgId(@RequestParam(value="orgId") Long orgId) {
        ArrayList<Long> departmentIdList = new ArrayList<Long>();
        List result = new ArrayList();
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        if (childOrgResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)childOrgResp.getData()))) {
            for (OrgVO orgVO : (List)childOrgResp.getData()) {
                if (null == orgVO.getOrgType() || orgVO.getOrgType() != 5) continue;
                departmentIdList.add(orgVO.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(departmentIdList)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(ProjectRegisterEntity::getProjectDepartmentId, departmentIdList);
            List list = this.projectRegisterService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                result = BeanMapper.mapList((Iterable)list, ProjectRegisterVO.class);
            }
        }
        return CommonResponse.success(result);
    }

    @GetMapping(value={"queryProjects"})
    CommonResponse<List<Map>> queryProjects(@RequestParam(value="orgId") Long orgId, @RequestParam(value="statusList", required=false) List<String> statusList, @RequestParam(value="focusTypeList", required=false) List<String> focusTypeList, @RequestParam(value="engineeringTypeList", required=false) List<Long> engineeringTypeList, @RequestParam(value="searchText", required=false) String searchText) {
        ArrayList<Long> departmentIdList = new ArrayList<Long>();
        ArrayList result = new ArrayList();
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        if (childOrgResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)childOrgResp.getData()))) {
            for (OrgVO orgVO : (List)childOrgResp.getData()) {
                if (null == orgVO.getOrgType() || orgVO.getOrgType() != 5) continue;
                departmentIdList.add(orgVO.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(departmentIdList)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("dr", new Parameter("eq", (Object)0));
            queryParam.getParams().put("projectDepartmentId", new Parameter("in", departmentIdList));
            if (statusList != null && statusList.size() > 0) {
                queryParam.getParams().put("status", new Parameter("in", statusList));
            }
            if (focusTypeList != null && focusTypeList.size() > 0) {
                queryParam.getParams().put("focusType", new Parameter("in", focusTypeList));
            }
            if (engineeringTypeList != null && engineeringTypeList.size() > 0) {
                queryParam.getParams().put("engineeringType", new Parameter("in", engineeringTypeList));
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                queryParam.setSearchText(searchText);
                queryParam.getFuzzyFields().add("name");
                queryParam.getFuzzyFields().add("projectManagerName");
            }
            queryParam.getOrderMap().put("createTime", "desc");
            List list = this.projectRegisterService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (ProjectRegisterEntity entity : list) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", entity.getId());
                    map.put("name", entity.getName());
                    map.put("lat", entity.getLat());
                    map.put("lng", entity.getLng());
                    map.put("focusType", entity.getFocusType());
                    map.put("projectDepartmentId", entity.getProjectDepartmentId());
                    map.put("engineeringTypeName", entity.getEngineeringTypeName());
                    map.put("projectManagerName", entity.getProjectManagerName());
                    result.add(map);
                }
            }
        }
        return CommonResponse.success(result);
    }
}

