package com.ejianc.business.material.api;

import com.ejianc.business.material.hystrix.MaterialInstoreHystrix;
import com.ejianc.business.material.vo.InstoreAccountSumVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author songlx
 * @description: 物资入库数量查询
 * @date: 2021/9/11
 */
@FeignClient(name = "ejc-material-web", url = "${common.env.feign-client-url}", path = "ejc-material-web", fallback = MaterialInstoreHystrix.class)
public interface IMaterialInstoreApi {

    /**
     * 物资入库数量查询
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "/api/materialInstore/instoreNumCount")
    CommonResponse<List<InstoreMaterialVO>> instoreNumCount(@RequestBody Map<String, Object> queryParam);

    @PostMapping(value = "/api/materialInstore/materialFinishCount")
    CommonResponse<List<UseApplyFinishVO>> materialFinishCount(@RequestBody Map<String, Object> queryParam);


    /***
     * @description: 按项目合计物资入库金额
     * @param projectIds
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.business.material.vo.InstoreMaterialVO>>
     * @author songlx
     * @date: 2021/10/25
     */
    @PostMapping(value = "/api/materialInstore/amountSum")
    CommonResponse<List<InstoreAccountSumVO>> amountSum(@RequestParam("projectIds") List<Long> projectIds);

}
