package com.ejianc.business.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.material.vo.PickRegisterDetailVO;

/**
 * 领料登记
 * 
 * @author generator
 * 
 */
public class PickRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 申请单号
    private Long orgId; // 所属项目部
    private String orgName; // 所属项目部名称
    private String orgCode; // 所属项目部编码
    private Long parentOrgId; // 组织
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private Long projectId; // 项目名称参照
    private String projectName; // 项目名称
    private Long supplierId; // 领料单位
    private String supplierName; // 领料单位名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String memo; // 备注
    private BigDecimal totalDeductMny; // 累计已扣金额
    private String createTimeStr;
    
    private List<PickRegisterDetailVO> pickRegisterDetailList = new ArrayList<>(); // 领料登记明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getTotalDeductMny() {
        return totalDeductMny;
    }

    public void setTotalDeductMny(BigDecimal totalDeductMny) {
        this.totalDeductMny = totalDeductMny;
    }

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public void setCreateTimeStr(String createTimeStr) {
        this.createTimeStr = createTimeStr;
    }

    public List<PickRegisterDetailVO> getPickRegisterDetailList() {
        return pickRegisterDetailList;
     }

     public void setPickRegisterDetailList(List<PickRegisterDetailVO> pickRegisterDetailList) {
        this.pickRegisterDetailList = pickRegisterDetailList;
     }
}
