package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.bean.ContractRecordEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IContractRecordService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.ContractRecordVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description: 合同变更记录
 * @date 2020/6/13 14:38
 */
@RestController
@RequestMapping("/changeRecord/")
public class MaterialContractRecordController {

    @Autowired
    private IContractRecordService contractRecordService;

    @Autowired
    private IContractChangeService contractChangeService;

    @Autowired
    private IMaterialContractService materialContractService;

    /**
     * 查询合同变更记录
     *
     * @param id 变更合同Id
     * @return
     */
    @GetMapping("queryRecords")
    public CommonResponse<JSONObject> queryRecords(@RequestParam(value = "id") Long id) {
        JSONObject data = new JSONObject();
        List<ContractRecordVO> list = new ArrayList<>();

        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("effectiveDate", QueryParam.DESC);
        queryParam.getParams().put("material_contract_id", new Parameter(QueryParam.EQ, id));

        List<ContractRecordEntity> changeRecords = contractRecordService.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(changeRecords)) {
            list = BeanMapper.mapList(changeRecords, ContractRecordVO.class);
            ContractRecordVO lastRecord = list.get(0);
            data.put("baseAmountWithTax", lastRecord.getBaseTaxMoney());
            data.put("changingTaxMny", lastRecord.getChangingTaxMny());
            //data.put("changeAmount", lastRecord.getChangingTaxMny().subtract(lastRecord.getAmountWithTax()));
            data.put("changeAmount", BigDecimalUtils.safeSub(lastRecord.getChangingTaxMny(),lastRecord.getAmountWithTax()));
            data.put("changeCount", list.size());
            data.put("totalChangeRate", lastRecord.calculateTotalChangeRatio());
        }
        MaterialContractEntity contract = materialContractService.selectById(id);
        data.put("isChanging", (null != contract.getChangeState() && MaterialContractVO.CONTRACT_CHANGE_STATE_CHANGING.equals(contract.getChangeState())));
        data.put("contractId", contract.getId());
        data.put("id", contract.getId());
        data.put("state", contract.getState());
        data.put("changeRecords", list);

        return CommonResponse.success("查询合同变更记录成功！", data);
    }

    @GetMapping("queryDetail")
    public CommonResponse<ContractRecordVO> queryDetail(@RequestParam(value = "id") Long id) {
        ContractRecordEntity entity = contractRecordService.selectById(id);
        return CommonResponse.success("查询成功！", BeanMapper.map(entity, ContractRecordVO.class));
    }

}
