package com.ejianc.business.material.vo;

import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/10 采购结算单 主表
 * @Description PurchaseSettlementVO
 */
public class PurchaseSettlementRefVO extends BaseVO {
    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 结算编号
     */
    private String billCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合同id
     */
    private Long contractId;

    /**
     * 合同采购方式
     */
    private String purchaseMethod;

    /**
     * 属于项目 ？ 1是，0不是
     */
    private String belongToProject;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目名称参照
     */
    private Long projectId;

    /**
     * 所属组织名称
     */
    private String orgName;

    /**
     * 所属组织参照
     */
    private Long orgId;

    /**
     * 结算日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementDate;

    /**
     * 本期结算金额（含税）
     */
    private String currentSettlementAmountTax;

    /**
     * 累计预付款
     */
    private String accumulatedAdvancePayment;

    /**
     * 本期冲抵金额
     */
    private String offsetAmountInCurrentPeriod;

    /**
     * 剩余冲抵金额
     */
    private String remainingOffsetAmount;

    /**
     * 备注
     */
    private String memo;

    /**
     * 编制人
     */
    private String creatorName;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 合同金额
     */
    private String contractAmount;

    /**
     * 税率
     */
    private String taxRate;

    /**
     * 本期结算金额（不含税）
     */
    private String currentSettlementAmount;

    /**
     * 税金
     */
    private String tax;

    /**
     * 累计已结算金额
     */
    private String settledAmount;

    /**
     * 已结算比例
     */
    private String settledProportion;

    /**
     * 累计申请金额(资金返写)
     */
    private String currentApplyAmount;

    /**
     * 剩余可以申请金额
     */
    private String remainCanApplyAmount;

    /**
     * 已付金额(该合同截止到本期已付金额)
     */
    private String currentPaidAmount;

    /**
     * 已付金额
     */
    private String paidAmount;

    /**
     * 已付比例
     */
    private String paidProportion;
    /**
     * 合同类型  5 物资
     */
    private Integer settleType;

    private List<PurchaseSettlementMaterialDetailVO> materialDetails = new ArrayList<>();

    private List<PurchaseSettlementOtherFeeVO> feeEntities = new ArrayList<>();

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="materialContract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(String purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }

    public String getBelongToProject() {
        return belongToProject;
    }

    public void setBelongToProject(String belongToProject) {
        this.belongToProject = belongToProject;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }

    public String getCurrentSettlementAmountTax() {
        return currentSettlementAmountTax;
    }

    public void setCurrentSettlementAmountTax(String currentSettlementAmountTax) {
        this.currentSettlementAmountTax = currentSettlementAmountTax;
    }

    public String getAccumulatedAdvancePayment() {
        return accumulatedAdvancePayment;
    }

    public void setAccumulatedAdvancePayment(String accumulatedAdvancePayment) {
        this.accumulatedAdvancePayment = accumulatedAdvancePayment;
    }

    public String getOffsetAmountInCurrentPeriod() {
        return offsetAmountInCurrentPeriod;
    }

    public void setOffsetAmountInCurrentPeriod(String offsetAmountInCurrentPeriod) {
        this.offsetAmountInCurrentPeriod = offsetAmountInCurrentPeriod;
    }

    public String getRemainingOffsetAmount() {
        return remainingOffsetAmount;
    }

    public void setRemainingOffsetAmount(String remainingOffsetAmount) {
        this.remainingOffsetAmount = remainingOffsetAmount;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(String contractAmount) {
        this.contractAmount = contractAmount;
    }

    public String getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    public String getCurrentSettlementAmount() {
        return currentSettlementAmount;
    }

    public void setCurrentSettlementAmount(String currentSettlementAmount) {
        this.currentSettlementAmount = currentSettlementAmount;
    }

    public String getTax() {
        return tax;
    }

    public void setTax(String tax) {
        this.tax = tax;
    }

    public String getSettledAmount() {
        return settledAmount;
    }

    public void setSettledAmount(String settledAmount) {
        this.settledAmount = settledAmount;
    }

    public String getSettledProportion() {
        return settledProportion;
    }

    public void setSettledProportion(String settledProportion) {
        this.settledProportion = settledProportion;
    }

    public String getCurrentApplyAmount() {
        return currentApplyAmount;
    }

    public void setCurrentApplyAmount(String currentApplyAmount) {
        this.currentApplyAmount = currentApplyAmount;
    }

    public String getRemainCanApplyAmount() {
        return remainCanApplyAmount;
    }

    public void setRemainCanApplyAmount(String remainCanApplyAmount) {
        this.remainCanApplyAmount = remainCanApplyAmount;
    }

    public String getCurrentPaidAmount() {
        return currentPaidAmount;
    }

    public void setCurrentPaidAmount(String currentPaidAmount) {
        this.currentPaidAmount = currentPaidAmount;
    }

    public String getPaidAmount() {
        return paidAmount;
    }

    public void setPaidAmount(String paidAmount) {
        this.paidAmount = paidAmount;
    }

    public String getPaidProportion() {
        return paidProportion;
    }

    public void setPaidProportion(String paidProportion) {
        this.paidProportion = paidProportion;
    }

    public List<PurchaseSettlementMaterialDetailVO> getMaterialDetails() {
        return materialDetails;
    }

    public void setMaterialDetails(List<PurchaseSettlementMaterialDetailVO> materialDetails) {
        this.materialDetails = materialDetails;
    }

    public List<PurchaseSettlementOtherFeeVO> getFeeEntities() {
        return feeEntities;
    }

    public void setFeeEntities(List<PurchaseSettlementOtherFeeVO> feeEntities) {
        this.feeEntities = feeEntities;
    }

    public String getBillStateName() {
        return BillStateEnum.getEnumByStateCode(this.billState).getDescription();
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }
}
